/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.QuercusException;
import com.caucho.quercus.QuercusRuntimeException;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BinaryBuilderValue;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Callable;
import com.caucho.quercus.env.CallbackError;
import com.caucho.quercus.env.CharSequenceInputStream;
import com.caucho.quercus.env.CopyRoot;
import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.FieldVisibility;
import com.caucho.quercus.env.JsonEncodeContext;
import com.caucho.quercus.env.LargeStringBuilderValue;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.NumberValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.QuercusLanguageException;
import com.caucho.quercus.env.ResourceValue;
import com.caucho.quercus.env.SerializeMap;
import com.caucho.quercus.env.StringBuilderValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnicodeBuilderValue;
import com.caucho.quercus.env.UnsetValue;
import com.caucho.quercus.env.ValueType;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.function.AbstractFunction;
import com.caucho.quercus.program.ClassField;
import com.caucho.util.L10N;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Value
implements Serializable {
    protected static final L10N L = new L10N(Value.class);
    private static final Value[] NULL_ARG_VALUES = new Value[0];
    public static final Value[] NULL_VALUE_ARRAY = new Value[0];
    public static final Value[] NULL_ARGS = new Value[0];

    public String getClassName() {
        return this.getType();
    }

    public QuercusClass getQuercusClass() {
        return null;
    }

    public QuercusClass findQuercusClass(Env env) {
        QuercusClass cls = this.getQuercusClass();
        if (cls != null) {
            return cls;
        }
        String name = this.toString();
        return env.getClass(name);
    }

    public Value getCalledClass(Env env) {
        QuercusClass qClass = this.getQuercusClass();
        if (qClass != null) {
            return env.createString(qClass.getName());
        }
        env.warning(L.l("get_called_class() must be called in a class context"));
        return BooleanValue.FALSE;
    }

    public boolean isA(Env env, String name) {
        return false;
    }

    public final boolean isA(Env env, Value value) {
        if (value.isObject()) {
            return this.isA(env, value.getClassName());
        }
        if (value instanceof QuercusClass) {
            return this.isA(env, value.getClassName());
        }
        return this.isA(env, value.toJavaString());
    }

    public void checkProtected(Env env, String className) {
    }

    public void checkPrivate(Env env, String className) {
    }

    public ValueType getValueType() {
        return ValueType.VALUE;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isDoubleConvertible() {
        return false;
    }

    public boolean isLongConvertible() {
        return false;
    }

    public boolean isLong() {
        return false;
    }

    public boolean isDouble() {
        return false;
    }

    public boolean isNull() {
        return false;
    }

    public boolean isNumberConvertible() {
        return this.isLongConvertible() || this.isDoubleConvertible();
    }

    public boolean isNumeric() {
        return false;
    }

    public boolean isObject() {
        return false;
    }

    public boolean isResource() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public boolean isBinary() {
        return false;
    }

    public boolean isUnicode() {
        return false;
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean isDefault() {
        return false;
    }

    public int toBooleanMarshalCost() {
        return 380;
    }

    public int toByteMarshalCost() {
        return 400;
    }

    public int toShortMarshalCost() {
        return 400;
    }

    public int toIntegerMarshalCost() {
        return 400;
    }

    public int toLongMarshalCost() {
        return 400;
    }

    public int toDoubleMarshalCost() {
        return 400;
    }

    public int toFloatMarshalCost() {
        return this.toDoubleMarshalCost() + 10;
    }

    public int toCharMarshalCost() {
        return 360;
    }

    public int toStringMarshalCost() {
        return 350;
    }

    public int toByteArrayMarshalCost() {
        return 390;
    }

    public int toCharArrayMarshalCost() {
        return 355;
    }

    public int toJavaObjectMarshalCost() {
        return 320;
    }

    public int toBinaryValueMarshalCost() {
        return 351;
    }

    public int toStringValueMarshalCost() {
        return 351;
    }

    public int toUnicodeValueMarshalCost() {
        return 351;
    }

    public boolean isset() {
        return true;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isEmpty(Env env, Value index) {
        return this.isEmpty();
    }

    public boolean hasCurrent() {
        return false;
    }

    public Value eqValue(Value rValue) {
        return this.eq(rValue) ? BooleanValue.TRUE : BooleanValue.FALSE;
    }

    public boolean eq(Value rValue) {
        if (rValue.isArray()) {
            return false;
        }
        if (rValue.isObject()) {
            return rValue.eq(this);
        }
        if (rValue.isBoolean()) {
            return this.toBoolean() == rValue.toBoolean();
        }
        if (this.isLongConvertible() && rValue.isLongConvertible()) {
            return this.toLong() == rValue.toLong();
        }
        if (this.isNumberConvertible() || rValue.isNumberConvertible()) {
            return this.toDouble() == rValue.toDouble();
        }
        return this.toString().equals(rValue.toString());
    }

    public boolean eql(Value rValue) {
        return this == rValue.toValue();
    }

    public int cmp(Value rValue) {
        Value lVal = this.toValue();
        Value rVal = rValue.toValue();
        if (lVal instanceof StringValue && rVal instanceof NullValue) {
            return ((StringValue)lVal).cmpString(StringValue.EMPTY);
        }
        if (lVal instanceof NullValue && rVal instanceof StringValue) {
            return StringValue.EMPTY.cmpString((StringValue)rVal);
        }
        if (lVal instanceof StringValue && rVal instanceof StringValue) {
            return ((StringValue)lVal).cmpString((StringValue)rVal);
        }
        if (lVal instanceof NullValue || lVal instanceof BooleanValue || rVal instanceof NullValue || rVal instanceof BooleanValue) {
            boolean lBool = this.toBoolean();
            boolean rBool = rValue.toBoolean();
            if (!lBool && rBool) {
                return -1;
            }
            if (lBool && !rBool) {
                return 1;
            }
            return 0;
        }
        if (lVal.isObject() && rVal.isObject()) {
            return ((ObjectValue)lVal).cmpObject((ObjectValue)rVal);
        }
        if ((lVal instanceof StringValue || lVal instanceof NumberValue || lVal instanceof ResourceValue) && (rVal instanceof StringValue || rVal instanceof NumberValue || rVal instanceof ResourceValue)) {
            return NumberValue.compareNum(lVal, rVal);
        }
        if (lVal instanceof ArrayValue) {
            return 1;
        }
        if (rVal instanceof ArrayValue) {
            return -1;
        }
        if (lVal instanceof ObjectValue) {
            return 1;
        }
        if (rVal instanceof ObjectValue) {
            return -1;
        }
        throw new RuntimeException("values are incomparable: " + lVal + " <=> " + rVal);
    }

    public boolean lt(Value rValue) {
        return this.cmp(rValue) < 0;
    }

    public boolean leq(Value rValue) {
        return this.cmp(rValue) <= 0;
    }

    public boolean gt(Value rValue) {
        return this.cmp(rValue) > 0;
    }

    public boolean geq(Value rValue) {
        return this.cmp(rValue) >= 0;
    }

    public static long toLong(boolean b) {
        return b ? 1L : 0L;
    }

    public static long toLong(double d) {
        return (long)d;
    }

    public static long toLong(long l) {
        return l;
    }

    public static long toLong(CharSequence s) {
        return StringValue.parseLong(s);
    }

    public static double toDouble(boolean b) {
        return b ? 1.0 : 0.0;
    }

    public static double toDouble(double d) {
        return d;
    }

    public static double toDouble(long l) {
        return l;
    }

    public static double toDouble(CharSequence s) {
        return StringValue.toDouble(((Object)s).toString());
    }

    public boolean toBoolean() {
        return true;
    }

    public long toLong() {
        return this.toBoolean() ? 1L : 0L;
    }

    public int toInt() {
        return (int)this.toLong();
    }

    public double toDouble() {
        return 0.0;
    }

    public char toChar() {
        String s = this.toString();
        if (s == null || s.length() < 1) {
            return '\u0000';
        }
        return s.charAt(0);
    }

    public StringValue toString(Env env) {
        return this.toStringValue(env);
    }

    public ArrayValue toArray() {
        return new ArrayValueImpl().append(this);
    }

    public Value toAutoArray() {
        Env.getCurrent().warning(L.l("'{0}' cannot be used as an array.", (Object)this.toDebugString()));
        return this;
    }

    public ArrayValue toArrayValue(Env env) {
        env.warning(L.l("'{0}' ({1}) is not assignable to ArrayValue", (Object)this, (Object)this.getType()));
        return null;
    }

    public Value toAutoObject(Env env) {
        return this;
    }

    public Value toObject(Env env) {
        ObjectValue obj = env.createObject();
        obj.putField(env, env.createString("scalar"), this);
        return obj;
    }

    public Object toJavaObject() {
        return null;
    }

    public Object toJavaObject(Env env, Class<?> type) {
        env.warning(L.l("Can't convert {0} to Java {1}", (Object)this.getClass().getName(), (Object)type.getName()));
        return null;
    }

    public Object toJavaObjectNotNull(Env env, Class<?> type) {
        env.warning(L.l("Can't convert {0} to Java {1}", (Object)this.getClass().getName(), (Object)type.getName()));
        return null;
    }

    public Boolean toJavaBoolean() {
        return this.toBoolean() ? Boolean.TRUE : Boolean.FALSE;
    }

    public Byte toJavaByte() {
        return new Byte((byte)this.toLong());
    }

    public Short toJavaShort() {
        return new Short((short)this.toLong());
    }

    public Integer toJavaInteger() {
        return new Integer((int)this.toLong());
    }

    public Long toJavaLong() {
        return new Long((int)this.toLong());
    }

    public Float toJavaFloat() {
        return new Float((float)this.toDouble());
    }

    public Double toJavaDouble() {
        return new Double(this.toDouble());
    }

    public Character toJavaCharacter() {
        return new Character(this.toChar());
    }

    public String toJavaString() {
        return this.toString();
    }

    public Collection<?> toJavaCollection(Env env, Class<?> type) {
        env.warning(L.l("Can't convert {0} to Java {1}", (Object)this.getClass().getName(), (Object)type.getName()));
        return null;
    }

    public List<?> toJavaList(Env env, Class<?> type) {
        env.warning(L.l("Can't convert {0} to Java {1}", (Object)this.getClass().getName(), (Object)type.getName()));
        return null;
    }

    public Map<?, ?> toJavaMap(Env env, Class<?> type) {
        env.warning(L.l("Can't convert {0} to Java {1}", (Object)this.getClass().getName(), (Object)type.getName()));
        return null;
    }

    public Calendar toJavaCalendar() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.toLong());
        return cal;
    }

    public Date toJavaDate() {
        return new Date(this.toLong());
    }

    public URL toJavaURL(Env env) {
        try {
            return new URL(this.toString());
        }
        catch (MalformedURLException e) {
            env.warning(e.getMessage());
            return null;
        }
    }

    public Enum toJavaEnum(Env env, Class cls) {
        String s = this.toString();
        if (s == null) {
            return null;
        }
        try {
            return Enum.valueOf(cls, s);
        }
        catch (IllegalArgumentException e) {
            env.warning(e);
            return null;
        }
    }

    public BigDecimal toBigDecimal() {
        return new BigDecimal(this.toString());
    }

    public BigInteger toBigInteger() {
        return new BigInteger(this.toString());
    }

    public QuercusException toException(Env env, String file, int line) {
        this.putField(env, env.createString("file"), (Value)env.createString(file));
        this.putField(env, env.createString("line"), (Value)LongValue.create(line));
        return new QuercusLanguageException(this);
    }

    public Value toValue() {
        return this;
    }

    public Value toKey() {
        throw new QuercusRuntimeException(L.l("{0} is not a valid key", (Object)this));
    }

    public Value toRef() {
        return this;
    }

    public Value toLocalValueReadOnly() {
        return this;
    }

    public Value toLocalValue() {
        return this;
    }

    public Value toLocalRef() {
        return this;
    }

    public Var toLocalVar() {
        return this.toLocalRef().toVar();
    }

    public Var toLocalVarDeclAsRef() {
        return new Var(this);
    }

    public Value toLocalThis(QuercusClass qClass) {
        return this;
    }

    public Value toRefValue() {
        return this;
    }

    public Var toVar() {
        return new Var(this);
    }

    public Value toArgRef() {
        Env.getCurrent().warning(L.l("'{0}' is an invalid reference, because only variables may be passed by reference.", (Object)this));
        return NullValue.NULL;
    }

    public StringValue toStringValue() {
        return this.toStringValue(Env.getInstance());
    }

    public StringValue toStringValue(Env env) {
        return this.toStringBuilder(env);
    }

    public StringValue toUnicode(Env env) {
        return this.toUnicodeValue(env);
    }

    public StringValue toUnicodeValue() {
        return this.toUnicodeValue(Env.getInstance());
    }

    public StringValue toUnicodeValue(Env env) {
        return new UnicodeBuilderValue(env.createString(this.toString()));
    }

    public StringValue toBinaryValue() {
        return this.toBinaryValue(Env.getInstance());
    }

    public StringValue toBinaryValue(String charset) {
        return this.toBinaryValue();
    }

    public StringValue toBinaryValue(Env env) {
        StringValue bb = env.createBinaryBuilder();
        bb.append(this);
        return bb;
    }

    public InputStream toInputStream() {
        return new CharSequenceInputStream(this.toString());
    }

    public StringValue toStringBuilder() {
        return this.toStringBuilder(Env.getInstance());
    }

    public StringValue toStringBuilder(Env env) {
        return env.createUnicodeBuilder().appendUnicode(this);
    }

    public StringValue toStringBuilder(Env env, Value value) {
        return this.toStringBuilder(env).appendUnicode(value);
    }

    public StringValue toStringBuilder(Env env, StringValue value) {
        return this.toStringBuilder(env).appendUnicode(value);
    }

    public StringValue copyStringBuilder() {
        return this.toStringBuilder();
    }

    public LongValue toLongValue() {
        return LongValue.create(this.toLong());
    }

    public DoubleValue toDoubleValue() {
        return new DoubleValue(this.toDouble());
    }

    public boolean isCallable(Env env, boolean isCheckSyntaxOnly, Value nameRef) {
        return false;
    }

    public String getCallableName() {
        return null;
    }

    public Callable toCallable(Env env, boolean isOptional) {
        if (!isOptional) {
            env.warning(L.l("Callable: '{0}' is not a valid callable argument", (Object)this.toString()));
            return new CallbackError(this.toString());
        }
        return null;
    }

    public StringValue appendTo(UnicodeBuilderValue sb) {
        return sb.append(this.toString());
    }

    public StringValue appendTo(StringBuilderValue sb) {
        return sb.append(this.toString());
    }

    public StringValue appendTo(BinaryBuilderValue sb) {
        return sb.appendBytes(this.toString());
    }

    public StringValue appendTo(LargeStringBuilderValue sb) {
        return sb.append(this.toString());
    }

    public Value copy() {
        return this;
    }

    public Value copyArrayItem() {
        return this.copy();
    }

    public Value copyReturn() {
        return this;
    }

    public final Value copy(Env env) {
        return this.copy(env, new IdentityHashMap<Value, Value>());
    }

    public Value copy(Env env, IdentityHashMap<Value, Value> map) {
        return this;
    }

    public Value copyTree(Env env, CopyRoot root) {
        return this;
    }

    public Value clone(Env env) {
        return this;
    }

    public Value copySaveFunArg() {
        return this.copy();
    }

    public String getType() {
        return "value";
    }

    public StringValue getObjectHash(Env env) {
        return env.getEmptyString();
    }

    public String getResourceType() {
        return null;
    }

    public Value key() {
        return BooleanValue.FALSE;
    }

    public Value current() {
        return BooleanValue.FALSE;
    }

    public Value next() {
        return BooleanValue.FALSE;
    }

    public Value prev() {
        return BooleanValue.FALSE;
    }

    public Value end() {
        return BooleanValue.FALSE;
    }

    public Value reset() {
        return BooleanValue.FALSE;
    }

    public Value shuffle() {
        return BooleanValue.FALSE;
    }

    public Value pop(Env env) {
        env.warning("cannot pop a non-array");
        return NullValue.NULL;
    }

    public AbstractFunction findFunction(StringValue methodName) {
        return null;
    }

    public Value call(Env env, Value[] args) {
        Callable call = this.toCallable(env, false);
        if (call != null) {
            return call.call(env, args);
        }
        return env.warning(L.l("{0} is not a valid function", (Object)this));
    }

    public Value callRef(Env env, Value[] args) {
        AbstractFunction fun = env.getFunction(this);
        if (fun != null) {
            return fun.callRef(env, args);
        }
        return env.warning(L.l("{0} is not a valid function", (Object)this));
    }

    public Value callCopy(Env env, Value[] args) {
        AbstractFunction fun = env.getFunction(this);
        if (fun != null) {
            return fun.callCopy(env, args);
        }
        return env.warning(L.l("{0} is not a valid function", (Object)this));
    }

    public Value call(Env env) {
        return this.call(env, NULL_ARG_VALUES);
    }

    public Value callRef(Env env) {
        return this.callRef(env, NULL_ARG_VALUES);
    }

    public Value call(Env env, Value a1) {
        return this.call(env, new Value[]{a1});
    }

    public Value callRef(Env env, Value a1) {
        return this.callRef(env, new Value[]{a1});
    }

    public Value call(Env env, Value a1, Value a2) {
        return this.call(env, new Value[]{a1, a2});
    }

    public Value callRef(Env env, Value a1, Value a2) {
        return this.callRef(env, new Value[]{a1, a2});
    }

    public Value call(Env env, Value a1, Value a2, Value a3) {
        return this.call(env, new Value[]{a1, a2, a3});
    }

    public Value callRef(Env env, Value a1, Value a2, Value a3) {
        return this.callRef(env, new Value[]{a1, a2, a3});
    }

    public Value call(Env env, Value a1, Value a2, Value a3, Value a4) {
        return this.call(env, new Value[]{a1, a2, a3, a4});
    }

    public Value callRef(Env env, Value a1, Value a2, Value a3, Value a4) {
        return this.callRef(env, new Value[]{a1, a2, a3, a4});
    }

    public Value call(Env env, Value a1, Value a2, Value a3, Value a4, Value a5) {
        return this.call(env, new Value[]{a1, a2, a3, a4, a5});
    }

    public Value callRef(Env env, Value a1, Value a2, Value a3, Value a4, Value a5) {
        return this.callRef(env, new Value[]{a1, a2, a3, a4, a5});
    }

    public Value callMethod(Env env, StringValue methodName, int hash, Value[] args) {
        if (this.isNull()) {
            return env.error(L.l("Method call '{0}' is not allowed for a null value.", (Object)methodName));
        }
        return env.error(L.l("'{0}' is an unknown method of {1}.", (Object)methodName, (Object)this.toDebugString()));
    }

    public final Value callMethod(Env env, StringValue methodName, Value[] args) {
        int hash = methodName.hashCodeCaseInsensitive();
        return this.callMethod(env, methodName, hash, args);
    }

    public Value callMethodRef(Env env, StringValue methodName, int hash, Value[] args) {
        return this.callMethod(env, methodName, hash, args);
    }

    public final Value callMethodRef(Env env, StringValue methodName, Value[] args) {
        int hash = methodName.hashCodeCaseInsensitive();
        return this.callMethodRef(env, methodName, hash, args);
    }

    public Value callMethod(Env env, StringValue methodName, int hash) {
        return this.callMethod(env, methodName, hash, NULL_ARG_VALUES);
    }

    public final Value callMethod(Env env, StringValue methodName) {
        int hash = methodName.hashCodeCaseInsensitive();
        return this.callMethod(env, methodName, hash);
    }

    public Value callMethodRef(Env env, StringValue methodName, int hash) {
        return this.callMethodRef(env, methodName, hash, NULL_ARG_VALUES);
    }

    public final Value callMethodRef(Env env, StringValue methodName) {
        int hash = methodName.hashCodeCaseInsensitive();
        return this.callMethodRef(env, methodName, hash);
    }

    public Value callMethod(Env env, StringValue methodName, int hash, Value a1) {
        return this.callMethod(env, methodName, hash, new Value[]{a1});
    }

    public final Value callMethod(Env env, StringValue methodName, Value a1) {
        int hash = methodName.hashCodeCaseInsensitive();
        return this.callMethod(env, methodName, hash, a1);
    }

    public Value callMethodRef(Env env, StringValue methodName, int hash, Value a1) {
        return this.callMethodRef(env, methodName, hash, new Value[]{a1});
    }

    public final Value callMethodRef(Env env, StringValue methodName, Value a1) {
        int hash = methodName.hashCodeCaseInsensitive();
        return this.callMethodRef(env, methodName, hash, a1);
    }

    public Value callMethod(Env env, StringValue methodName, int hash, Value a1, Value a2) {
        return this.callMethod(env, methodName, hash, new Value[]{a1, a2});
    }

    public final Value callMethod(Env env, StringValue methodName, Value a1, Value a2) {
        int hash = methodName.hashCodeCaseInsensitive();
        return this.callMethod(env, methodName, hash, a1, a2);
    }

    public Value callMethodRef(Env env, StringValue methodName, int hash, Value a1, Value a2) {
        return this.callMethodRef(env, methodName, hash, new Value[]{a1, a2});
    }

    public final Value callMethodRef(Env env, StringValue methodName, Value a1, Value a2) {
        int hash = methodName.hashCodeCaseInsensitive();
        return this.callMethodRef(env, methodName, hash, a1, a2);
    }

    public Value callMethod(Env env, StringValue methodName, int hash, Value a1, Value a2, Value a3) {
        return this.callMethod(env, methodName, hash, new Value[]{a1, a2, a3});
    }

    public final Value callMethod(Env env, StringValue methodName, Value a1, Value a2, Value a3) {
        int hash = methodName.hashCodeCaseInsensitive();
        return this.callMethod(env, methodName, hash, a1, a2, a3);
    }

    public Value callMethodRef(Env env, StringValue methodName, int hash, Value a1, Value a2, Value a3) {
        return this.callMethodRef(env, methodName, hash, new Value[]{a1, a2, a3});
    }

    public final Value callMethodRef(Env env, StringValue methodName, Value a1, Value a2, Value a3) {
        int hash = methodName.hashCodeCaseInsensitive();
        return this.callMethodRef(env, methodName, hash, a1, a2, a3);
    }

    public Value callMethod(Env env, StringValue methodName, int hash, Value a1, Value a2, Value a3, Value a4) {
        return this.callMethod(env, methodName, hash, new Value[]{a1, a2, a3, a4});
    }

    public final Value callMethod(Env env, StringValue methodName, Value a1, Value a2, Value a3, Value a4) {
        int hash = methodName.hashCodeCaseInsensitive();
        return this.callMethod(env, methodName, hash, a1, a2, a3, a4);
    }

    public Value callMethodRef(Env env, StringValue methodName, int hash, Value a1, Value a2, Value a3, Value a4) {
        return this.callMethodRef(env, methodName, hash, new Value[]{a1, a2, a3, a4});
    }

    public final Value callMethodRef(Env env, StringValue methodName, Value a1, Value a2, Value a3, Value a4) {
        int hash = methodName.hashCodeCaseInsensitive();
        return this.callMethodRef(env, methodName, hash, a1, a2, a3, a4);
    }

    public Value callMethod(Env env, StringValue methodName, int hash, Value a1, Value a2, Value a3, Value a4, Value a5) {
        return this.callMethod(env, methodName, hash, new Value[]{a1, a2, a3, a4, a5});
    }

    public final Value callMethod(Env env, StringValue methodName, Value a1, Value a2, Value a3, Value a4, Value a5) {
        int hash = methodName.hashCodeCaseInsensitive();
        return this.callMethod(env, methodName, hash, a1, a2, a3, a4, a5);
    }

    public Value callMethodRef(Env env, StringValue methodName, int hash, Value a1, Value a2, Value a3, Value a4, Value a5) {
        return this.callMethodRef(env, methodName, hash, new Value[]{a1, a2, a3, a4, a5});
    }

    public final Value callMethodRef(Env env, StringValue methodName, Value a1, Value a2, Value a3, Value a4, Value a5) {
        int hash = methodName.hashCodeCaseInsensitive();
        return this.callMethodRef(env, methodName, hash, a1, a2, a3, a4, a5);
    }

    public Value neg() {
        return LongValue.create(-this.toLong());
    }

    public Value pos() {
        return LongValue.create(this.toLong());
    }

    public Value add(Value rValue) {
        if (this.getValueType().isLongAdd() && rValue.getValueType().isLongAdd()) {
            return LongValue.create(this.toLong() + rValue.toLong());
        }
        return DoubleValue.create(this.toDouble() + rValue.toDouble());
    }

    public Value add(long lLong) {
        return new DoubleValue((double)lLong + this.toDouble());
    }

    public Value preincr(int incr) {
        return this.increment(incr);
    }

    public Value postincr(int incr) {
        return this.increment(incr);
    }

    public Value addOne() {
        return this.add(1L);
    }

    public Value subOne() {
        return this.sub(1L);
    }

    public Value preincr() {
        return this.increment(1);
    }

    public Value postincr() {
        return this.increment(1);
    }

    public Value predecr() {
        return this.increment(-1);
    }

    public Value postdecr() {
        return this.increment(-1);
    }

    public Value increment(int incr) {
        long lValue = this.toLong();
        return LongValue.create(lValue + (long)incr);
    }

    public Value sub(Value rValue) {
        if (this.getValueType().isLongAdd() && rValue.getValueType().isLongAdd()) {
            return LongValue.create(this.toLong() - rValue.toLong());
        }
        return DoubleValue.create(this.toDouble() - rValue.toDouble());
    }

    public Value sub(long rLong) {
        return new DoubleValue(this.toDouble() - (double)rLong);
    }

    public Value sub_rev(long lLong) {
        if (this.getValueType().isLongAdd()) {
            return LongValue.create(lLong - this.toLong());
        }
        return new DoubleValue((double)lLong - this.toDouble());
    }

    public Value mul(Value rValue) {
        if (this.getValueType().isLongAdd() && rValue.getValueType().isLongAdd()) {
            return LongValue.create(this.toLong() * rValue.toLong());
        }
        return new DoubleValue(this.toDouble() * rValue.toDouble());
    }

    public Value mul(long r) {
        if (this.isLongConvertible()) {
            return LongValue.create(this.toLong() * r);
        }
        return new DoubleValue(this.toDouble() * (double)r);
    }

    public Value div(Value rValue) {
        if (this.getValueType().isLongAdd() && rValue.getValueType().isLongAdd()) {
            long l = this.toLong();
            long r = rValue.toLong();
            if (r != 0L && l % r == 0L) {
                return LongValue.create(l / r);
            }
            return new DoubleValue(this.toDouble() / rValue.toDouble());
        }
        return new DoubleValue(this.toDouble() / rValue.toDouble());
    }

    public Value div(long r) {
        long l = this.toLong();
        if (r != 0L && l % r == 0L) {
            return LongValue.create(l / r);
        }
        return new DoubleValue(this.toDouble() / (double)r);
    }

    public Value mod(Value rValue) {
        double lDouble = this.toDouble();
        double rDouble = rValue.toDouble();
        return LongValue.create((double)((long)lDouble) % rDouble);
    }

    public Value lshift(Value rValue) {
        long lLong = this.toLong();
        long rLong = rValue.toLong();
        return LongValue.create(lLong << (int)rLong);
    }

    public Value rshift(Value rValue) {
        long lLong = this.toLong();
        long rLong = rValue.toLong();
        return LongValue.create(lLong >> (int)rLong);
    }

    public Value bitAnd(Value rValue) {
        return LongValue.create(this.toLong() & rValue.toLong());
    }

    public Value bitOr(Value rValue) {
        return LongValue.create(this.toLong() | rValue.toLong());
    }

    public Value bitXor(Value rValue) {
        return LongValue.create(this.toLong() ^ rValue.toLong());
    }

    public Value abs() {
        if (this.getValueType().isDoubleCmp()) {
            return new DoubleValue(Math.abs(this.toDouble()));
        }
        return LongValue.create(Math.abs(this.toLong()));
    }

    public long nextIndex(long oldIndex) {
        return oldIndex;
    }

    public int length() {
        return this.toStringValue().length();
    }

    public int getSize() {
        return 1;
    }

    public int getCount(Env env) {
        return 1;
    }

    public int getCountRecursive(Env env) {
        return this.getCount(env);
    }

    public Iterator<Map.Entry<Value, Value>> getIterator(Env env) {
        return this.getBaseIterator(env);
    }

    public Iterator<Map.Entry<Value, Value>> getBaseIterator(Env env) {
        Set emptySet = Collections.emptySet();
        return emptySet.iterator();
    }

    public Iterator<Value> getKeyIterator(Env env) {
        final Iterator<Map.Entry<Value, Value>> iter = this.getIterator(env);
        return new Iterator<Value>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public Value next() {
                return (Value)((Map.Entry)iter.next()).getKey();
            }

            @Override
            public void remove() {
                iter.remove();
            }
        };
    }

    public Value[] getKeyArray(Env env) {
        return NULL_VALUE_ARRAY;
    }

    public Value[] getValueArray(Env env) {
        return NULL_VALUE_ARRAY;
    }

    public Iterator<Value> getValueIterator(Env env) {
        final Iterator<Map.Entry<Value, Value>> iter = this.getIterator(env);
        return new Iterator<Value>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public Value next() {
                return (Value)((Map.Entry)iter.next()).getValue();
            }

            @Override
            public void remove() {
                iter.remove();
            }
        };
    }

    public Value getField(Env env, StringValue name) {
        return NullValue.NULL;
    }

    public Var getFieldVar(Env env, StringValue name) {
        return this.getField(env, name).toVar();
    }

    public Value getFieldArg(Env env, StringValue name, boolean isTop) {
        return this.getFieldVar(env, name);
    }

    public Value getFieldArgRef(Env env, StringValue name) {
        return this.getFieldVar(env, name);
    }

    public Value getFieldObject(Env env, StringValue name) {
        Value v = this.getField(env, name);
        if (!v.isset()) {
            v = env.createObject();
            this.putField(env, name, v);
        }
        return v;
    }

    public Value getFieldArray(Env env, StringValue name) {
        Value array;
        Value v = this.getField(env, name);
        if (v != (array = v.toAutoArray())) {
            this.putField(env, name, array);
            return array;
        }
        if (array.isString()) {
            return this.getFieldVar(env, name);
        }
        return v;
    }

    public Value putField(Env env, StringValue name, Value object) {
        return NullValue.NULL;
    }

    public final Value putField(Env env, StringValue name, Value value, Value innerIndex, Value innerValue) {
        Value result = value.append(innerIndex, innerValue);
        return this.putField(env, name, result);
    }

    public void setFieldInit(boolean isInit) {
    }

    public boolean isFieldInit() {
        return false;
    }

    public boolean isFieldExists(Env env, StringValue name) {
        return this.getField(env, name) == UnsetValue.UNSET;
    }

    public boolean issetField(Env env, StringValue name) {
        return false;
    }

    public void unsetField(StringValue name) {
    }

    public void unsetArray(Env env, StringValue name, Value index) {
    }

    public void unsetThisArray(Env env, StringValue name, Value index) {
    }

    public Value putThisFieldArray(Env env, Value obj, StringValue fieldName, Value index, Value value) {
        return this.put(index, value);
    }

    public Value getThisField(Env env, StringValue name) {
        return this.getField(env, name);
    }

    public Var getThisFieldVar(Env env, StringValue name) {
        return this.getThisField(env, name).toVar();
    }

    public Value getThisFieldArg(Env env, StringValue name) {
        return this.getThisFieldVar(env, name);
    }

    public Value getThisFieldArgRef(Env env, StringValue name) {
        return this.getThisFieldVar(env, name);
    }

    public Value getThisFieldObject(Env env, StringValue name) {
        Value v = this.getThisField(env, name);
        if (!v.isset()) {
            v = env.createObject();
            this.putThisField(env, name, v);
        }
        return v;
    }

    public Value getThisFieldArray(Env env, StringValue name) {
        Value array;
        Value v = this.getThisField(env, name);
        if (v == (array = v.toAutoArray())) {
            return v;
        }
        this.putField(env, name, array);
        return array;
    }

    public final void initField(Env env, ClassField field, boolean isInitFieldValues) {
        Value value = NullValue.NULL;
        if (isInitFieldValues) {
            value = field.evalInitExpr(env);
        }
        this.initField(env, field.getName(), field.getCanonicalName(), value);
    }

    public final void initField(Env env, StringValue canonicalName, Value value) {
        StringValue name = ClassField.getOrdinaryName(canonicalName);
        this.initField(env, name, canonicalName, value);
    }

    public void initField(Env env, StringValue name, StringValue canonicalName, Value value) {
        this.putThisField(env, canonicalName, value);
    }

    public void initIncompleteField(Env env, StringValue name, Value value, FieldVisibility visibility) {
        this.putThisField(env, name, value);
    }

    public Value putThisField(Env env, StringValue name, Value object) {
        return this.putField(env, name, object);
    }

    public Value putThisField(Env env, StringValue name, Value array, Value index, Value value) {
        Value result = array.append(index, value);
        this.putThisField(env, name, result);
        return value;
    }

    public boolean issetThisField(Env env, StringValue name) {
        return this.issetField(env, name);
    }

    public void unsetThisField(StringValue name) {
        this.unsetField(name);
    }

    public void unsetThisPrivateField(String className, StringValue name) {
        this.unsetField(name);
    }

    public Value getStaticFieldValue(Env env, StringValue name) {
        env.error(L.l("No calling class found for '{0}'", (Object)this));
        return NullValue.NULL;
    }

    public Var getStaticFieldVar(Env env, StringValue name) {
        env.error(L.l("No calling class found for '{0}'", (Object)this));
        throw new IllegalStateException();
    }

    public Value setStaticFieldRef(Env env, StringValue name, Value value) {
        env.error(L.l("No calling class found for '{0}'", (Object)this));
        throw new IllegalStateException();
    }

    public Value putField(Env env, String name, Value value) {
        return this.putThisField(env, env.createString(name), value);
    }

    public Value get(Value index) {
        return UnsetValue.UNSET;
    }

    public final Value get(long index) {
        return this.get(LongValue.create(index));
    }

    public Var getVar(Value index) {
        Value value = this.get(index);
        if (value.isVar()) {
            return (Var)value;
        }
        return new Var(value);
    }

    public Value getRef(Value index) {
        return this.get(index);
    }

    public Value getArg(Value index, boolean isTop) {
        return this.get(index);
    }

    public Value getDirty(Value index) {
        return this.get(index);
    }

    public Value getArray() {
        return this;
    }

    public Value getArray(Value index) {
        Var var = this.getVar(index);
        return ((Value)var).toAutoArray();
    }

    public Value getObject(Env env) {
        return NullValue.NULL;
    }

    public Value getObject(Env env, Value index) {
        Var var = this.getVar(index);
        if (((Value)var).isset()) {
            return ((Value)var).toValue();
        }
        ((Value)var).set(env.createObject());
        return ((Value)var).toValue();
    }

    public boolean isVar() {
        return false;
    }

    public Value set(Value value) {
        return value;
    }

    public Value put(Value index, Value value) {
        Env.getCurrent().warning(L.l("{0} cannot be used as an array", (Object)this.toDebugString()));
        return value;
    }

    public final Value put(Value index, Value value, Value innerIndex, Value innerValue) {
        Value result = value.append(innerIndex, innerValue);
        this.put(index, result);
        return innerValue;
    }

    public Value put(Value value) {
        return value;
    }

    public Value append(Value index, Value value) {
        Value array = this.toAutoArray();
        if (array.isArray()) {
            return array.append(index, value);
        }
        return array;
    }

    public Var putVar() {
        return new Var();
    }

    public Value putArray(Env env) {
        ArrayValueImpl value = new ArrayValueImpl();
        this.put(value);
        return value;
    }

    public Value getArgTail(Env env, boolean isTop) {
        return this.putVar();
    }

    public Value putObject(Env env) {
        ObjectValue value = env.createObject();
        this.put(value);
        return value;
    }

    public boolean isset(Value index) {
        return false;
    }

    public boolean keyExists(Value key) {
        return this.isset(key);
    }

    public Value containsKey(Value key) {
        return null;
    }

    public Value remove(Value index) {
        return UnsetValue.UNSET;
    }

    public Object valuesToArray(Env env, Class<?> elementType) {
        env.error(L.l("Can't assign {0} with type {1} to {2}[]", (Object)this, (Object)this.getClass(), (Object)elementType));
        return null;
    }

    public Value charValueAt(long index) {
        return NullValue.NULL;
    }

    public Value setCharValueAt(long index, Value value) {
        return NullValue.NULL;
    }

    public void print(Env env) {
        env.print(this.toString(env));
    }

    public void print(Env env, WriteStream out) {
        try {
            out.print(this.toString(env));
        }
        catch (IOException e) {
            throw new QuercusRuntimeException(e);
        }
    }

    public void serialize(Env env, StringBuilder sb, SerializeMap serializeMap) {
        serializeMap.incrementIndex();
        this.serialize(env, sb);
    }

    public void jsonEncode(Env env, JsonEncodeContext context, StringValue sb) {
        env.warning(L.l("type is unsupported; json encoded as null"));
        sb.append("null");
    }

    public void serialize(Env env, StringBuilder sb) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public StringValue varExport(Env env) {
        StringValue sb = env.createStringBuilder();
        this.varExportImpl(sb, 0);
        return sb;
    }

    protected void varExportImpl(StringValue sb, int level) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void setJavaObject(Object obj) {
    }

    public void generate(PrintWriter out) throws IOException {
    }

    protected static void printJavaChar(PrintWriter out, char ch) {
        switch (ch) {
            case '\r': {
                out.print("\\r");
                break;
            }
            case '\n': {
                out.print("\\n");
                break;
            }
            case '\'': {
                out.print("\\'");
                break;
            }
            case '\\': {
                out.print("\\\\");
                break;
            }
            default: {
                out.print(ch);
            }
        }
    }

    protected static void printJavaString(PrintWriter out, StringValue s) {
        if (s == null) {
            out.print("");
            return;
        }
        int len = s.length();
        block7: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\r': {
                    out.print("\\r");
                    continue block7;
                }
                case '\n': {
                    out.print("\\n");
                    continue block7;
                }
                case '\"': {
                    out.print("\\\"");
                    continue block7;
                }
                case '\'': {
                    out.print("\\'");
                    continue block7;
                }
                case '\\': {
                    out.print("\\\\");
                    continue block7;
                }
                default: {
                    out.print(ch);
                }
            }
        }
    }

    public String toInternString() {
        return this.toString().intern();
    }

    public String toDebugString() {
        return this.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void varDump(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        if (valueSet.get(this) != null) {
            out.print("*recursion*");
            return;
        }
        valueSet.put(this, "printing");
        try {
            this.varDumpImpl(env, out, depth, valueSet);
        }
        finally {
            valueSet.remove(this);
        }
    }

    protected void varDumpImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        out.print("resource(" + this.toString() + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void printR(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        if (valueSet.get(this) != null) {
            out.print("*recursion*");
            return;
        }
        valueSet.put(this, "printing");
        try {
            this.printRImpl(env, out, depth, valueSet);
        }
        finally {
            valueSet.remove(this);
        }
    }

    protected void printRImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        out.print(this.toString());
    }

    protected void printDepth(WriteStream out, int depth) throws IOException {
        for (int i = 0; i < depth; ++i) {
            out.print(' ');
        }
    }

    public int getHashCode() {
        return this.hashCode();
    }

    public int hashCode() {
        return 1021;
    }
}

