/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.expr.AbstractVarExpr;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.ExprFactory;
import com.caucho.quercus.parser.QuercusParser;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassVarFieldVarExpr
extends AbstractVarExpr {
    private static final L10N L = new L10N(ClassVarFieldVarExpr.class);
    protected final Expr _className;
    protected final Expr _varName;

    public ClassVarFieldVarExpr(Expr className, Expr varName) {
        this._className = className;
        this._varName = varName;
    }

    @Override
    public Expr createCall(QuercusParser parser, Location location, ArrayList<Expr> args) throws IOException {
        ExprFactory factory = parser.getExprFactory();
        return factory.createClassMethodCall(location, this._className, this._varName, args);
    }

    @Override
    public Value eval(Env env) {
        String className = this._className.evalString(env);
        QuercusClass qClass = env.getClass(className);
        StringValue varName = this._varName.evalStringValue(env);
        return qClass.getStaticFieldValue(env, varName);
    }

    @Override
    public Var evalVar(Env env) {
        String className = this._className.evalString(env);
        QuercusClass qClass = env.getClass(className);
        StringValue varName = this._varName.evalStringValue(env);
        return qClass.getStaticFieldVar(env, varName);
    }

    @Override
    public Value evalAssignRef(Env env, Value value) {
        String className = this._className.evalString(env);
        QuercusClass qClass = env.getClass(className);
        StringValue varName = this._varName.evalStringValue(env);
        return qClass.setStaticFieldRef(env, varName, value);
    }

    @Override
    public void evalUnset(Env env) {
        env.error(L.l("{0}::${1}: Cannot unset class variables.", (Object)this._className, (Object)this._varName), this.getLocation());
    }

    @Override
    public String toString() {
        return this._className + "::$" + this._varName;
    }
}

