/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib;

import com.caucho.quercus.annotation.ResourceType;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.EnvCleanup;
import com.caucho.quercus.lib.ProcOpenInput;
import com.caucho.quercus.lib.ProcOpenOutput;
import java.util.logging.Level;
import java.util.logging.Logger;

@ResourceType(value="process")
public class ProcOpenResource
implements EnvCleanup {
    private static final Logger log = Logger.getLogger(ProcOpenResource.class.getName());
    private Env _env;
    private ProcOpenOutput _in;
    private ProcOpenInput _out;
    private ProcOpenInput _err;
    private Process _process;
    private String _command;
    private boolean _isRunning = true;
    private int _exitCode = -1;

    public ProcOpenResource(Env env, Process process, ProcOpenOutput in, ProcOpenInput out, ProcOpenInput err, String command) {
        this._env = env;
        this._process = process;
        this._in = in;
        this._out = out;
        this._err = err;
        this._command = command;
        env.addCleanup(this);
    }

    public boolean isRunning() {
        if (!this._isRunning) {
            return false;
        }
        try {
            this._exitCode = this._process.exitValue();
            this._isRunning = false;
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }

    public int getExitCode() {
        if (!this._isRunning) {
            return this._exitCode;
        }
        try {
            this._exitCode = this._process.exitValue();
            this._isRunning = false;
            return this._exitCode;
        }
        catch (IllegalThreadStateException e) {
            return -1;
        }
    }

    public String getCommand() {
        return this._command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int pclose() {
        try {
            if (this._in != null) {
                this._in.close();
            }
            this._out.close();
            this._err.close();
            int n = this._process.waitFor();
            return n;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.getMessage());
            this._env.warning(e);
            int n = -1;
            return n;
        }
        finally {
            this._env.removeCleanup(this);
        }
    }

    public boolean terminate() {
        if (this._in != null) {
            this._in.close();
        }
        this._out.close();
        this._err.close();
        this._process.destroy();
        this._env.removeCleanup(this);
        return true;
    }

    public void cleanup() {
        this.pclose();
    }
}

