/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.curl;

import com.caucho.quercus.annotation.ResourceType;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.ResourceValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.curl.CurlResource;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceType(value="curl_multi")
public class CurlMultiResource
extends ResourceValue {
    private ArrayList<CurlResource> _curlList = new ArrayList();
    private ArrayList<CurlResource> _msgQueue = new ArrayList();
    private int _runningCount = -1;

    public void addCurl(CurlResource curl) {
        this._curlList.add(curl);
    }

    public void removeCurl(CurlResource curl) {
        boolean isRemoved = this._curlList.remove(curl);
        this._msgQueue.remove(curl);
    }

    public int execute(Env env, Value stillRunning) {
        if (this._runningCount == 0) {
            stillRunning.set(LongValue.ZERO);
            return 0;
        }
        if (this._runningCount < 0) {
            this._runningCount = this._curlList.size();
            for (CurlResource curl : this._curlList) {
                curl.execute(env, false);
                this._msgQueue.add(curl);
            }
        }
        --this._runningCount;
        stillRunning.set(LongValue.create(this._runningCount));
        if (this._runningCount == 0) {
            return 0;
        }
        return -1;
    }

    public Value readInfo(Env env, Value msgsInQueue) {
        if (this._msgQueue.size() == 0) {
            return BooleanValue.FALSE;
        }
        StringValue msgStr = env.createString("msg");
        StringValue resultStr = env.createString("result");
        StringValue handleStr = env.createString("handle");
        CurlResource curl = this._msgQueue.remove(0);
        ArrayValueImpl array = new ArrayValueImpl();
        array.put(msgStr, LongValue.create(1L));
        array.put(resultStr, LongValue.create(0L));
        array.put(handleStr, curl);
        msgsInQueue.set(LongValue.create(this._msgQueue.size()));
        return array;
    }

    public ArrayList<CurlResource> getCurlList() {
        return this._curlList;
    }

    public int getCurlListSize() {
        return this._curlList.size();
    }
}

