/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.date;

import com.caucho.quercus.QuercusException;
import com.caucho.quercus.UnimplementedException;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.util.L10N;

public class DateInterval {
    private static final L10N L = new L10N(DateInterval.class);
    public int y;
    public int m;
    public int d;
    public int h;
    public int i;
    public int s;
    public int invert = 0;
    public Value days = BooleanValue.FALSE;

    public static DateInterval __construct(Env env, String time) {
        DateInterval dateInterval = new DateInterval();
        IntervalParser parser = new IntervalParser(dateInterval, time);
        parser.parse();
        return dateInterval;
    }

    protected DateInterval() {
    }

    public static DateInterval createFromDateString(Env env, String time) {
        throw new UnimplementedException("DateInterval::createFromDateString()");
    }

    public String format(String format) {
        throw new UnimplementedException("DateInterval::format()");
    }

    static class ParseException
    extends QuercusException {
        public ParseException(String message) {
            super(message);
        }
    }

    static class IntervalParser {
        private final DateInterval _dateInterval;
        private final String _str;
        private final int _length;
        private int _offset;

        public IntervalParser(DateInterval dateInterval, String str) {
            this._dateInterval = dateInterval;
            this._str = str;
            this._length = str.length();
        }

        public void parse() throws ParseException {
            int ch = this.read();
            if (ch != 80) {
                throw new ParseException("expected P");
            }
            this.parseDate();
            this.parseTime();
        }

        private void parseDate() throws ParseException {
            int ch;
            while ((ch = this.peek()) != 84 && ch >= 0) {
                int value = this.readInt();
                ch = this.read();
                if (ch == 89) {
                    this._dateInterval.y = value;
                    continue;
                }
                if (ch == 77) {
                    this._dateInterval.m = value;
                    continue;
                }
                if (ch == 68) {
                    this._dateInterval.d = value;
                    continue;
                }
                if (ch == 87) {
                    this._dateInterval.d = value * 7;
                    continue;
                }
                throw new ParseException(L.l("unknown date identifier: '{0}'", (char)ch));
            }
        }

        private int readInt() throws ParseException {
            int ch = this.read();
            if (ch < 48 || ch > 57) {
                throw new ParseException(L.l("expected digit, saw '{0}' ({1})", (char)ch, ch));
            }
            int value = ch - 48;
            while (48 <= (ch = this.read()) && ch <= 57) {
                value = value * 10 + ch - 48;
            }
            this.unread();
            return value;
        }

        private void parseTime() throws ParseException {
            int ch = this.peek();
            if (ch != 84) {
                return;
            }
            this.read();
            while ((ch = this.peek()) >= 0) {
                int value = this.readInt();
                ch = this.read();
                if (ch == 72) {
                    this._dateInterval.h = value;
                    continue;
                }
                if (ch == 77) {
                    this._dateInterval.i = value;
                    continue;
                }
                if (ch == 83) {
                    this._dateInterval.s = value;
                    continue;
                }
                throw new ParseException(L.l("unknown time identifier: '{0}'", (char)ch));
            }
        }

        private int peek() {
            if (this._offset < this._length) {
                return this._str.charAt(this._offset);
            }
            return -1;
        }

        private int read() {
            if (this._offset < this._length) {
                return this._str.charAt(this._offset++);
            }
            return -1;
        }

        private void unread() {
            --this._offset;
        }
    }
}

