/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.db;

import com.caucho.quercus.UnimplementedException;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.ConnectionEntry;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.EnvCleanup;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.db.JdbcResultResource;
import com.caucho.quercus.lib.db.JdbcTableMetaData;
import com.caucho.quercus.lib.db.SqlParseToken;
import com.caucho.util.JdbcUtil;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import com.caucho.util.SQLExceptionWrapper;
import java.sql.Connection;
import java.sql.DataTruncation;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class JdbcConnectionResource
implements EnvCleanup {
    private static final L10N L = new L10N(JdbcConnectionResource.class);
    private static final Logger log = Logger.getLogger(JdbcConnectionResource.class.getName());
    private static LruCache<TableKey, JdbcTableMetaData> _tableMetadataMap = new LruCache(256);
    protected ConnectionEntry _conn;
    private Statement _savedStmt;
    private Statement _freeStmt;
    private DatabaseMetaData _dmd;
    private JdbcResultResource _rs;
    private int _affectedRows;
    private String _errorMessage = null;
    private int _errorCode;
    private SQLWarning _warnings;
    private SQLException _exception;
    protected String _host;
    protected int _port;
    private String _userName;
    private String _password;
    protected String _driver;
    protected String _url;
    protected int _flags;
    protected String _socket;
    protected boolean _isEmulatePrepares;
    private String _catalog;
    private boolean _isCatalogOptimEnabled = false;
    private boolean _isUsed;
    protected SqlParseToken _sqlParseToken = new SqlParseToken();

    protected JdbcConnectionResource(Env env) {
        env.addCleanup(this);
    }

    protected String getDriverName() {
        return "mysql";
    }

    protected Value getServerStat(Env env) {
        env.warning(L.l("driver does not support server stat"));
        return BooleanValue.FALSE;
    }

    public StringValue error(Env env) {
        if (this.isConnected()) {
            return env.createString(this.getErrorMessage());
        }
        return env.getEmptyString();
    }

    public boolean isConnected() {
        return this._conn != null;
    }

    public String getHost() {
        return this._host;
    }

    public String getUserName() {
        return this._userName;
    }

    public String getPassword() {
        return this._password;
    }

    public String getDbName() {
        return this._catalog;
    }

    public int getPort() {
        return this._port;
    }

    public String getDriver() {
        return this._driver;
    }

    public String getUrl() {
        return this._url;
    }

    public boolean isEmulatePrepares() {
        return this._isEmulatePrepares;
    }

    protected final boolean connectInternal(Env env, String host, String userName, String password, String dbname, int port, String socket, int flags, String driver, String url, boolean isNewLink, boolean isEmulatePrepares) {
        if (this._conn != null) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " attempt to open multiple connections");
        }
        this._host = host;
        this._userName = userName;
        this._password = password;
        this._port = port;
        this._socket = socket;
        this._flags = flags;
        this._driver = driver;
        this._url = url;
        this._isEmulatePrepares = isEmulatePrepares;
        if (dbname == null) {
            dbname = "";
        }
        this._catalog = dbname;
        this._conn = this.connectImpl(env, host, userName, password, dbname, port, socket, flags, driver, url, isNewLink, isEmulatePrepares);
        if (this._conn != null) {
            try {
                if ("".equals(this._catalog)) {
                    this._catalog = this._conn.getConnection().getCatalog();
                }
            }
            catch (SQLException e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        return this._conn != null && this._conn.getConnection() != null;
    }

    protected abstract ConnectionEntry connectImpl(Env var1, String var2, String var3, String var4, String var5, int var6, String var7, int var8, String var9, String var10, boolean var11, boolean var12);

    protected StringValue realEscapeString(Env env, StringValue str) {
        StringValue buf = env.createUnicodeBuilder();
        int strLength = str.length();
        block9: for (int i = 0; i < strLength; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\u0000': {
                    buf.append('\\');
                    buf.append(0L);
                    continue block9;
                }
                case '\n': {
                    buf.append('\\');
                    buf.append('n');
                    continue block9;
                }
                case '\r': {
                    buf.append('\\');
                    buf.append('r');
                    continue block9;
                }
                case '\\': {
                    buf.append('\\');
                    buf.append('\\');
                    continue block9;
                }
                case '\'': {
                    buf.append('\\');
                    buf.append('\'');
                    continue block9;
                }
                case '\"': {
                    buf.append('\\');
                    buf.append('\"');
                    continue block9;
                }
                case '\u001a': {
                    buf.append('\\');
                    buf.append('Z');
                    continue block9;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf;
    }

    public int getAffectedRows() {
        return this._affectedRows;
    }

    public void setAffectedRows(int i) {
        this._affectedRows = i;
    }

    public int getFieldCount() {
        if (this._rs == null) {
            return 0;
        }
        return this._rs.getFieldCount();
    }

    protected JdbcResultResource getCatalogs(Env env) {
        this.clearErrors();
        try {
            ResultSet rs;
            if (this._dmd == null) {
                this._dmd = this._conn.getConnection().getMetaData();
            }
            if ((rs = this._dmd.getCatalogs()) != null) {
                return this.createResult(this._savedStmt, rs);
            }
            return null;
        }
        catch (SQLException e) {
            this.saveErrors(e);
            log.log(Level.FINEST, e.toString(), e);
            return null;
        }
    }

    protected String getCatalog() {
        return this._catalog;
    }

    public String getCharacterSetName() {
        return "latin1";
    }

    public String getClientEncoding() {
        return this.getCharacterSetName();
    }

    public boolean setClientEncoding(String encoding) {
        return true;
    }

    protected String getClientInfo(Env env) {
        throw new UnimplementedException();
    }

    public String getClientInfo() {
        try {
            if (this._dmd == null) {
                this._dmd = this._conn.getConnection().getMetaData();
            }
            return this._dmd.getDatabaseProductVersion();
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
    }

    public final Connection getConnection(Env env) {
        this._isUsed = true;
        Connection conn = null;
        if (this._conn != null) {
            conn = this._conn.getConnection();
        }
        if (conn != null) {
            return conn;
        }
        if (this._errorMessage != null) {
            env.warning(this._errorMessage);
            return null;
        }
        env.warning(L.l("Connection is not available: {0}", (Object)this._conn));
        this._errorMessage = L.l("Connection is not available: {0}", (Object)this._conn);
        return null;
    }

    protected Connection getJavaConnection(Env env) throws SQLException {
        return env.getQuercus().getConnection(this._conn.getConnection());
    }

    protected String getURL() {
        return this._url;
    }

    protected int getErrorCode() {
        return this._errorCode;
    }

    protected String getErrorMessage() {
        return this._errorMessage;
    }

    protected SQLException getException() {
        return this._exception;
    }

    public String getHostInfo() throws SQLException {
        if (this._dmd == null) {
            this._dmd = this._conn.getConnection().getMetaData();
        }
        return this._dmd.getURL();
    }

    protected String getServerInfo() throws SQLException {
        return this.getMetaData().getDatabaseProductVersion();
    }

    public JdbcTableMetaData getTableMetaData(Env env, String catalog, String schema, String table) throws SQLException {
        try {
            if (table == null || table.equals("")) {
                return null;
            }
            TableKey key = new TableKey(this.getURL(), catalog, schema, table);
            JdbcTableMetaData tableMd = _tableMetadataMap.get(key);
            if (tableMd != null && tableMd.isValid(env)) {
                return tableMd;
            }
            tableMd = new JdbcTableMetaData(env, catalog, schema, table, this.getMetaData());
            _tableMetadataMap.put(key, tableMd);
            return tableMd;
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
    }

    private DatabaseMetaData getMetaData() throws SQLException {
        if (this._dmd == null) {
            this._dmd = this._conn.getConnection().getMetaData();
        }
        return this._dmd;
    }

    protected static int infoToVersion(String info) {
        String[] result = info.split("[.a-z-]");
        if (result.length < 3) {
            return 0;
        }
        return Integer.parseInt(result[0]) * 10000 + Integer.parseInt(result[1]) * 100 + Integer.parseInt(result[2]);
    }

    public void closeStatement(Statement stmt) {
        this.closeStatement(stmt, false);
    }

    private void closeStatement(Statement stmt, boolean isReuse) {
        if (stmt == null) {
            return;
        }
        if (!isReuse || this._freeStmt == null) {
            // empty if block
        }
        JdbcUtil.close(stmt);
    }

    protected void close() {
        ConnectionEntry conn = this._conn;
        this._conn = null;
        if (conn != null) {
            conn.phpClose();
        }
    }

    public void cleanup() {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " cleanup()");
        }
        Statement savedStmt = this._savedStmt;
        this._savedStmt = null;
        Statement freeStmt = this._freeStmt;
        this._freeStmt = null;
        this.closeStatement(savedStmt, false);
        this.closeStatement(freeStmt, false);
        ConnectionEntry conn = this._conn;
        this._conn = null;
        if (conn != null) {
            conn.phpClose();
        }
    }

    public JdbcConnectionResource validateConnection(Env env) {
        if (this._conn == null) {
            throw env.createErrorException(L.l("Connection is not properly initialized {0}\nDriver {1}", (Object)this._url, (Object)this._driver));
        }
        return this;
    }

    protected Value realQuery(Env env, String sql) {
        this.clearErrors();
        this._rs = null;
        Statement stmt = this._freeStmt;
        this._freeStmt = null;
        try {
            Connection conn = this.getConnection(env);
            if (conn == null) {
                return BooleanValue.FALSE;
            }
            if (this.checkSql(env, this._conn, sql)) {
                return BooleanValue.TRUE;
            }
            boolean isSeekable = this.isSeekable();
            stmt = isSeekable ? conn.createStatement(1004, 1007) : conn.createStatement();
            stmt.setEscapeProcessing(false);
            if (stmt.execute(sql)) {
                ResultSet rs = stmt.getResultSet();
                this._rs = this.createResult(stmt, rs);
                this._affectedRows = 0;
            } else {
                this.keepResourceValues(stmt);
                this._affectedRows = 0;
                this._affectedRows = stmt.getUpdateCount();
                if (this._rs != null) {
                    this._rs.setAffectedRows(this._affectedRows);
                }
                if (this.keepStatementOpen()) {
                    this._savedStmt = stmt;
                } else {
                    this._freeStmt = stmt;
                }
            }
        }
        catch (DataTruncation truncationError) {
            this.saveErrors(truncationError);
            try {
                this._affectedRows = stmt.getUpdateCount();
            }
            catch (SQLException e) {
                log.log(Level.FINEST, e.toString(), e);
                return BooleanValue.FALSE;
            }
        }
        catch (SQLException e) {
            this.saveErrors(e);
            if (this.keepStatementOpen()) {
                this.keepResourceValues(stmt);
            }
            log.log(Level.FINEST, e.toString(), e);
            return BooleanValue.FALSE;
        }
        catch (IllegalStateException e) {
            this.saveErrors(new SQLExceptionWrapper(e));
            return BooleanValue.FALSE;
        }
        if (this._rs == null) {
            return BooleanValue.TRUE;
        }
        return env.wrapJava(this._rs);
    }

    protected Statement createStatement(Env env) throws SQLException {
        Connection conn = this.getConnection(env);
        boolean isSeekable = this.isSeekable();
        Statement stmt = isSeekable ? conn.createStatement(1004, 1007) : conn.createStatement();
        return stmt;
    }

    private boolean checkSql(Env env, ConnectionEntry connEntry, String sql) {
        SqlParseToken tok = this.parseSqlToken(sql, null);
        if (tok == null) {
            return false;
        }
        switch (tok.getFirstChar()) {
            case 'A': 
            case 'a': {
                _tableMetadataMap.clear();
                break;
            }
            case 'D': 
            case 'd': {
                String dbname;
                if (!tok.matchesToken("DROP")) break;
                _tableMetadataMap.clear();
                tok = this.parseSqlToken(sql, tok);
                if (tok == null || !tok.matchesToken("DATABASE") || (tok = this.parseSqlToken(sql, tok)) == null || !(dbname = tok.toUnquotedString()).equals(this._catalog)) break;
                try {
                    this.setCatalog(env, null);
                }
                catch (SQLException e) {
                    log.log(Level.FINEST, e.toString(), e);
                }
                break;
            }
            case 'C': 
            case 'c': {
                if (!tok.matchesToken("CREATE")) break;
                connEntry.markForPoolRemoval();
            }
        }
        return false;
    }

    protected SqlParseToken parseSqlToken(String sql, SqlParseToken prevToken) {
        int i;
        if (sql == null) {
            this._sqlParseToken.init();
            return null;
        }
        int len = sql.length();
        for (i = prevToken == null ? 0 : prevToken.getEnd(); i < len && Character.isWhitespace(sql.charAt(i)); ++i) {
        }
        if (i + 1 >= len) {
            this._sqlParseToken.init();
            return null;
        }
        int start = i;
        while (i < len && !Character.isWhitespace(sql.charAt(i))) {
            ++i;
        }
        this._sqlParseToken.assign(sql, start, i);
        return this._sqlParseToken;
    }

    protected JdbcResultResource createResult(Statement stmt, ResultSet rs) {
        return new JdbcResultResource(rs);
    }

    public JdbcResultResource getResultSet() {
        return this._rs;
    }

    public boolean getAutoCommit() {
        this.clearErrors();
        try {
            return this._conn.getConnection().getAutoCommit();
        }
        catch (SQLException e) {
            this.saveErrors(e);
            log.log(Level.FINEST, e.toString(), e);
            return false;
        }
    }

    public boolean setAutoCommit(boolean mode) {
        this.clearErrors();
        try {
            this._conn.getConnection().setAutoCommit(mode);
        }
        catch (SQLException e) {
            this.saveErrors(e);
            log.log(Level.FINEST, e.toString(), e);
            return false;
        }
        return true;
    }

    public boolean commit() {
        this.clearErrors();
        try {
            this._conn.getConnection().commit();
        }
        catch (SQLException e) {
            this.saveErrors(e);
            log.log(Level.FINEST, e.toString(), e);
            return false;
        }
        return true;
    }

    public boolean rollback() {
        this.clearErrors();
        try {
            this._conn.getConnection().rollback();
        }
        catch (SQLException e) {
            this.saveErrors(e);
            log.log(Level.FINEST, e.toString(), e);
            return false;
        }
        return true;
    }

    public void setCatalog(Env env, String name) throws SQLException {
        if (this._catalog != null && this._catalog.equals(name)) {
            return;
        }
        this.clearErrors();
        this._savedStmt = null;
        this._freeStmt = null;
        if (!this._isUsed && this._isCatalogOptimEnabled) {
            ConnectionEntry conn = this._conn;
            this._conn = null;
            if (conn != null) {
                conn.phpClose();
            }
            this.connectInternal(env, this._host, this._userName, this._password, name, this._port, this._socket, this._flags, this._driver, this._url, false, this._isEmulatePrepares);
        } else {
            this._conn.setCatalog(name);
        }
        this._catalog = name;
    }

    public Object toObject() {
        return null;
    }

    public String toString() {
        if (this._conn != null) {
            return this.getClass().getSimpleName() + "[" + this._conn.getConnection() + "]";
        }
        return this.getClass().getSimpleName() + "[" + null + "]";
    }

    protected void keepResourceValues(Statement stmt) {
    }

    protected boolean keepStatementOpen() {
        return false;
    }

    protected JdbcResultResource getResultResource() {
        return this._rs;
    }

    protected void setResultResource(JdbcResultResource rs) {
        this._rs = rs;
    }

    protected SQLWarning getWarnings() {
        return this._warnings;
    }

    public boolean ping(Env env) {
        try {
            return this.isConnected() && !this.getConnection(env).isClosed();
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            env.warning(e.toString(), e);
            return false;
        }
    }

    protected void setWarnings(SQLWarning warnings) {
        this._warnings = warnings;
    }

    protected void clearErrors() {
        this._exception = null;
        this._errorMessage = null;
        this._errorCode = 0;
        this._warnings = null;
    }

    protected void saveErrors(SQLException e) {
        this._exception = e;
        this._errorMessage = e.getMessage();
        if (this._errorMessage == null || "".equals(this._errorMessage)) {
            this._errorMessage = e.toString();
        }
        this._errorCode = e.getErrorCode();
    }

    protected boolean isSeekable() {
        return true;
    }

    static class TableKey {
        private final String _url;
        private final String _catalog;
        private final String _schema;
        private final String _table;

        TableKey(String url, String catalog, String schema, String table) {
            this._url = url;
            this._catalog = catalog;
            this._schema = schema;
            this._table = table;
        }

        public int hashCode() {
            int hash = 37;
            if (this._url != null) {
                hash = 65537 * hash + this._url.hashCode();
            }
            if (this._catalog != null) {
                hash = 65537 * hash + this._catalog.hashCode();
            }
            if (this._schema != null) {
                hash = 65537 * hash + this._schema.hashCode();
            }
            if (this._table != null) {
                hash = 65537 * hash + this._table.hashCode();
            }
            return hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TableKey)) {
                return false;
            }
            TableKey key = (TableKey)o;
            if (this._url == null != (key._url == null)) {
                return false;
            }
            if (this._url != null && !this._url.equals(key._url)) {
                return false;
            }
            if (this._catalog == null != (key._catalog == null)) {
                return false;
            }
            if (this._catalog != null && !this._catalog.equals(key._catalog)) {
                return false;
            }
            if (this._schema == null != (key._schema == null)) {
                return false;
            }
            if (this._schema != null && !this._schema.equals(key._schema)) {
                return false;
            }
            if (this._table == null != (key._table == null)) {
                return false;
            }
            return this._table == null || this._table.equals(key._table);
        }
    }
}

