/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.db;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuercusDataSource
implements DataSource {
    private final DataSource _ds;
    private final String _user;
    private final String _pass;
    private final boolean _isAllowPerConnectionUserPass;

    public QuercusDataSource(DataSource ds, String user, String pass, boolean isAllowPerConnectionUserPass) {
        this._ds = ds;
        this._user = user;
        this._pass = pass;
        this._isAllowPerConnectionUserPass = isAllowPerConnectionUserPass;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this._user != null) {
            return this._ds.getConnection(this._user, this._pass);
        }
        return this._ds.getConnection();
    }

    @Override
    public Connection getConnection(String user, String pass) throws SQLException {
        if (user != null && this._isAllowPerConnectionUserPass) {
            return this._ds.getConnection(user, pass);
        }
        return this.getConnection();
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this._ds.getLoginTimeout();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this._ds.getLogWriter();
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this._ds.setLoginTimeout(seconds);
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this._ds.setLogWriter(out);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this._ds.isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this._ds.unwrap(iface);
    }

    @Override
    public Logger getParentLogger() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._ds + "," + this._user + "]";
    }
}

