/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.file;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.file.BinaryInput;
import com.caucho.quercus.lib.file.LineReader;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.VfsStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReadStreamInput
extends InputStream
implements BinaryInput {
    private static final Logger log = Logger.getLogger(ReadStreamInput.class.getName());
    private Env _env;
    private LineReader _lineReader;
    private ReadStream _is;

    public ReadStreamInput(Env env) {
        this._env = env;
    }

    public ReadStreamInput(Env env, InputStream is) {
        this._env = env;
        if (is instanceof ReadStream) {
            this.init((ReadStream)is);
        } else if (is != null) {
            this.init(new ReadStream(new VfsStream(is, null)));
        }
    }

    protected ReadStreamInput(Env env, LineReader lineReader) {
        this._env = env;
        this._lineReader = lineReader;
    }

    protected ReadStreamInput(Env env, LineReader lineReader, ReadStream is) {
        this(env, lineReader);
        this.init(is);
    }

    public void init(ReadStream is) {
        this._is = is;
    }

    public InputStream getInputStream() {
        return this._is;
    }

    public BinaryInput openCopy() throws IOException {
        return new ReadStreamInput(this._env, this._lineReader, this._is.getPath().openRead());
    }

    public void setEncoding(String encoding) throws UnsupportedEncodingException {
        if (this._is != null) {
            this._is.setEncoding(encoding);
        }
    }

    public void unread() throws IOException {
        if (this._is != null) {
            this._is.unread();
        }
    }

    public int getAvailable() throws IOException {
        if (this._is != null) {
            return this._is.available();
        }
        return -1;
    }

    public int read() throws IOException {
        if (this._is != null) {
            return this._is.read();
        }
        return -1;
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        int sublen;
        ReadStream is = this._is;
        if (is == null) {
            return -1;
        }
        int readLength = 0;
        do {
            if ((sublen = is.read(buffer, offset, length)) < 0) {
                return readLength > 0 ? readLength : sublen;
            }
            readLength += sublen;
            offset += sublen;
        } while ((length -= sublen) > 0 && is.getAvailable() > 0);
        return readLength;
    }

    public int read(char[] buffer, int offset, int length) throws IOException {
        if (this._is != null) {
            return this._is.read(buffer, offset, length);
        }
        return -1;
    }

    public StringValue read(int length) throws IOException {
        if (this._is == null) {
            return null;
        }
        StringValue bb = this._env.createBinaryBuilder();
        bb.appendReadAll(this._is, (long)length);
        return bb;
    }

    public boolean readOptionalLinefeed() throws IOException {
        if (this._is == null) {
            return false;
        }
        int ch = this._is.read();
        if (ch == 10) {
            return true;
        }
        this._is.unread();
        return false;
    }

    public void writeToStream(OutputStream os, int length) throws IOException {
        if (this._is != null) {
            this._is.writeToStream(os, length);
        }
    }

    public StringValue appendTo(StringValue builder) {
        if (this._is != null) {
            return builder.append(this._is);
        }
        return builder;
    }

    public StringValue readLine(long length) throws IOException {
        return this.getLineReader().readLine(this._env, this, length);
    }

    public boolean isEOF() {
        if (this._is == null) {
            return true;
        }
        try {
            return this._is.available() <= 0;
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            return true;
        }
    }

    public long getPosition() {
        if (this._is == null) {
            return -1L;
        }
        return this._is.getPosition();
    }

    public boolean setPosition(long offset) {
        if (this._is == null) {
            return false;
        }
        try {
            return this._is.setPosition(offset);
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public long seek(long offset, int whence) {
        long position;
        switch (whence) {
            case 1: {
                position = this.getPosition() + offset;
                break;
            }
            case 2: {
                position = this.getPosition();
                break;
            }
            default: {
                position = offset;
            }
        }
        if (!this.setPosition(position)) {
            return -1L;
        }
        return position;
    }

    public Value stat() {
        return BooleanValue.FALSE;
    }

    private LineReader getLineReader() {
        if (this._lineReader == null) {
            this._lineReader = new LineReader(this._env);
        }
        return this._lineReader;
    }

    public void closeRead() {
        this.close();
    }

    public void close() {
        ReadStream is = this._is;
        this._is = null;
        if (is != null) {
            is.close();
        }
    }

    public Object toJavaObject() {
        return this;
    }

    public String getResourceType() {
        return "stream";
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._is.getPath() + "]";
    }
}

