/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.i18n;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.UnimplementedException;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.TempCharBuffer;
import com.caucho.vfs.TempStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.internet.MimeUtility;

public class IconvUtility {
    private static final Logger log = Logger.getLogger(IconvUtility.class.getName());

    public static StringValue decodeEncode(Env env, StringValue str, String inCharset, String outCharset) throws UnsupportedEncodingException {
        return IconvUtility.decodeEncode(env, str, inCharset, outCharset, 0, Integer.MAX_VALUE);
    }

    public static StringValue decodeEncode(Env env, StringValue str, String inCharset, String outCharset, int offset) throws UnsupportedEncodingException {
        return IconvUtility.decodeEncode(env, str, inCharset, outCharset, offset, Integer.MAX_VALUE);
    }

    public static StringValue decodeEncode(Env env, StringValue str, String inCharset, String outCharset, int offset, int length) throws UnsupportedEncodingException {
        TempCharBuffer tb = TempCharBuffer.allocate();
        char[] charBuf = tb.getBuffer();
        try {
            int sublen;
            Reader in;
            try {
                in = str.toReader(inCharset);
            }
            catch (IOException e) {
                log.log(Level.WARNING, e.toString(), e);
                in = str.toReader("utf-8");
            }
            TempStream ts = new TempStream();
            WriteStream out = new WriteStream(ts);
            try {
                out.setEncoding(outCharset);
            }
            catch (IOException e) {
                log.log(Level.WARNING, e.toString(), e);
                out.setEncoding("utf-8");
            }
            while (offset > 0 && in.read() >= 0) {
                --offset;
            }
            while (length > 0 && (sublen = in.read(charBuf, 0, charBuf.length)) >= 0) {
                sublen = Math.min(length, sublen);
                out.print(charBuf, 0, sublen);
                length -= sublen;
            }
            out.flush();
            StringValue sb = env.createBinaryBuilder();
            for (TempBuffer ptr = ts.getHead(); ptr != null; ptr = ptr.getNext()) {
                sb.append(ptr.getBuffer(), 0, ptr.getLength());
            }
            StringValue stringValue = sb;
            return stringValue;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
        finally {
            TempCharBuffer.free(tb);
        }
    }

    public static StringValue decodeMime(Env env, CharSequence word, String charset) throws UnsupportedEncodingException {
        StringValue str = env.createString(MimeUtility.unfold((String)MimeUtility.decodeText((String)((Object)word).toString())));
        return str.toBinaryValue(charset);
    }

    public static Value encodeMime(Env env, StringValue name, StringValue value, String inCharset, String outCharset, String scheme) throws UnsupportedEncodingException {
        return IconvUtility.encodeMime(env, name, value, inCharset, outCharset, scheme, "\r\n", 76);
    }

    public static StringValue encodeMime(Env env, StringValue name, StringValue value, String inCharset, String outCharset, String scheme, String lineBreakChars, int lineLength) throws UnsupportedEncodingException {
        name = name.toUnicodeValue(env, inCharset);
        value = value.toUnicodeValue(env, inCharset);
        StringValue sb = env.createUnicodeBuilder();
        sb.append(name);
        sb.append(':');
        sb.append(' ');
        String word = IconvUtility.encodeMimeWord(value.toString(), outCharset, scheme, lineBreakChars, lineLength);
        sb.append(MimeUtility.fold((int)sb.length(), (String)word));
        return sb;
    }

    public static String encodeMimeWord(String value, String charset, String scheme, String lineBreakChars, int lineLength) throws UnsupportedEncodingException {
        if (lineLength != 76) {
            throw new UnimplementedException("Mime line length option");
        }
        if (!lineBreakChars.equals("\r\n")) {
            throw new UnimplementedException("Mime line break option");
        }
        return MimeUtility.encodeWord((String)value, (String)charset, (String)scheme);
    }
}

