/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.pdf;

import com.caucho.quercus.lib.pdf.PDFStream;
import com.caucho.quercus.lib.pdf.PDFWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class PDFPage {
    private static final Logger log = Logger.getLogger(PDFStream.class.getName());
    private static final L10N L = new L10N(PDFStream.class);
    private int _parent;
    private int _id;
    private PDFStream _stream;
    private double _width;
    private double _height;
    private HashMap<String, String> _resources = new HashMap();

    PDFPage(PDFWriter out, int parent, double width, double height) {
        this._parent = parent;
        this._id = out.allocateId(1);
        this._width = width;
        this._height = height;
        this._stream = new PDFStream(out.allocateId(1));
    }

    public int getId() {
        return this._id;
    }

    public double getWidth() {
        return this._width;
    }

    public double getHeight() {
        return this._height;
    }

    public PDFStream getStream() {
        return this._stream;
    }

    void addResource(String name, String value) {
        String oldValue = this._resources.get(name);
        if (oldValue == null || oldValue.equals(value)) {
            this._resources.put(name, value);
            return;
        }
        if (oldValue.startsWith("<<")) {
            String oldValueStrip = oldValue.substring(2, oldValue.length() - 2);
            String valueStrip = value.substring(2, value.length() - 2);
            ArrayList<String> oldValueList = new ArrayList<String>();
            for (String elt : oldValueStrip.split("\n")) {
                oldValueList.add(elt);
            }
            for (String elt : valueStrip.split("\n")) {
                if (oldValueList.contains(elt)) continue;
                oldValueList.add(elt);
            }
            StringBuilder sb = new StringBuilder();
            sb.append("<<");
            for (int i = 0; i < oldValueList.size(); ++i) {
                if (i != 0) {
                    sb.append("\n");
                }
                sb.append((String)oldValueList.get(i));
            }
            sb.append(">>");
            this._resources.put(name, sb.toString());
        }
    }

    void write(PDFWriter out) throws IOException {
        out.beginObject(this._id);
        out.println("  << /Type /Page");
        out.println("     /Parent " + this._parent + " 0 R");
        out.println("     /MediaBox [0 0 " + this._width + " " + this._height + "]");
        out.println("     /Contents " + this._stream.getId() + " 0 R");
        out.println("     /Resources <<");
        for (Map.Entry<String, String> entry : this._resources.entrySet()) {
            out.println("     " + entry.getKey() + " " + entry.getValue());
        }
        out.println("     >>");
        out.println("  >>");
        out.endObject();
        this._stream.write(out);
    }
}

