/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.reflection;

import com.caucho.quercus.UnimplementedException;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.ReturnNullAsFalse;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.MethodMap;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.QuercusLanguageException;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.function.AbstractFunction;
import com.caucho.quercus.lib.reflection.ReflectionException;
import com.caucho.quercus.lib.reflection.ReflectionExtension;
import com.caucho.quercus.lib.reflection.ReflectionMethod;
import com.caucho.quercus.lib.reflection.ReflectionProperty;
import com.caucho.quercus.lib.reflection.Reflector;
import com.caucho.quercus.program.ClassDef;
import com.caucho.quercus.program.ClassField;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ReflectionClass
implements Reflector {
    private static final L10N L = new L10N(ReflectionClass.class);
    public static int IS_IMPLICIT_ABSTRACT = 16;
    public static int IS_EXPLICIT_ABSTRACT = 32;
    public static int IS_FINAL = 64;
    public String _name;
    private QuercusClass _cls;

    protected ReflectionClass(QuercusClass cls) {
        this._cls = cls;
        this._name = cls.getName();
    }

    protected ReflectionClass(Env env, String name) {
        this._cls = env.findClass(name);
        this._name = name;
    }

    protected QuercusClass getQuercusClass() {
        return this._cls;
    }

    private final ReflectionClass __clone() {
        return new ReflectionClass(this._cls);
    }

    public static ReflectionClass __construct(Env env, Value obj) {
        QuercusClass cls = obj.isObject() ? ((ObjectValue)obj.toValue()).getQuercusClass() : env.findClass(obj.toString());
        if (cls == null) {
            throw new ReflectionException(env, L.l("class '{0}' doesn't exist", (Object)obj));
        }
        return new ReflectionClass(cls);
    }

    public static String export(Env env, Value cls, @Optional boolean isReturn) {
        return null;
    }

    public String getName() {
        return this._name;
    }

    public String getNamespaceName() {
        String name = this.getName();
        int p = name.lastIndexOf(92);
        if (p < 0) {
            return "";
        }
        return name.substring(0, p);
    }

    public String getShortName() {
        String name = this.getName();
        int p = name.lastIndexOf(92);
        if (p < 0) {
            return name;
        }
        return name.substring(p + 1);
    }

    public boolean inNamespace() {
        String name = this.getName();
        return name.contains("\\");
    }

    public boolean isInternal() {
        throw new UnimplementedException("ReflectionClass->isInternal()");
    }

    public boolean isUserDefined() {
        throw new UnimplementedException("ReflectionClass->isUserDefined()");
    }

    public boolean isInstantiable() {
        return !this._cls.isInterface();
    }

    public boolean hasConstant(StringValue name) {
        return this._cls.hasConstant(name);
    }

    public String getFileName() {
        return this._cls.getClassDef().getLocation().getFileName();
    }

    public int getStartLine() {
        return this._cls.getClassDef().getLocation().getLineNumber();
    }

    public int getEndLine() {
        return this._cls.getClassDef().getLocation().getLineNumber();
    }

    @ReturnNullAsFalse
    public String getDocComment() {
        ClassDef def = this._cls.getClassDef();
        return def.getComment();
    }

    public ReflectionMethod getConstructor() {
        AbstractFunction cons = this._cls.getConstructor();
        if (cons != null) {
            return new ReflectionMethod(this._name, cons);
        }
        return null;
    }

    public boolean hasMethod(StringValue name) {
        MethodMap<AbstractFunction> map = this._cls.getMethodMap();
        return map.containsKey(name);
    }

    public ReflectionMethod getMethod(Env env, StringValue name) {
        AbstractFunction fun = this._cls.findFunction(name);
        if (fun == null) {
            throw new QuercusLanguageException(env.createException("ReflectionException", L.l("method {0}::{1}() does not exist", (Object)this._name, (Object)name)));
        }
        return new ReflectionMethod(this._name, this._cls.getFunction(name));
    }

    public ArrayValue getMethods(Env env) {
        ArrayValueImpl array = new ArrayValueImpl();
        MethodMap<AbstractFunction> map = this._cls.getMethodMap();
        for (AbstractFunction method : map.values()) {
            ((ArrayValue)array).put(env.wrapJava(new ReflectionMethod(this._cls.getName(), method)));
        }
        return array;
    }

    public boolean hasProperty(StringValue name) {
        return this._cls.getClassField(name) != null;
    }

    public ReflectionProperty getProperty(Env env, StringValue name) {
        return new ReflectionProperty(env, this._cls, name);
    }

    public ArrayValue getProperties(Env env) {
        ArrayValueImpl array = new ArrayValueImpl();
        HashMap<StringValue, ClassField> fieldMap = this._cls.getClassFields();
        for (ClassField field : fieldMap.values()) {
            ReflectionProperty prop = ReflectionProperty.create(env, this._cls, field.getName(), false);
            ((ArrayValue)array).put(env.wrapJava(prop));
        }
        ArrayList<StringValue> staticFieldList = this._cls.getStaticFieldNames();
        for (StringValue fieldName : staticFieldList) {
            ReflectionProperty prop = ReflectionProperty.create(env, this._cls, fieldName, true);
            ((ArrayValue)array).put(env.wrapJava(prop));
        }
        return array;
    }

    public ArrayValue getConstants(Env env) {
        ArrayValueImpl array = new ArrayValueImpl();
        HashMap<StringValue, Value> _constMap = this._cls.getConstantMap(env);
        for (Map.Entry<StringValue, Value> entry : _constMap.entrySet()) {
            Value name = entry.getKey();
            array.put(name, entry.getValue());
        }
        return array;
    }

    public Value getConstant(Env env, StringValue name) {
        if (this.hasConstant(name)) {
            return this._cls.getConstant(env, name);
        }
        return BooleanValue.FALSE;
    }

    public ArrayValue getInterfaces(Env env) {
        ArrayValueImpl array = new ArrayValueImpl();
        this.findInterfaces(env, (ArrayValue)array, this._cls);
        return array;
    }

    private void findInterfaces(Env env, ArrayValue array, QuercusClass cls) {
        if (cls.isInterface()) {
            array.put(StringValue.create(cls.getName()), env.wrapJava(new ReflectionClass(cls)));
        } else {
            ClassDef[] defList = cls.getClassDefList();
            for (int i = 0; i < defList.length; ++i) {
                this.findInterfaces(env, array, defList[i]);
            }
        }
    }

    private void findInterfaces(Env env, ArrayValue array, ClassDef def) {
        String name = def.getName();
        if (def.isInterface()) {
            this.addInterface(env, array, name);
        } else {
            String[] defList = def.getInterfaces();
            for (int i = 0; i < defList.length; ++i) {
                QuercusClass cls = env.findClass(defList[i]);
                this.findInterfaces(env, array, cls);
            }
        }
    }

    private void addInterface(Env env, ArrayValue array, String name) {
        QuercusClass cls = env.findClass(name);
        array.put(StringValue.create(name), env.wrapJava(new ReflectionClass(cls)));
    }

    public boolean isInterface() {
        return this._cls.isInterface();
    }

    public boolean isAbstract() {
        return this._cls.isAbstract();
    }

    public boolean isFinal() {
        return this._cls.isFinal();
    }

    public int getModifiers() {
        int flag = 0;
        if (this.isFinal()) {
            flag |= IS_FINAL;
        }
        return flag;
    }

    public boolean isInstance(Env env, ObjectValue obj) {
        return obj.isA(env, this._name);
    }

    public Value newInstance(Env env, @Optional Value[] args) {
        return this._cls.callNew(env, args);
    }

    public Value newInstanceArgs(Env env, @Optional ArrayValue args) {
        if (args == null) {
            return this._cls.callNew(env, new Value[0]);
        }
        return this._cls.callNew(env, args.getValueArray(env));
    }

    @ReturnNullAsFalse
    public ReflectionClass getParentClass() {
        QuercusClass parent = this._cls.getParent();
        if (parent == null) {
            return null;
        }
        return new ReflectionClass(parent);
    }

    public boolean isSubclassOf(Env env, Object obj) {
        String clsName = obj instanceof ReflectionClass ? ((ReflectionClass)obj).getName() : obj.toString();
        if (this._cls.getName().equals(clsName)) {
            return false;
        }
        return this._cls.isA(env, clsName);
    }

    public ArrayValue getStaticProperties(Env env) {
        ArrayValueImpl array = new ArrayValueImpl();
        this.getStaticFields(env, array, this._cls);
        return array;
    }

    private void getStaticFields(Env env, ArrayValue array, QuercusClass cls) {
        if (cls == null) {
            return;
        }
        for (StringValue name : cls.getStaticFieldNames()) {
            Value field = cls.getStaticFieldValue(env, name);
            array.put(name, field.toValue());
        }
        this.getStaticFields(env, array, cls.getParent());
    }

    public Value getStaticPropertyValue(Env env, StringValue name, @Optional Value defaultV) {
        Value field = this._cls.getStaticFieldInternal(env, name);
        if (field == null) {
            if (!defaultV.isDefault()) {
                return defaultV;
            }
            throw new QuercusLanguageException(env.createException("ReflectionException", L.l("Class '{0}' does not have a property named '{1}'", (Object)this._name, (Object)name)));
        }
        return field;
    }

    public void setStaticPropertyValue(Env env, StringValue name, Value value) {
        this._cls.getStaticFieldVar(env, name).set(value);
    }

    public ArrayValue getDefaultProperties(Env env) {
        ArrayValueImpl array = new ArrayValueImpl();
        this.getStaticFields(env, array, this._cls);
        HashMap<StringValue, ClassField> fieldMap = this._cls.getClassFields();
        for (Map.Entry<StringValue, ClassField> entry : fieldMap.entrySet()) {
            Expr initExpr = entry.getValue().getInitExpr();
            array.put(entry.getKey(), initExpr.eval(env));
        }
        return array;
    }

    public boolean isIterateable() {
        return this._cls.getTraversableDelegate() != null;
    }

    public boolean implementsInterface(Env env, String name) {
        return this._cls.implementsInterface(env, name);
    }

    public ReflectionExtension getExtension(Env env) {
        String extName = this.getExtensionName();
        if (extName != null) {
            return new ReflectionExtension(env, extName);
        }
        return null;
    }

    public String getExtensionName() {
        return this._cls.getExtension();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._name + "]";
    }
}

