/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.reflection;

import com.caucho.quercus.annotation.ReturnNullAsFalse;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.Callable;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.expr.ParamRequiredExpr;
import com.caucho.quercus.lib.reflection.ReflectionParameter;
import com.caucho.quercus.program.Arg;

public abstract class ReflectionFunctionAbstract {
    private Callable _callable;

    protected ReflectionFunctionAbstract(Callable callable) {
        this._callable = callable;
        if (callable == null) {
            throw new NullPointerException();
        }
    }

    protected Callable getCallable() {
        return this._callable;
    }

    private void __clone() {
    }

    public String getName() {
        return this._callable.getCallbackName();
    }

    public boolean isInternal() {
        return false;
    }

    public boolean isUserDefined() {
        return false;
    }

    public String getFileName(Env env) {
        return this._callable.getDeclFileName(env);
    }

    public int getStartLine(Env env) {
        return this._callable.getDeclStartLine(env);
    }

    public int getEndLine(Env env) {
        return this._callable.getDeclEndLine(env);
    }

    @ReturnNullAsFalse
    public String getDocComment(Env env) {
        return this._callable.getDeclComment(env);
    }

    public ArrayValue getStaticVariables() {
        return null;
    }

    public boolean returnsReference(Env env) {
        return this._callable.isReturnsReference(env);
    }

    public ArrayValue getParameters(Env env) {
        ArrayValueImpl array = new ArrayValueImpl();
        Arg[] args = this._callable.getArgs(env);
        for (int i = 0; i < args.length; ++i) {
            ((ArrayValue)array).put(env.wrapJava(new ReflectionParameter(this._callable, args[i])));
        }
        return array;
    }

    public int getNumberOfParameters(Env env) {
        return this._callable.getArgs(env).length;
    }

    public int getNumberOfRequiredParameters(Env env) {
        Arg[] args = this._callable.getArgs(env);
        int requiredParams = 0;
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i].getDefault() instanceof ParamRequiredExpr)) continue;
            ++requiredParams;
        }
        return requiredParams;
    }
}

