/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.regexp;

import com.caucho.util.IntArray;

class GroupState {
    static final int BIT_WIDTH = 32;
    static final int MAX_SIZE = 99;
    private long[] _set;
    private IntArray _group;
    private GroupState _freeList;

    public GroupState() {
        int arraySize = 3;
        this._set = new long[++arraySize];
        this._group = new IntArray();
    }

    private GroupState(GroupState src) {
        this._set = new long[src._set.length];
        this._group = new IntArray();
        this._group.add(src._group);
        for (int i = 0; i < src._set.length; ++i) {
            this._set[i] = src._set[i];
        }
    }

    public boolean isMatched(int group) {
        int i = group / 32;
        if (group > 99) {
            throw new RuntimeException("out of range: " + group + " >= " + 99);
        }
        int shift = group - i * 32;
        int bit = 1 << shift;
        return (this._set[i] & (long)bit) != 0L;
    }

    public void setMatched(int group) {
        int i = group / 32;
        if (group > 99) {
            throw new RuntimeException("out of range: " + group + " >= " + 99);
        }
        int shift = group - i * 32;
        int bit = 1 << shift;
        int n = i;
        this._set[n] = this._set[n] | (long)bit;
    }

    public GroupState copy() {
        GroupState state;
        if (this._freeList != null) {
            state = this._freeList;
            this._freeList = this._freeList._freeList;
            state._freeList = null;
            state._group.clear();
            state._group.add(this._group);
            for (int i = 0; i < this._set.length; ++i) {
                state._set[i] = this._set[i];
            }
        } else {
            state = new GroupState(this);
        }
        return state;
    }

    public void free(GroupState state) {
        if (state != null && state != this) {
            state._freeList = this._freeList;
            this._freeList = state;
        }
    }

    public void clear() {
        this._group.clear();
        for (int i = 0; i < this._set.length; ++i) {
            this._set[i] = 0L;
        }
    }

    public int size() {
        return this._group.size();
    }

    public int get(int i) {
        return this._group.get(i);
    }

    public void set(int i, int val) {
        this._group.set(i, val);
    }

    public void setLength(int len) {
        this._group.setLength(len);
    }
}

