/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.session;

import com.caucho.config.ConfigException;
import com.caucho.quercus.QuercusContext;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.SessionArrayValue;
import com.caucho.quercus.env.StringBuilderValue;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.Base64;
import com.caucho.util.CharBuffer;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import com.caucho.util.RandomUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cache.Cache;

public class QuercusSessionManager
implements AlarmListener {
    private static final L10N L = new L10N(QuercusSessionManager.class);
    private static final Logger log = Logger.getLogger(QuercusSessionManager.class.getName());
    private static int FALSE = 0;
    private static int COOKIE = 1;
    private static int TRUE = 2;
    private static int UNSET = 0;
    private static int SET_TRUE = 1;
    private static int SET_FALSE = 2;
    protected LruCache<String, SessionArrayValue> _sessions;
    private int _totalSessions;
    protected Iterator<SessionArrayValue> _sessionIter;
    protected ArrayList<SessionArrayValue> _sessionList = new ArrayList();
    protected int _sessionMax = 4096;
    private long _sessionTimeout = 1800000L;
    private int _reuseSessionId = COOKIE;
    private int _cookieLength = 18;
    private int _alwaysLoadSession;
    private boolean _alwaysSaveSession;
    private boolean _saveOnlyOnShutdown;
    private boolean _isModuloSessionId = false;
    private boolean _isAppendServerIndex = false;
    private boolean _isTwoDigitSessionIndex = false;
    protected boolean _isClosed;
    private Cache _persistentStore;
    protected Object _statisticsLock = new Object();
    protected long _sessionCreateCount;
    protected long _sessionTimeoutCount;

    public QuercusSessionManager(QuercusContext quercus) {
        this._sessions = new LruCache(this._sessionMax);
        this._sessionIter = this._sessions.values();
        this._persistentStore = quercus.getSessionCache();
    }

    boolean getAlwaysSaveSession() {
        return this._alwaysSaveSession;
    }

    public void setAlwaysSaveSession(boolean save) {
        this._alwaysSaveSession = save;
    }

    boolean getAlwaysLoadSession() {
        return this._alwaysLoadSession == SET_TRUE;
    }

    public void setAlwaysLoadSession(boolean load) {
        this._alwaysLoadSession = load ? SET_TRUE : SET_FALSE;
    }

    public boolean getSaveOnlyOnShutdown() {
        return this._saveOnlyOnShutdown;
    }

    public void setSaveOnlyOnShutdown(boolean save) {
        this._saveOnlyOnShutdown = save;
    }

    public void setSaveOnShutdown(boolean save) {
        log.warning("<save-on-shutdown> is deprecated.  Use <save-only-on-shutdown> instead");
        this.setSaveOnlyOnShutdown(save);
    }

    public void setCookieLength(int cookieLength) {
        if (cookieLength < 7) {
            cookieLength = 7;
        }
        this._cookieLength = cookieLength;
    }

    protected void setSessionTimeout(long sessionTimeout) {
        this._sessionTimeout = sessionTimeout;
    }

    public int getActiveSessionCount() {
        if (this._sessions == null) {
            return -1;
        }
        return this._sessions.size();
    }

    public long getSessionCreateCount() {
        return this._sessionCreateCount;
    }

    public long getSessionTimeoutCount() {
        return this._sessionTimeoutCount;
    }

    public int getReuseSessionId() {
        return this._reuseSessionId;
    }

    public void setReuseSessionId(String reuse) throws ConfigException {
        if (reuse == null) {
            this._reuseSessionId = COOKIE;
        } else if (reuse.equalsIgnoreCase("true") || reuse.equalsIgnoreCase("yes") || reuse.equalsIgnoreCase("cookie")) {
            this._reuseSessionId = COOKIE;
        } else if (reuse.equalsIgnoreCase("false") || reuse.equalsIgnoreCase("no")) {
            this._reuseSessionId = FALSE;
        } else if (reuse.equalsIgnoreCase("all")) {
            this._reuseSessionId = TRUE;
        } else {
            throw new ConfigException(L.l("'{0}' is an invalid value for reuse-session-id.  'true' or 'false' are the allowed values.", (Object)reuse));
        }
    }

    public boolean isClosed() {
        return this._isClosed;
    }

    public int getSessionMax() {
        return this._sessionMax;
    }

    public void setSessionMax(int max) {
        this._sessionMax = max;
    }

    public void removeSession(String sessionId) {
        this._sessions.remove(sessionId);
        if (this._persistentStore != null) {
            this._persistentStore.remove(sessionId);
        }
        this.remove(sessionId);
    }

    protected void remove(String sessionId) {
    }

    public void load(ObjectInputStream in, Object obj) throws IOException {
        SessionArrayValue session = (SessionArrayValue)obj;
        session.load(null, in);
    }

    public boolean isEmpty(Object obj) {
        SessionArrayValue session = (SessionArrayValue)obj;
        return session.isEmpty();
    }

    public void setCookieAppendServerIndex(boolean isAppend) {
        this._isAppendServerIndex = isAppend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionArrayValue createSession(Env env, String oldId, long now) {
        SessionArrayValue session;
        String id = oldId;
        if (id == null || id.length() < 4) {
            id = this.createSessionId(env);
        }
        if ((session = this.create(env, id, now)) == null) {
            return null;
        }
        Object object = this._statisticsLock;
        synchronized (object) {
            ++this._sessionCreateCount;
        }
        return session;
    }

    public String createSessionId(Env env) {
        CharBuffer sb;
        String id;
        do {
            sb = new CharBuffer();
            Base64.encode(sb, RandomUtil.getRandomLong());
            Base64.encode(sb, env.getCurrentTime());
        } while (this.getSession(env, id = sb.toString(), 0L) != null);
        if (id == null || id.equals("")) {
            throw new RuntimeException();
        }
        return id;
    }

    public SessionArrayValue getSession(Env env, String key, long now) {
        boolean isNew = false;
        boolean killSession = false;
        if (this._sessions == null) {
            return null;
        }
        SessionArrayValue session = this._sessions.get(key);
        if (session != null && !session.getId().equals(key)) {
            throw new IllegalStateException(key + " != " + session.getId());
        }
        if (session != null && session.inUse()) {
            System.out.println("USE:" + isNew);
            return (SessionArrayValue)session.copy(env);
        }
        if (session == null) {
            return null;
        }
        if (isNew) {
            isNew = !this.load(env, session, now);
            System.out.println("LOAD:" + isNew);
        } else if (!this.getSaveOnlyOnShutdown() && !session.load()) {
            session.reset(now);
            isNew = true;
        }
        if (!isNew) {
            session.setAccess(now);
        }
        return (SessionArrayValue)session.copy(env);
    }

    public void saveSession(Env env, SessionArrayValue session) {
        SessionArrayValue copy = (SessionArrayValue)session.copy(env);
        this._sessions.put(session.getId(), copy);
        session.finish();
        if (this._persistentStore != null) {
            this._persistentStore.put(session.getId(), copy.encode(env));
        }
    }

    protected SessionArrayValue create(Env env, String key, long now) {
        SessionArrayValue session = this.createSessionValue(key, now, this._sessionTimeout);
        this.load(env, session, now);
        session = this._sessions.putIfNew(key, session);
        if (!key.equals(session.getId())) {
            throw new IllegalStateException(key + " != " + session.getId());
        }
        return (SessionArrayValue)session.copy(env);
    }

    protected SessionArrayValue createSessionValue(String key, long now, long sessionTimeout) {
        return new SessionArrayValue(key, now, this._sessionTimeout);
    }

    protected boolean load(Env env, SessionArrayValue session, long now) {
        try {
            String encoded;
            if (session.inUse()) {
                return true;
            }
            if (now <= 0L) {
                return false;
            }
            if (this._persistentStore != null && (encoded = (String)this._persistentStore.get(session.getId())) != null) {
                session.decode(env, new StringBuilderValue(encoded));
            }
            if (session.load()) {
                session.setAccess(now);
                return true;
            }
            session.reset(now);
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            session.reset(now);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAlarm(Alarm alarm) {
        try {
            SessionArrayValue session;
            this._sessionList.clear();
            int liveSessions = 0;
            if (this._isClosed) {
                return;
            }
            long now = CurrentTime.getCurrentTime();
            Object object = this._sessions;
            synchronized (object) {
                this._sessionIter = this._sessions.values(this._sessionIter);
                while (this._sessionIter.hasNext()) {
                    session = this._sessionIter.next();
                    long maxIdleTime = session.getMaxInactiveInterval();
                    if (session.inUse()) {
                        ++liveSessions;
                        continue;
                    }
                    if (session.getAccessTime() + maxIdleTime < now) {
                        this._sessionList.add(session);
                        continue;
                    }
                    ++liveSessions;
                }
            }
            object = this._statisticsLock;
            synchronized (object) {
                this._sessionTimeoutCount += (long)this._sessionList.size();
            }
            for (int i = 0; i < this._sessionList.size(); ++i) {
                session = this._sessionList.get(i);
                try {
                    long maxIdleTime = session.getMaxInactiveInterval();
                    this._sessions.remove(session.getId());
                    session.invalidate();
                    continue;
                }
                catch (Throwable e) {
                    log.log(Level.FINER, e.toString(), e);
                }
            }
        }
        finally {
            if (!this._isClosed) {
                alarm.queue(60000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        SessionArrayValue session;
        QuercusSessionManager quercusSessionManager = this;
        synchronized (quercusSessionManager) {
            if (this._isClosed) {
                return;
            }
            this._isClosed = true;
        }
        if (this._sessions == null) {
            return;
        }
        this._sessionList.clear();
        ArrayList<SessionArrayValue> list = new ArrayList<SessionArrayValue>();
        boolean isError = false;
        LruCache<String, SessionArrayValue> lruCache = this._sessions;
        synchronized (lruCache) {
            this._sessionIter = this._sessions.values(this._sessionIter);
            while (this._sessionIter.hasNext()) {
                session = this._sessionIter.next();
                if (!session.isValid()) continue;
                list.add(session);
            }
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            session = (SessionArrayValue)list.get(i);
            try {
                if (session.isValid()) {
                    SessionArrayValue sessionArrayValue = session;
                    synchronized (sessionArrayValue) {
                        if (!session.isEmpty()) {
                            session.storeOnShutdown();
                        }
                    }
                }
                this._sessions.remove(session.getId());
                continue;
            }
            catch (Exception e) {
                if (!isError) {
                    log.log(Level.WARNING, "Can't store session: " + e, e);
                }
                isError = true;
            }
        }
    }

    public void notifyRemove(String id) {
        SessionArrayValue session = this._sessions.remove(id);
        if (session != null) {
            session.invalidate();
        }
    }

    public void notifyUpdate(String id) {
    }

    public void store(OutputStream out, Object obj) throws IOException {
        SessionArrayValue session = (SessionArrayValue)obj;
        session.store(Env.getInstance(), out);
    }
}

