/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.spl;

import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Callable;
import com.caucho.quercus.env.CallbackFunction;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.module.AbstractQuercusModule;
import java.util.ArrayList;
import java.util.Locale;

public class SplModule
extends AbstractQuercusModule {
    private static String DEFAULT_EXTENSIONS = ".php,.inc";

    public String[] getLoadedExtensions() {
        return new String[]{"SPL"};
    }

    public static Value class_implements(Env env, Value obj, @Optional boolean autoload) {
        QuercusClass cls = obj.isObject() ? ((ObjectValue)obj.toObject(env)).getQuercusClass() : env.findClass(obj.toString(), autoload, true, true);
        if (cls != null) {
            return cls.getInterfaces(env, autoload);
        }
        return BooleanValue.FALSE;
    }

    public static Value class_parents(Env env, Value obj, @Optional boolean autoload) {
        QuercusClass cls = obj.isObject() ? ((ObjectValue)obj.toObject(env)).getQuercusClass() : env.findClass(obj.toString(), autoload, true, true);
        if (cls != null) {
            ArrayValueImpl array = new ArrayValueImpl();
            QuercusClass parent = cls;
            while ((parent = parent.getParent()) != null) {
                String name = parent.getName();
                array.put(name, name);
            }
            return array;
        }
        return BooleanValue.FALSE;
    }

    public static boolean spl_autoload_register(Env env, @Optional Callable fun, @Optional(value="true") boolean isThrowErrors, @Optional boolean isPrepend) {
        if (fun == null) {
            fun = new CallbackFunction(env, env.createString("spl_autoload"));
        }
        env.addAutoloadFunction(fun, isPrepend);
        return true;
    }

    public static boolean spl_autoload_unregister(Env env, Callable fun) {
        env.removeAutoloadFunction(fun);
        return true;
    }

    public static Value spl_autoload_functions(Env env) {
        ArrayList<Callable> funList = env.getAutoloadFunctions();
        if (funList == null) {
            return BooleanValue.FALSE;
        }
        ArrayValueImpl array = new ArrayValueImpl();
        int size = funList.size();
        for (int i = 0; i < size; ++i) {
            Callable cb = funList.get(i);
            ((ArrayValue)array).put(env.createString(cb.toString()));
        }
        return array;
    }

    public static String spl_autoload_extensions(Env env, @Optional String extensions) {
        String oldExtensions = SplModule.getAutoloadExtensions(env);
        if (extensions != null) {
            env.setSpecialValue("caucho.spl_autoload", extensions);
        }
        return oldExtensions;
    }

    private static String getAutoloadExtensions(Env env) {
        Object obj = env.getSpecialValue("caucho.spl_autoload");
        if (obj == null) {
            return DEFAULT_EXTENSIONS;
        }
        return (String)obj;
    }

    public static void spl_autoload(Env env, String className, @Optional String extensions) {
        if (env.findClass(className, false, true, true) != null) {
            return;
        }
        String[] extensionList = extensions == null || "".equals(extensions) ? new String[]{".php", ".inc"} : extensions.split("[,\\s]+");
        String filePrefix = className.toLowerCase(Locale.ENGLISH);
        for (String ext : extensionList) {
            StringValue sb = env.createStringBuilder();
            sb.append(filePrefix);
            sb.append(ext);
            env.include(sb);
            QuercusClass cls = env.findClass(className, false, true, true);
            if (cls == null) continue;
            return;
        }
    }

    public static StringValue spl_object_hash(Env env, ObjectValue obj) {
        return obj.getObjectHash(env);
    }
}

