/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.zlib;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.lib.file.BinaryInput;
import com.caucho.quercus.lib.file.ReadStreamInput;
import com.caucho.quercus.lib.zlib.GZInputStream;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.VfsStream;
import java.io.IOException;

public class ZlibInputStream
extends ReadStreamInput {
    private Env _env;
    private BinaryInput _in;
    private GZInputStream _gzIn;
    private ReadStream _rs;

    public ZlibInputStream(Env env, BinaryInput in) throws IOException {
        super(env);
        this._env = env;
        this.init(in);
    }

    private void init(BinaryInput in) throws IOException {
        ReadStream rs;
        this._in = in;
        this._gzIn = new GZInputStream(in.getInputStream());
        this._rs = rs = new ReadStream(new VfsStream(this._gzIn, null));
        this.init(rs);
    }

    public BinaryInput openCopy() throws IOException {
        return new ZlibInputStream(this._env, this._in.openCopy());
    }

    public boolean setPosition(long offset) {
        try {
            long pos = this._rs.getPosition();
            if (pos <= offset && this._rs.setPosition(offset)) {
                return true;
            }
            this.close();
            BinaryInput newIn = this._in.openCopy();
            this.init(newIn);
            long skipped = this.skip(offset);
            return skipped == offset;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new QuercusModuleException(e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._in + "]";
    }
}

