/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.marshal;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.JavaCalendarValue;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.marshal.Marshal;
import java.util.Calendar;

public class CalendarMarshal
extends Marshal {
    public static final Marshal MARSHAL = new CalendarMarshal();

    public Object marshal(Env env, Expr expr, Class expectedClass) {
        return this.marshal(env, expr.eval(env), expectedClass);
    }

    public Object marshal(Env env, Value value, Class expectedClass) {
        return value.toJavaCalendar();
    }

    public Value unmarshal(Env env, Object value) {
        return env.wrapJava((Calendar)value);
    }

    protected int getMarshalingCostImpl(Value argValue) {
        if (argValue instanceof JavaCalendarValue) {
            return 0;
        }
        if (argValue instanceof LongValue) {
            return 300;
        }
        if (argValue.isLongConvertible()) {
            return 300;
        }
        return 400;
    }

    public Class getExpectedClass() {
        return Calendar.class;
    }
}

