/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.marshal;

import com.caucho.quercus.env.Callable;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.marshal.Marshal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallableMarshal
extends Marshal {
    public static final Marshal MARSHAL = new CallableMarshal(false);
    public static final Marshal MARSHAL_OPTIONAL = new CallableMarshal(true);
    protected boolean _isOptional;

    protected CallableMarshal(boolean isOptional) {
        this._isOptional = isOptional;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public Object marshal(Env env, Expr expr, Class expectedClass) {
        return this.marshal(env, expr.eval(env), expectedClass);
    }

    @Override
    protected Object marshalImpl(Env env, Value value, Class<?> expectedClass) {
        Callable callable = value.toCallable(env, this._isOptional);
        return callable;
    }

    @Override
    public Value unmarshal(Env env, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int getMarshalingCostImpl(Value argValue) {
        if (argValue instanceof Callable) {
            return 0;
        }
        if (argValue.isString()) {
            return 300;
        }
        return 400;
    }

    @Override
    public Class getExpectedClass() {
        return Callable.class;
    }
}

