/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.marshal;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.marshal.Marshal;

public class CharacterMarshal
extends Marshal {
    public static final Marshal MARSHAL = new CharacterMarshal();

    public boolean isReadOnly() {
        return true;
    }

    public Object marshal(Env env, Expr expr, Class expectedClass) {
        return new Character(expr.evalChar(env));
    }

    public Object marshal(Env env, Value value, Class expectedClass) {
        return new Character(value.toChar());
    }

    public Value unmarshal(Env env, Object value) {
        if (value == null) {
            return NullValue.NULL;
        }
        return env.createString(value.toString());
    }

    protected int getMarshalingCostImpl(Value argValue) {
        return argValue.toCharMarshalCost();
    }

    public Class getExpectedClass() {
        return Character.TYPE;
    }
}

