/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.marshal;

import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.marshal.Marshal;

public class DoubleMarshal
extends Marshal {
    public static final DoubleMarshal MARSHAL = new DoubleMarshal();

    public boolean isDouble() {
        return true;
    }

    public boolean isReadOnly() {
        return true;
    }

    public Object marshal(Env env, Expr expr, Class expectedClass) {
        return new Double(expr.evalDouble(env));
    }

    public Object marshal(Env env, Value value, Class expectedClass) {
        return new Double(value.toDouble());
    }

    public Value unmarshal(Env env, Object value) {
        if (value == null) {
            return DoubleValue.ZERO;
        }
        return new DoubleValue(((Number)value).doubleValue());
    }

    protected int getMarshalingCostImpl(Value argValue) {
        return argValue.toDoubleMarshalCost();
    }

    public Class getExpectedClass() {
        return Double.TYPE;
    }
}

