/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.marshal;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.marshal.Marshal;

public class ExpectMarshal
extends Marshal {
    private Type _type;
    public static final Marshal MARSHAL_EXPECT_STRING = new ExpectMarshal(Type.STRING);
    public static final Marshal MARSHAL_EXPECT_NUMERIC = new ExpectMarshal(Type.NUMERIC);
    public static final Marshal MARSHAL_EXPECT_BOOLEAN = new ExpectMarshal(Type.BOOLEAN);

    protected ExpectMarshal(Type type) {
        this._type = type;
    }

    protected Value expect(Env env, Value value) {
        if (this._type == Type.STRING) {
            return env.expectString(value);
        }
        if (this._type == Type.NUMERIC) {
            return env.expectNumeric(value);
        }
        return env.expectBoolean(value);
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean isValue() {
        return true;
    }

    public Object marshal(Env env, Expr expr, Class expectedClass) {
        return this.expect(env, expr.eval(env));
    }

    public Object marshal(Env env, Value value, Class expectedClass) {
        return this.expect(env, value.toValue());
    }

    public Value unmarshal(Env env, Object value) {
        return (Value)value;
    }

    protected int getMarshalingCostImpl(Value argValue) {
        return 10;
    }

    public Class getExpectedClass() {
        return Value.class;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Type {
        STRING,
        NUMERIC,
        BOOLEAN;

    }
}

