/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.marshal;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.JavaMapAdapter;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.marshal.JavaMarshal;
import com.caucho.quercus.program.JavaClassDef;
import com.caucho.util.L10N;
import java.util.Map;

public class JavaMapMarshal
extends JavaMarshal {
    private static final L10N L = new L10N(JavaMapMarshal.class);

    public JavaMapMarshal(JavaClassDef def, boolean isNotNull) {
        this(def, isNotNull, false);
    }

    public JavaMapMarshal(JavaClassDef def, boolean isNotNull, boolean isUnmarshalNullAsFalse) {
        super(def, isNotNull, isUnmarshalNullAsFalse);
    }

    public Object marshal(Env env, Value value, Class argClass) {
        if (!value.isset()) {
            if (this._isNotNull) {
                this.unexpectedNull(env, argClass);
            }
            return null;
        }
        Map<?, ?> obj = value.toJavaMap(env, argClass);
        if (obj == null) {
            if (this._isNotNull) {
                this.unexpectedNull(env, argClass);
            }
            return null;
        }
        if (!argClass.isAssignableFrom(obj.getClass())) {
            this.unexpectedType(env, value, obj.getClass(), argClass);
            return null;
        }
        return obj;
    }

    protected int getMarshalingCostImpl(Value argValue) {
        if (argValue instanceof JavaMapAdapter && this.getExpectedClass().isAssignableFrom(argValue.toJavaObject().getClass())) {
            return 0;
        }
        if (argValue.isArray()) {
            return 300;
        }
        return 400;
    }
}

