/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.marshal;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.marshal.Marshal;

public class StringMarshal
extends Marshal {
    public static final StringMarshal MARSHAL = new StringMarshal();

    public boolean isString() {
        return true;
    }

    public boolean isReadOnly() {
        return true;
    }

    public Object marshal(Env env, Expr expr, Class expectedClass) {
        return expr.evalString(env);
    }

    public Object marshal(Env env, Value value, Class expectedClass) {
        return value.toJavaString();
    }

    public Value unmarshal(Env env, Object value) {
        if (value == null) {
            return NullValue.NULL;
        }
        return env.createString((String)value);
    }

    protected int getMarshalingCostImpl(Value argValue) {
        return argValue.toStringMarshalCost();
    }

    public int getMarshalingCost(Expr expr) {
        if (expr.isString()) {
            return 0;
        }
        return 400;
    }

    public Class getExpectedClass() {
        return String.class;
    }
}

