/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.mysql;

public class MysqlColumn {
    private static final int TYPE_DECIMAL = 0;
    private static final int TYPE_TINY = 1;
    private static final int TYPE_SHORT = 2;
    private static final int TYPE_INTEGER = 3;
    private static final int TYPE_FLOAT = 4;
    private static final int TYPE_DOUBLE = 5;
    private static final int TYPE_NULL = 6;
    private static final int TYPE_TIMESTAMP = 7;
    private static final int TYPE_BIGINT = 8;
    private static final int TYPE_INT24 = 9;
    private static final int TYPE_DATE = 10;
    private static final int TYPE_TIME = 11;
    private static final int TYPE_DATETIME = 12;
    private static final int TYPE_YEAR = 13;
    private static final int TYPE_NEWDATE = 14;
    private static final int TYPE_VARCHAR = 15;
    private static final int TYPE_BIT = 16;
    private static final int TYPE_NEWDECIMAL = 246;
    private static final int TYPE_ENUM = 247;
    private static final int TYPE_SET = 248;
    private static final int TYPE_TINY_BLOB = 249;
    private static final int TYPE_MEDIUM_BLOB = 250;
    private static final int TYPE_LONG_BLOB = 251;
    private static final int TYPE_BLOB = 252;
    private static final int TYPE_VAR_STRING = 253;
    private static final int TYPE_STRING = 254;
    private static final int TYPE_GEOMETRY = 255;
    private static final int FLAG_NOT_NULL = 1;
    private static final int FLAG_PRIMARY_KEY = 2;
    private static final int FLAG_UNIQUE_KEY = 4;
    private static final int FLAG_MULTIPLE_KEY = 8;
    private static final int FLAG_BLOB = 16;
    private static final int FLAG_UNSIGNED = 32;
    private static final int FLAG_ZEROFILL = 64;
    private static final int FLAG_BINARY = 128;
    private static final int FLAG_ENUM = 256;
    private static final int FLAG_AUTO_INCREMENT = 512;
    private static final int FLAG_TIMESTAMP = 1024;
    private static final int FLAG_SET = 2048;
    private char[] _catalogBuffer = new char[32];
    private int _catalogLength;
    private String _catalog;
    private char[] _databaseBuffer = new char[32];
    private int _databaseLength;
    private String _database;
    private char[] _tableBuffer = new char[32];
    private int _tableLength;
    private String _table;
    private char[] _origTableBuffer = new char[32];
    private int _origTableLength;
    private String _origTable;
    private char[] _nameBuffer = new char[32];
    private int _nameLength;
    private String _name;
    private char[] _origNameBuffer = new char[32];
    private int _origNameLength;
    private String _origName;
    private int _charset;
    private int _length;
    private int _type;
    private int _flags;
    private int _decimals;
    private long _defaultValue;
    private int _rowOffset;
    private int _rowLength;

    char[] startCatalog(int length) {
        if (this._catalogBuffer.length < length) {
            this._catalogBuffer = new char[length];
        }
        this._catalog = null;
        this._catalogLength = length;
        return this._catalogBuffer;
    }

    String getCatalog() {
        if (this._catalog == null) {
            this._catalog = new String(this._catalogBuffer, 0, this._catalogLength);
        }
        return this._catalog;
    }

    char[] startDatabase(int length) {
        if (this._databaseBuffer.length < length) {
            this._databaseBuffer = new char[length];
        }
        this._database = null;
        this._databaseLength = length;
        return this._databaseBuffer;
    }

    String getDatabase() {
        if (this._database == null) {
            this._database = new String(this._databaseBuffer, 0, this._databaseLength);
        }
        return this._database;
    }

    char[] startTable(int length) {
        if (this._tableBuffer.length < length) {
            this._tableBuffer = new char[length];
        }
        this._table = null;
        this._tableLength = length;
        return this._tableBuffer;
    }

    String getTable() {
        if (this._table == null) {
            this._table = new String(this._tableBuffer, 0, this._tableLength);
        }
        return this._table;
    }

    char[] startOrigTable(int length) {
        if (this._origTableBuffer.length < length) {
            this._origTableBuffer = new char[length];
        }
        this._origTable = null;
        this._origTableLength = length;
        return this._origTableBuffer;
    }

    String getOrigTable() {
        if (this._origTable == null) {
            this._origTable = new String(this._origTableBuffer, 0, this._origTableLength);
        }
        return this._origTable;
    }

    char[] startName(int length) {
        if (this._nameBuffer.length < length) {
            this._nameBuffer = new char[length];
        }
        this._name = null;
        this._nameLength = length;
        return this._nameBuffer;
    }

    String getName() {
        if (this._name == null) {
            this._name = new String(this._nameBuffer, 0, this._nameLength);
        }
        return this._name;
    }

    char[] startOrigName(int length) {
        if (this._origNameBuffer.length < length) {
            this._origNameBuffer = new char[length];
        }
        this._origName = null;
        this._origNameLength = length;
        return this._origNameBuffer;
    }

    String getOrigName() {
        if (this._origName == null) {
            this._origName = new String(this._origNameBuffer, 0, this._origNameLength);
        }
        return this._origName;
    }

    public void setCharset(int charset) {
        this._charset = charset;
    }

    public int getCharset() {
        return this._charset;
    }

    public void setLength(int length) {
        this._length = length;
    }

    public int getLength() {
        return this._length;
    }

    public void setType(int type) {
        this._type = type;
    }

    public int getType() {
        return this._type;
    }

    public void setFlags(int flags) {
        this._flags = flags;
    }

    public int getFlags() {
        return this._flags;
    }

    public void setDecimals(int decimals) {
        this._decimals = decimals;
    }

    public int getDecimals() {
        return this._decimals;
    }

    public void setDefault(long value) {
        this._defaultValue = value;
    }

    public long getDefault() {
        return this._defaultValue;
    }

    public String getSchema() {
        return this.getTable();
    }

    public int getSQLType() {
        switch (this._type) {
            case 0: {
                return 3;
            }
            case 1: {
                return -6;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 6;
            }
            case 5: {
                return 8;
            }
            case 6: {
                return 0;
            }
            case 7: {
                return 93;
            }
            case 8: {
                return -5;
            }
            case 9: {
                return 4;
            }
            case 10: {
                return 91;
            }
            case 11: {
                return 92;
            }
            case 12: {
                return 93;
            }
            case 13: {
                return 91;
            }
            case 14: {
                return 91;
            }
            case 16: {
                return -7;
            }
            case 247: {
                return 2001;
            }
            case 249: {
                return 12;
            }
            case 250: {
                return 12;
            }
            case 251: {
                return 12;
            }
            case 252: {
                return 12;
            }
            case 253: {
                return 12;
            }
            case 254: {
                return 1;
            }
        }
        return 0;
    }

    public String getTypeName() {
        switch (this._type) {
            case 0: {
                return "decimal";
            }
            case 1: {
                return "tinyint";
            }
            case 2: {
                return "smallint";
            }
            case 3: {
                return "integer";
            }
            case 4: {
                return "float";
            }
            case 5: {
                return "double";
            }
            case 6: {
                return "null";
            }
            case 7: {
                return "timestamp";
            }
            case 8: {
                return "bigint";
            }
            case 9: {
                return "mediumint";
            }
            case 10: {
                return "date";
            }
            case 11: {
                return "time";
            }
            case 12: {
                return "datetime";
            }
            case 13: {
                return "year";
            }
            case 14: {
                return "newdate";
            }
            case 16: {
                return "bit";
            }
            case 247: {
                return "enum";
            }
            case 248: {
                return "set";
            }
            case 249: {
                return "tinyblob";
            }
            case 250: {
                return "mediumblob";
            }
            case 251: {
                return "longblob";
            }
            case 252: {
                return "blob";
            }
            case 253: {
                return "varchar";
            }
            case 254: {
                return "string";
            }
        }
        return "unknown(" + this._type + ")";
    }

    public int getPrecision() {
        return this.getLength();
    }

    public int getScale() {
        return this._decimals;
    }

    public boolean isNotNull() {
        return (this._flags & 1) != 0;
    }

    public boolean isPrimaryKey() {
        return (this._flags & 2) != 0;
    }

    public boolean isUniqueKey() {
        return (this._flags & 4) != 0;
    }

    public boolean isMultipleKey() {
        return (this._flags & 8) != 0;
    }

    public boolean isBlob() {
        return (this._flags & 0x10) != 0;
    }

    public boolean isUnsigned() {
        return (this._flags & 0x20) != 0;
    }

    public boolean isZeroFill() {
        return (this._flags & 0x40) != 0;
    }

    public boolean isBinary() {
        return (this._flags & 0x80) != 0;
    }

    public boolean isEnum() {
        return (this._flags & 0x100) != 0;
    }

    public boolean isAutoIncrement() {
        return (this._flags & 0x200) != 0;
    }

    public boolean isTimestamp() {
        return (this._flags & 0x400) != 0;
    }

    public boolean isSet() {
        return (this._flags & 0x800) != 0;
    }

    public int getRowOffset() {
        return this._rowOffset;
    }

    public void setRowOffset(int offset) {
        this._rowOffset = offset;
    }

    public int getRowLength() {
        return this._rowLength;
    }

    public void setRowLength(int length) {
        this._rowLength = length;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

