/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.statement;

import com.caucho.quercus.Location;
import com.caucho.quercus.QuercusExecutionException;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import java.util.IdentityHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Statement {
    private static final Logger log = Logger.getLogger(Statement.class.getName());
    public static final int FALL_THROUGH = 0;
    public static final int BREAK_FALL_THROUGH = 1;
    public static final int RETURN = 2;
    private final Location _location;
    private Statement _parent;
    private String _loopLabel;

    protected Statement() {
        this._location = Location.UNKNOWN;
    }

    protected Statement(Location location) {
        this._location = location;
    }

    public final Location getLocation() {
        return this._location;
    }

    public boolean isLoop() {
        return false;
    }

    public final Statement getParent() {
        return this._parent;
    }

    public final void setParent(Statement parent) {
        this._parent = parent;
    }

    public abstract Value execute(Env var1);

    public int fallThrough() {
        return 0;
    }

    protected final void rethrow(Throwable t) throws Throwable {
        this.rethrow(t, Throwable.class);
    }

    protected final <E extends Throwable> void rethrow(Throwable t, Class<E> cl) throws E {
        StackTraceElement[] existingElements;
        int len;
        StackTraceElement lastElement;
        Throwable cause;
        Throwable typedT;
        if (!cl.isAssignableFrom(t.getClass())) {
            try {
                typedT = (Throwable)cl.newInstance();
                typedT.initCause(t);
            }
            catch (InstantiationException e) {
                log.log(Level.WARNING, t.toString(), t);
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                log.log(Level.WARNING, t.toString(), t);
                throw new RuntimeException(e);
            }
        } else {
            typedT = t;
        }
        Throwable rootCause = t;
        IdentityHashMap<Throwable, Boolean> causes = new IdentityHashMap<Throwable, Boolean>();
        causes.put(rootCause, Boolean.TRUE);
        while (rootCause.getCause() != null && !causes.containsKey(cause = rootCause.getCause())) {
            causes.put(cause, Boolean.TRUE);
            rootCause = cause;
        }
        if (!(rootCause instanceof QuercusExecutionException)) {
            StackTraceElement rootCauseElement;
            StackTraceElement quercusExElement;
            int rootCauseIndex;
            String rootCauseName = rootCause.getClass().getName();
            String rootCauseMessage = rootCause.getMessage();
            StringBuilder quercusExMessage = new StringBuilder();
            quercusExMessage.append(rootCauseName);
            if (rootCauseMessage != null && rootCauseMessage.length() > 0) {
                quercusExMessage.append(" ");
                quercusExMessage.append(rootCauseMessage);
            }
            QuercusExecutionException quercusEx = new QuercusExecutionException(quercusExMessage.toString());
            StackTraceElement[] quercusExStackTrace = quercusEx.getStackTrace();
            StackTraceElement[] rootCauseStackTrace = rootCause.getStackTrace();
            int quercusExIndex = quercusExStackTrace.length - 1;
            for (rootCauseIndex = rootCauseStackTrace.length - 1; rootCauseIndex >= 0 && quercusExIndex >= 0 && (quercusExElement = quercusExStackTrace[quercusExIndex]).equals(rootCauseElement = rootCauseStackTrace[rootCauseIndex]); --rootCauseIndex, --quercusExIndex) {
            }
            int len2 = rootCauseIndex + 1;
            StackTraceElement[] trimmedElements = new StackTraceElement[len2];
            System.arraycopy(rootCauseStackTrace, 0, trimmedElements, 0, len2);
            quercusEx.setStackTrace(trimmedElements);
            try {
                rootCause.initCause(quercusEx);
                rootCause = quercusEx;
            }
            catch (IllegalStateException ex) {
                log.log(Level.FINE, ex.toString(), ex);
            }
        }
        String className = this._location.getClassName();
        String functionName = this._location.getFunctionName();
        String fileName = this._location.getFileName();
        int lineNumber = this._location.getLineNumber();
        if (className == null) {
            className = "";
        }
        if (functionName == null) {
            functionName = "";
        }
        if ((lastElement = (len = (existingElements = rootCause.getStackTrace()).length) > 1 ? existingElements[len - 1] : null) != null && functionName.equals(lastElement.getMethodName()) && className.equals(lastElement.getClassName())) {
            throw typedT;
        }
        StackTraceElement[] elements = new StackTraceElement[len + 1];
        System.arraycopy(existingElements, 0, elements, 0, len);
        elements[len] = new StackTraceElement(className, functionName, fileName, lineNumber);
        rootCause.setStackTrace(elements);
        throw typedT;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

