/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.relaxng.pattern;

import com.caucho.relaxng.RelaxException;
import com.caucho.relaxng.pattern.ChoicePattern;
import com.caucho.relaxng.pattern.GrammarPattern;
import com.caucho.relaxng.pattern.Pattern;
import com.caucho.relaxng.program.GroupItem;
import com.caucho.relaxng.program.Item;
import com.caucho.util.CharBuffer;
import java.util.ArrayList;

public class GroupPattern
extends Pattern {
    private ArrayList<Pattern> _patterns = new ArrayList();

    public String getTagName() {
        return "group";
    }

    public int getSize() {
        return this._patterns.size();
    }

    public Pattern getChild(int i) {
        return this._patterns.get(i);
    }

    public void addChild(Pattern child) throws RelaxException {
        child.setParent(this);
        child.setElementName(this.getElementName());
        if (child instanceof GroupPattern) {
            GroupPattern list = (GroupPattern)child;
            for (int i = 0; i < list.getSize(); ++i) {
                this.addChild(list.getChild(i));
            }
            return;
        }
        this._patterns.add(child);
        boolean hasData = false;
        boolean hasElement = false;
        for (int i = 0; i < this._patterns.size(); ++i) {
            if (this._patterns.get(i).hasData()) {
                hasData = true;
                continue;
            }
            if (!this._patterns.get(i).hasElement()) continue;
            hasElement = true;
        }
        if (hasData && hasElement) {
            throw new RelaxException(L.l("<data> may not be in a <group>.  Use <text> instead."));
        }
    }

    public Item createItem(GrammarPattern grammar) throws RelaxException {
        if (this._patterns.size() == 0) {
            return null;
        }
        Item tail = this._patterns.get(this._patterns.size() - 1).createItem(grammar);
        for (int i = this._patterns.size() - 2; i >= 0; --i) {
            tail = GroupItem.create(this._patterns.get(i).createItem(grammar), tail);
        }
        return tail;
    }

    public String toProduction() {
        if (this._patterns.size() == 0) {
            return "notAllowed";
        }
        CharBuffer cb = new CharBuffer();
        for (int i = 0; i < this._patterns.size(); ++i) {
            Pattern pattern;
            if (i != 0) {
                cb.append(", ");
            }
            if ((pattern = this._patterns.get(i)) instanceof ChoicePattern && !((ChoicePattern)pattern).hasEmpty()) {
                cb.append("(" + this._patterns.get(i).toProduction() + ")");
                continue;
            }
            cb.append(this._patterns.get(i).toProduction());
        }
        return cb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GroupPattern)) {
            return false;
        }
        GroupPattern group = (GroupPattern)o;
        if (this._patterns.size() != group._patterns.size()) {
            return false;
        }
        for (int i = 0; i < this._patterns.size(); ++i) {
            if (this._patterns.get(i).equals(group._patterns.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "GroupPattern" + this._patterns;
    }
}

