/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.relaxng.program;

import com.caucho.relaxng.RelaxException;
import com.caucho.relaxng.program.ChoiceItem;
import com.caucho.relaxng.program.EmptyItem;
import com.caucho.relaxng.program.InElementItem;
import com.caucho.relaxng.program.Item;
import com.caucho.relaxng.program.ZeroOrMoreItem;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.xml.QName;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupItem
extends Item {
    protected static final L10N L = new L10N(GroupItem.class);
    private Item _first;
    private Item _second;

    private GroupItem(Item first, Item second) {
        this._first = first;
        this._second = second;
    }

    public static Item create(Item first, Item second) {
        if (first == null || second == null) {
            return null;
        }
        if (first instanceof EmptyItem) {
            return second;
        }
        if (second instanceof EmptyItem) {
            return first;
        }
        if (first instanceof GroupItem) {
            GroupItem firstSeq = (GroupItem)first;
            return GroupItem.create(firstSeq.getFirst(), GroupItem.create(firstSeq.getSecond(), second));
        }
        if (first instanceof InElementItem) {
            InElementItem firstElt = (InElementItem)first;
            return InElementItem.create(firstElt.getFirst(), GroupItem.create(firstElt.getSecond(), second));
        }
        return new GroupItem(first, second);
    }

    Item getFirst() {
        return this._first;
    }

    Item getSecond() {
        return this._second;
    }

    @Override
    public void firstSet(HashSet<QName> set) {
        this._first.firstSet(set);
        if (this._first.allowEmpty()) {
            this._second.firstSet(set);
        }
    }

    @Override
    public void requiredFirstSet(HashSet<QName> set) {
        if (!this._first.allowEmpty()) {
            this._first.requiredFirstSet(set);
        } else {
            this._second.requiredFirstSet(set);
        }
    }

    @Override
    public Iterator<Item> getItemsIterator() {
        if (this._first == null && this._second == null) {
            return this.emptyItemIterator();
        }
        return new Iterator<Item>(){
            private int _cnt;

            @Override
            public boolean hasNext() {
                if (this._cnt == 0) {
                    return GroupItem.this._first != null || GroupItem.this._second != null;
                }
                if (this._cnt == 1) {
                    return GroupItem.this._first != null && GroupItem.this._second != null;
                }
                return false;
            }

            @Override
            public Item next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this._cnt++ == 0) {
                    return GroupItem.this._first != null ? GroupItem.this._first : GroupItem.this._second;
                }
                return GroupItem.this._second;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Item startElement(QName name) throws RelaxException {
        Item nextHead = this._first.startElement(name);
        Item tail = GroupItem.create(nextHead, this._second);
        if (this._first.allowEmpty()) {
            return ChoiceItem.create(tail, this._second.startElement(name));
        }
        return tail;
    }

    @Override
    public Item text(CharSequence string) throws RelaxException {
        Item nextHead = this._first.text(string);
        Item tail = GroupItem.create(nextHead, this._second);
        if (this._first.allowEmpty()) {
            return ChoiceItem.create(tail, this._second.text(string));
        }
        return tail;
    }

    @Override
    public void attributeSet(HashSet<QName> set) {
        this._first.attributeSet(set);
        this._second.attributeSet(set);
    }

    @Override
    public boolean allowAttribute(QName name, String value) throws RelaxException {
        return this._first.allowAttribute(name, value) || this._second.allowAttribute(name, value);
    }

    @Override
    public Item setAttribute(QName name, String value) throws RelaxException {
        Item first = this._first.setAttribute(name, value);
        Item second = this._second.setAttribute(name, value);
        if (first == this._first && second == this._second) {
            return this;
        }
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        return GroupItem.create(first, second);
    }

    @Override
    public Item attributeEnd() {
        Item first = this._first.attributeEnd();
        Item second = this._second.attributeEnd();
        if (first == null || second == null) {
            return null;
        }
        if (first == this._first && second == this._second) {
            return this;
        }
        return GroupItem.create(first, second);
    }

    @Override
    public boolean allowEmpty() {
        return this._first.allowEmpty() && this._second.allowEmpty();
    }

    @Override
    public boolean allowsElement(QName name) {
        return this._first.allowsElement(name) || this._second.allowsElement(name);
    }

    @Override
    public String toSyntaxDescription(int depth) {
        if (this._second instanceof EmptyItem) {
            return this._first.toSyntaxDescription(depth);
        }
        ArrayList<Item> items = new ArrayList<Item>();
        Item item = this;
        while (item instanceof GroupItem) {
            GroupItem groupItem = item;
            items.add(groupItem._first);
            item = groupItem._second;
        }
        if (item != null && !(item instanceof EmptyItem)) {
            items.add(item);
        }
        CharBuffer cb = CharBuffer.allocate();
        cb.append('(');
        boolean isSimple = true;
        for (int i = 0; i < items.size(); ++i) {
            ZeroOrMoreItem starItem;
            Item next;
            item = (Item)items.get(i);
            if (i == 0) {
                cb.append(item.toSyntaxDescription(depth + 1));
                isSimple = item.isSimpleSyntax();
            } else {
                isSimple = this.addSyntaxItem(cb, item, depth, isSimple);
            }
            if (i + 1 >= items.size() || !((next = (Item)items.get(i + 1)) instanceof ZeroOrMoreItem) || !(starItem = (ZeroOrMoreItem)next).getItem().equals(item)) continue;
            cb.append("+");
            if (++i != 1 || i != items.size() - 1) continue;
            cb.delete(0, 1);
            return cb.close();
        }
        cb.append(')');
        return cb.close();
    }

    private boolean addSyntaxItem(CharBuffer cb, Item item, int depth, boolean isSimple) {
        if (!item.isSimpleSyntax()) {
            isSimple = false;
        }
        if (isSimple) {
            cb.append(", ");
        } else {
            cb.append(",");
            this.addSyntaxNewline(cb, depth + 1);
        }
        cb.append(item.toSyntaxDescription(depth + 1));
        return isSimple;
    }

    @Override
    protected boolean isSimpleSyntax() {
        return this._second instanceof EmptyItem && this._first.isSimpleSyntax();
    }

    public int hashCode() {
        return this._first.hashCode() * 65521 + this._second.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof GroupItem)) {
            return false;
        }
        GroupItem seq = (GroupItem)o;
        return this._first.equals(seq._first) && this._second.equals(seq._second);
    }

    public String toString() {
        return "GroupItem[" + this._first + ", " + this._second + "]";
    }
}

