/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.remote.websocket;

import com.caucho.env.actor.AbstractActorProcessor;
import com.caucho.env.actor.ValueActorQueue;
import com.caucho.websocket.WebSocketContext;
import com.caucho.websocket.WebSocketEncoder;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebSocketBlockingQueue<T>
implements BlockingQueue<T> {
    private final WebSocketContext _ws;
    private final WebSocketEncoder<T> _encoder;
    private final ValueActorQueue<T> _queue;

    public WebSocketBlockingQueue(WebSocketContext ws, WebSocketEncoder<T> encoder, int capacity) {
        if (ws == null) {
            throw new NullPointerException();
        }
        if (encoder == null) {
            throw new NullPointerException();
        }
        this._ws = ws;
        this._encoder = encoder;
        this._queue = new ValueActorQueue(capacity, new WebSocketWriterActor<T>(this._ws, this._encoder));
    }

    @Override
    public boolean isEmpty() {
        return this._queue.isEmpty();
    }

    @Override
    public int size() {
        return this._queue.getSize();
    }

    @Override
    public int remainingCapacity() {
        return 0;
    }

    @Override
    public boolean offer(T value) {
        return this._queue.offer(value, false);
    }

    @Override
    public boolean offer(T value, long timeout, TimeUnit unit) throws InterruptedException {
        return this._queue.offer(value, true);
    }

    @Override
    public boolean add(T value) {
        return this._queue.offer(value, true);
    }

    @Override
    public void put(T value) throws InterruptedException {
        this._queue.offer(value, true);
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        for (T value : collection) {
            if (this.add(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public T element() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public T peek() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public T poll() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public T remove() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public Iterator<T> iterator() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public <T> T[] toArray(T[] arg0) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public boolean contains(Object arg0) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public int drainTo(Collection<? super T> arg0) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public int drainTo(Collection<? super T> arg0, int arg1) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public T poll(long arg0, TimeUnit arg1) throws InterruptedException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public boolean remove(Object arg0) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public T take() throws InterruptedException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class WebSocketWriterActor<T>
    extends AbstractActorProcessor<T> {
        private final WebSocketContext _ws;
        private final WebSocketEncoder<T> _encoder;

        WebSocketWriterActor(WebSocketContext ws, WebSocketEncoder<T> encoder) {
            this._ws = ws;
            this._encoder = encoder;
        }

        @Override
        public String getThreadName() {
            return this.toString();
        }

        @Override
        public void process(T value) throws Exception {
            this._encoder.encode(this._ws, value);
        }

        @Override
        public void onProcessComplete() throws Exception {
            this._encoder.flush(this._ws);
        }
    }
}

