/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.security;

import com.caucho.security.AbstractLogin;
import com.caucho.security.Authenticator;
import com.caucho.security.BasicPrincipal;
import com.caucho.security.PasswordCredentials;
import com.caucho.util.Base64;
import java.io.IOException;
import java.security.Principal;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BasicLogin
extends AbstractLogin {
    private static final Logger log = Logger.getLogger(BasicLogin.class.getName());
    private String _realm;

    public void setRealmName(String realm) {
        this._realm = realm;
    }

    public String getRealmName() {
        return this._realm;
    }

    public String getAuthType() {
        return "Basic";
    }

    public boolean isPasswordBased() {
        return true;
    }

    public boolean isLoginUsedForRequest(HttpServletRequest request) {
        return request.getHeader("authorization") != null;
    }

    protected Principal getUserPrincipalImpl(HttpServletRequest request) {
        String authorization = request.getHeader("authorization");
        String userName = (String)request.getAttribute("caucho.user.name");
        char[] password = null;
        if (authorization != null) {
            int i = authorization.indexOf(32);
            if (i <= 0) {
                return null;
            }
            String decoded = Base64.decode(authorization.substring(i + 1));
            int index = decoded.indexOf(58);
            if (index < 0) {
                return null;
            }
            userName = decoded.substring(0, index);
            password = decoded.substring(index + 1).toCharArray();
        } else if (userName != null) {
            String value = (String)request.getAttribute("caucho.password");
            if (value != null) {
                password = value.toCharArray();
            }
        } else {
            return null;
        }
        Authenticator auth = this.getAuthenticator();
        BasicPrincipal user = new BasicPrincipal(userName);
        PasswordCredentials credentials = new PasswordCredentials(password);
        Principal principal = auth.authenticate(user, credentials, request);
        if (log.isLoggable(Level.FINE)) {
            log.fine("basic: " + user + " -> " + principal + " (" + auth + ")");
        }
        return principal;
    }

    protected boolean isSavedUserValid(HttpServletRequest request, Principal savedUser) {
        String value = request.getHeader("authorization");
        if (value == null) {
            return true;
        }
        int i = value.indexOf(32);
        if (i <= 0) {
            return true;
        }
        String decoded = Base64.decode(value.substring(i + 1));
        int index = decoded.indexOf(58);
        if (index < 0) {
            return true;
        }
        String userName = decoded.substring(0, index);
        return savedUser.getName().equals(userName);
    }

    protected void loginChallenge(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String realm = this.getRealmName();
        if (realm == null) {
            realm = "resin";
        }
        response.setHeader("WWW-Authenticate", "Basic realm=\"" + realm + "\"");
        response.sendError(401);
    }
}

