/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.security;

import com.caucho.util.Base64;
import java.security.MessageDigest;
import java.security.Principal;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Logger;

public abstract class DigestBuilder {
    private static final Logger log = Logger.getLogger(DigestBuilder.class.getName());
    private static final HashMap<String, DigestBuilder> _digestBuilderMap = new HashMap();

    public abstract char[] buildDigest(String var1, Principal var2, char[] var3, char[] var4) throws Exception;

    public static char[] getDigest(Principal user, String algorithm, char[] testPassword, char[] systemDigest) {
        char[] digest;
        String code = DigestBuilder.getCode(systemDigest, algorithm);
        DigestBuilder builder = DigestBuilder.getBuilder(code);
        if (builder == null) {
            return null;
        }
        if (builder != null) {
            try {
                digest = builder.buildDigest(code, user, testPassword, systemDigest);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            log.warning("password " + code + " is an unsupportedtype for " + " " + user);
            digest = testPassword;
        }
        return digest;
    }

    public static String getAlgorithm(char[] systemDigest) {
        String code = DigestBuilder.getCode(systemDigest);
        if (code == null) {
            return null;
        }
        DigestBuilder builder = DigestBuilder.getBuilder(code);
        if (builder != null) {
            return builder.buildAlgorithm(code, systemDigest);
        }
        return null;
    }

    protected String buildAlgorithm(String code, char[] systemDigest) {
        return code;
    }

    private static DigestBuilder getBuilder(String code) {
        if (code != null) {
            return _digestBuilderMap.get(code.toLowerCase(Locale.ENGLISH));
        }
        return null;
    }

    private static String getCode(char[] systemDigest, String algorithm) {
        String code = DigestBuilder.getCode(systemDigest);
        if (code != null) {
            return code;
        }
        if (algorithm != null) {
            return DigestBuilder.getCode(algorithm.toCharArray());
        }
        return null;
    }

    private static String getCode(char[] systemDigest) {
        int len = systemDigest.length;
        if (len == 0 || systemDigest[0] != '{') {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (int i = 1; i < len && systemDigest[i] != '}'; ++i) {
            sb.append(systemDigest[i]);
        }
        sb.append("}");
        return sb.toString();
    }

    static {
        _digestBuilderMap.put("{plain}", new NoneDigestBuilder());
        _digestBuilderMap.put("{sha}", new ShaDigestBuilder());
        _digestBuilderMap.put("{ssha}", new SaltShaDigestBuilder());
        _digestBuilderMap.put("{md5}", new Md5DigestBuilder());
        _digestBuilderMap.put("{md5-base64}", new ResinMd5Base64DigestBuilder());
    }

    static class ResinMd5Base64DigestBuilder
    extends DigestBuilder {
        ResinMd5Base64DigestBuilder() {
        }

        public char[] buildDigest(String code, Principal user, char[] password, char[] systemDigest) throws Exception {
            int i;
            StringBuilder sb = new StringBuilder();
            sb.append(code);
            MessageDigest md = MessageDigest.getInstance("md5");
            String uid = user.getName();
            for (int i2 = 0; i2 < uid.length(); ++i2) {
                md.update((byte)uid.charAt(i2));
            }
            String realm = "resin";
            md.update((byte)58);
            for (i = 0; i < realm.length(); ++i) {
                md.update((byte)realm.charAt(i));
            }
            md.update((byte)58);
            for (i = 0; i < password.length; ++i) {
                md.update((byte)password[i]);
            }
            byte[] mdDigest = md.digest();
            Base64.encode(sb, mdDigest, 0, mdDigest.length);
            char[] digest = new char[sb.length()];
            sb.getChars(0, sb.length(), digest, 0);
            return digest;
        }
    }

    static class Md5DigestBuilder
    extends DigestBuilder {
        Md5DigestBuilder() {
        }

        public char[] buildDigest(String code, Principal user, char[] password, char[] systemDigest) throws Exception {
            StringBuilder sb = new StringBuilder();
            sb.append(code);
            MessageDigest md = MessageDigest.getInstance("md5");
            for (int i = 0; i < password.length; ++i) {
                md.update((byte)password[i]);
            }
            byte[] mdDigest = md.digest();
            Base64.encode(sb, mdDigest, 0, mdDigest.length);
            char[] digest = new char[sb.length()];
            sb.getChars(0, sb.length(), digest, 0);
            return digest;
        }
    }

    static class SaltShaDigestBuilder
    extends DigestBuilder {
        SaltShaDigestBuilder() {
        }

        public String buildAlgorithm(String code, char[] systemDigest) {
            byte[] decodedBytes = this.decodeBytes(code, systemDigest);
            int saltOffset = 20;
            for (int i = 0; i < saltOffset; ++i) {
                decodedBytes[i] = 0;
            }
            return code + Base64.encode(decodedBytes);
        }

        public char[] buildDigest(String code, Principal user, char[] password, char[] systemDigest) throws Exception {
            int baseLength;
            StringBuilder sb = new StringBuilder();
            sb.append(code);
            byte[] decodedBytes = this.decodeBytes(code, systemDigest);
            byte[] mdDigest = new byte[decodedBytes.length];
            MessageDigest md = MessageDigest.getInstance("sha1");
            for (int i = 0; i < password.length; ++i) {
                md.update((byte)password[i]);
            }
            for (int i = baseLength = 20; i < decodedBytes.length; ++i) {
                md.update(decodedBytes[i]);
                mdDigest[i] = decodedBytes[i];
            }
            md.digest(mdDigest, 0, baseLength);
            Base64.encode(sb, mdDigest, 0, mdDigest.length);
            char[] digest = new char[sb.length()];
            sb.getChars(0, sb.length(), digest, 0);
            return digest;
        }

        private byte[] decodeBytes(String code, char[] systemDigest) {
            int offset = code.length();
            String systemBytes = new String(systemDigest, offset, systemDigest.length - offset);
            byte[] decodedBytes = Base64.decodeToByteArray(systemBytes);
            return decodedBytes;
        }
    }

    static class ShaDigestBuilder
    extends DigestBuilder {
        ShaDigestBuilder() {
        }

        public char[] buildDigest(String code, Principal user, char[] password, char[] systemDigest) throws Exception {
            StringBuilder sb = new StringBuilder();
            sb.append(code);
            MessageDigest md = MessageDigest.getInstance("sha1");
            for (int i = 0; i < password.length; ++i) {
                md.update((byte)password[i]);
            }
            byte[] mdDigest = md.digest();
            Base64.encode(sb, mdDigest, 0, mdDigest.length);
            char[] digest = new char[sb.length()];
            sb.getChars(0, sb.length(), digest, 0);
            return digest;
        }
    }

    static class NoneDigestBuilder
    extends DigestBuilder {
        NoneDigestBuilder() {
        }

        public char[] buildDigest(String code, Principal user, char[] password, char[] systemDigest) {
            char[] digest = new char[code.length() + password.length];
            code.getChars(0, code.length(), digest, 0);
            System.arraycopy(password, 0, digest, code.length(), password.length);
            return digest;
        }
    }
}

