/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.security;

import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.security.SecurityException;
import com.caucho.util.L10N;
import com.caucho.vfs.TempOutputStream;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

public class SelfEncryptedCookie
implements Serializable {
    private static final long serialVersionUID = 4678288478579787074L;
    private static final L10N L = new L10N(SelfEncryptedCookie.class);
    private final String _cookie;
    private final long _createTime;

    private SelfEncryptedCookie() {
        this._cookie = null;
        this._createTime = 0L;
    }

    public SelfEncryptedCookie(String cookie, long createTime) {
        this._cookie = cookie;
        this._createTime = createTime;
    }

    public String getCookie() {
        return this._cookie;
    }

    public long getCreateTime() {
        return this._createTime;
    }

    public static byte[] encrypt(String cookie, long createTime) {
        try {
            Cipher cipher = SelfEncryptedCookie.initCipher(cookie, 1);
            SelfEncryptedCookie cookieObj = new SelfEncryptedCookie(cookie, createTime);
            TempOutputStream tos = new TempOutputStream();
            Hessian2Output hOut = new Hessian2Output(tos);
            hOut.writeObject(cookieObj);
            hOut.close();
            TempOutputStream cipherOut = new TempOutputStream();
            CipherOutputStream cOut = new CipherOutputStream(cipherOut, cipher);
            tos.writeToStream(cOut);
            tos.destroy();
            cOut.close();
            byte[] encryptedData = cipherOut.toByteArray();
            cipherOut.destroy();
            return encryptedData;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static SelfEncryptedCookie decrypt(String cookie, byte[] encData) {
        try {
            Cipher cipher = SelfEncryptedCookie.initCipher(cookie, 2);
            ByteArrayInputStream is = new ByteArrayInputStream(encData);
            CipherInputStream cIn = new CipherInputStream(is, cipher);
            Hessian2Input in = new Hessian2Input(cIn);
            Object obj = in.readObject();
            if (!(obj instanceof SelfEncryptedCookie)) {
                throw new SecurityException(L.l("SelfEncryptedCookie[] is invalid because it does not correctly decrypt"));
            }
            SelfEncryptedCookie cookieObj = (SelfEncryptedCookie)obj;
            in.close();
            cIn.close();
            is.close();
            return cookieObj;
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SecurityException(L.l("SelfEncryptedCookie[] does not correctly decrypt."), e);
        }
    }

    private static Cipher initCipher(String cookie, int mode) throws NoSuchAlgorithmException, InvalidKeyException, NoSuchPaddingException {
        Cipher cipher = Cipher.getInstance("AES");
        byte[] keyBytes = new byte[cipher.getBlockSize()];
        for (int i = 0; i < cookie.length() && i < keyBytes.length; ++i) {
            keyBytes[i] = (byte)cookie.charAt(i);
        }
        SecretKeySpec keySpec = new SecretKeySpec(keyBytes, "AES");
        cipher.init(mode, keySpec);
        return cipher;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

