/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.dispatch;

import com.caucho.server.dispatch.FilterChainBuilder;
import com.caucho.server.dispatch.FilterConfigImpl;
import com.caucho.server.dispatch.FilterFilterChain;
import com.caucho.server.dispatch.FilterManager;
import com.caucho.server.dispatch.FilterMapping;
import com.caucho.server.dispatch.Invocation;
import com.caucho.server.dispatch.ServletConfigException;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

public class FilterMapper {
    private static final Logger log = Logger.getLogger(FilterMapper.class.getName());
    private static final L10N L = new L10N(FilterMapper.class);
    private ServletContext _servletContext;
    private int _unique;
    private FilterManager _filterManager;
    private ArrayList<FilterMapping> _filterMap = new ArrayList();
    private ArrayList<FilterChainBuilder> _topFilters = new ArrayList();
    private ArrayList<FilterChainBuilder> _bottomFilters = new ArrayList();

    public void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
    }

    public ServletContext getServletContext() {
        return this._servletContext;
    }

    public FilterManager getFilterManager() {
        return this._filterManager;
    }

    public void setFilterManager(FilterManager manager) {
        this._filterManager = manager;
    }

    public void addFilterMapping(FilterMapping mapping) throws ServletException {
        try {
            String filterName = mapping.getFilterName();
            if (filterName == null) {
                filterName = mapping.getFilterClassName();
            }
            if (mapping.getFilterClassName() != null && this._filterManager.getFilter(filterName) == null) {
                this._filterManager.addFilter(mapping);
            }
            if (this._filterManager.getFilter(filterName) == null) {
                throw new ServletConfigException(L.l("'{0}' is an unknown filter-name.  filter-mapping requires that the named filter be defined in a <filter> configuration before the <filter-mapping>.", (Object)filterName));
            }
            this._filterMap.add(mapping);
            log.fine("filter-mapping " + mapping + " -> " + filterName);
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException(e);
        }
    }

    public void addTopFilter(FilterChainBuilder filterBuilder) {
        this._topFilters.add(filterBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilterChain buildDispatchChain(Invocation invocation, FilterChain chain) throws ServletException {
        FilterConfigImpl config;
        Filter filter;
        String filterName;
        FilterMapping map;
        int i;
        ArrayList<FilterMapping> arrayList = this._filterMap;
        synchronized (arrayList) {
            for (i = this._filterMap.size() - 1; i >= 0; --i) {
                map = this._filterMap.get(i);
                if (!map.isMatch(invocation.getServletName())) continue;
                filterName = map.getFilterName();
                filter = this._filterManager.createFilter(filterName);
                config = this._filterManager.getFilter(filterName);
                if (!config.isAsyncSupported()) {
                    invocation.clearAsyncSupported();
                }
                chain = this.addFilter(chain, filter);
            }
        }
        arrayList = this._filterMap;
        synchronized (arrayList) {
            for (i = this._filterMap.size() - 1; i >= 0; --i) {
                map = this._filterMap.get(i);
                if (!map.isMatch(invocation)) continue;
                filterName = map.getFilterName();
                filter = this._filterManager.createFilter(filterName);
                config = this._filterManager.getFilter(filterName);
                if (!config.isAsyncSupported()) {
                    invocation.clearAsyncSupported();
                }
                chain = this.addFilter(chain, filter);
            }
        }
        for (int i2 = 0; i2 < this._topFilters.size(); ++i2) {
            FilterChainBuilder filterBuilder = this._topFilters.get(i2);
            chain = filterBuilder.build(chain, invocation);
        }
        invocation.setFilterChain(chain);
        return chain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilterChain buildFilterChain(FilterChain chain, String servletName) throws ServletException {
        ArrayList<FilterMapping> arrayList = this._filterMap;
        synchronized (arrayList) {
            for (int i = this._filterMap.size() - 1; i >= 0; --i) {
                FilterMapping map = this._filterMap.get(i);
                if (!map.isMatch(servletName)) continue;
                String filterName = map.getFilterName();
                Filter filter = this._filterManager.createFilter(filterName);
                chain = this.addFilter(chain, filter);
            }
        }
        return chain;
    }

    private FilterChain addFilter(FilterChain chain, Filter filter) {
        return new FilterFilterChain(chain, filter);
    }
}

