/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.distcache;

import com.caucho.db.index.SqlIndexAlreadyExistsException;
import com.caucho.server.distcache.MnodeOrphanListener;
import com.caucho.server.distcache.MnodeStore;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.ConcurrentArrayList;
import com.caucho.util.FreeList;
import com.caucho.util.IoUtil;
import com.caucho.util.JdbcUtil;
import com.caucho.util.L10N;
import com.caucho.vfs.StreamSource;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class DataStore {
    private static final L10N L = new L10N(DataStore.class);
    private static final Logger log = Logger.getLogger(DataStore.class.getName());
    private FreeList<DataConnection> _freeConn = new FreeList(32);
    private final String _tableName;
    private final String _mnodeTableName;
    private long _expireTimeout = 3600000L;
    private DataSource _dataSource;
    private final String _insertQuery;
    private final String _loadQuery;
    private final String _selectOrphanQuery;
    private final String _deleteQuery;
    private final String _validateQuery;
    private final String _countQuery;
    private final ConcurrentArrayList<MnodeOrphanListener> _orphanListeners = new ConcurrentArrayList<MnodeOrphanListener>(MnodeOrphanListener.class);
    private final AtomicLong _entryCount = new AtomicLong();
    private Alarm _alarm;

    public DataStore(String serverName, MnodeStore mnodeStore) throws Exception {
        this._dataSource = mnodeStore.getDataSource();
        this._mnodeTableName = mnodeStore.getTableName();
        this._tableName = "data";
        if (this._tableName == null) {
            throw new NullPointerException();
        }
        this._loadQuery = "SELECT data FROM " + this._tableName + " WHERE id=?";
        this._insertQuery = "INSERT into " + this._tableName + " (data) " + "VALUES(?)";
        this._selectOrphanQuery = "SELECT m.value_data_id, d.id FROM " + this._mnodeTableName + " AS m" + " LEFT JOIN " + this._tableName + " AS d" + " ON(m.value_data_id=d.id)";
        this._deleteQuery = "DELETE FROM " + this._tableName + " WHERE id = ?";
        this._validateQuery = "VALIDATE " + this._tableName;
        this._countQuery = "SELECT count(*) FROM " + this._tableName;
    }

    DataSource getDataSource() {
        return this._dataSource;
    }

    protected void init() throws Exception {
        this.initDatabase();
        long count = this.getCountImpl();
        if (count > 0L) {
            this._entryCount.set(count);
        }
        this._alarm = new Alarm(new DeleteAlarm());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void initDatabase() throws Exception {
        conn = this._dataSource.getConnection();
        try {
            stmt = conn.createStatement();
            isOld = false;
            try {
                sql = "SELECT expire_time FROM " + this._tableName + " WHERE 1=0";
                rs = stmt.executeQuery(sql);
                rs.next();
                rs.close();
                isOld = true;
            }
            catch (Exception e) {
                DataStore.log.log(Level.ALL, e.toString(), e);
                DataStore.log.finest(this + " " + e.toString());
            }
            if (isOld) ** GOTO lbl28
            try {
                sql = "SELECT id, data FROM " + this._tableName + " WHERE 1=0";
                rs = stmt.executeQuery(sql);
                rs.next();
                rs.close();
                return;
            }
            catch (Exception e) {
                DataStore.log.log(Level.FINEST, e.toString(), e);
                DataStore.log.finer(this + " " + e.toString());
lbl28:
                // 2 sources

                try {
                    stmt.executeQuery("DROP TABLE " + this._tableName);
                }
                catch (Exception e) {
                    DataStore.log.log(Level.FINEST, e.toString(), e);
                }
                sql = "CREATE TABLE " + this._tableName + " (\n" + "  id IDENTITY,\n" + "  data BLOB)";
                DataStore.log.fine(sql);
                stmt.executeUpdate(sql);
            }
        }
        finally {
            conn.close();
        }
    }

    public void addOrphanListener(MnodeOrphanListener listener) {
        this._orphanListeners.add(listener);
    }

    public void removeOrphanListener(MnodeOrphanListener listener) {
        this._orphanListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(long id, WriteStream os) {
        try {
            Blob blob = this.loadBlob(id);
            if (blob != null) {
                InputStream is = blob.getBinaryStream();
                if (is == null) {
                    return false;
                }
                try {
                    os.writeStream(is);
                }
                finally {
                    is.close();
                }
                return true;
            }
            if (log.isLoggable(Level.FINER)) {
                log.finer(this + " no data loaded for " + Long.toHexString(id));
            }
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Blob loadBlob(long id) {
        block11: {
            DataConnection conn = null;
            ResultSet rs = null;
            try {
                conn = this.getConnection();
                PreparedStatement pstmt = conn.prepareLoad();
                pstmt.setLong(1, id);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    Blob blob;
                    Blob blob2 = blob = rs.getBlob(1);
                    JdbcUtil.close(rs);
                    if (conn != null) {
                        conn.close();
                    }
                    return blob2;
                }
                if (log.isLoggable(Level.FINER)) {
                    log.finer(this + " no blob data loaded for " + id);
                }
                Thread.dumpStack();
                JdbcUtil.close(rs);
            }
            catch (SQLException e) {
                log.log(Level.FINE, e.toString(), e);
                break block11;
            }
            finally {
                JdbcUtil.close(rs);
                if (conn != null) {
                    conn.close();
                }
            }
            if (conn != null) {
                conn.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDataAvailable(long id) {
        block9: {
            DataConnection conn = null;
            ResultSet rs = null;
            try {
                conn = this.getConnection();
                PreparedStatement pstmt = conn.prepareLoad();
                pstmt.setLong(1, id);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    boolean bl = true;
                    JdbcUtil.close(rs);
                    if (conn != null) {
                        conn.close();
                    }
                    return bl;
                }
                JdbcUtil.close(rs);
            }
            catch (SQLException e) {
                log.log(Level.FINE, e.toString(), e);
                break block9;
            }
            finally {
                JdbcUtil.close(rs);
                if (conn != null) {
                    conn.close();
                }
            }
            if (conn != null) {
                conn.close();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream openInputStream(long id) {
        ResultSet rs;
        DataConnection conn;
        block10: {
            DataInputStream dataInputStream;
            block9: {
                conn = null;
                rs = null;
                try {
                    conn = this.getConnection();
                    PreparedStatement pstmt = conn.prepareLoad();
                    pstmt.setLong(1, id);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        InputStream is = rs.getBinaryStream(1);
                        if (is == null) {
                            System.out.println(Thread.currentThread().getName() + " MISSING-DATA FOR ID: " + Long.toHexString(id));
                            InputStream inputStream = null;
                            JdbcUtil.close(rs);
                            if (conn == null) return inputStream;
                            conn.close();
                            return inputStream;
                        }
                        DataInputStream dataInputStream2 = new DataInputStream(conn, rs, is);
                        conn = null;
                        dataInputStream = dataInputStream2;
                        JdbcUtil.close(rs);
                        break block9;
                    }
                    JdbcUtil.close(rs);
                    break block10;
                }
                catch (SQLException e) {
                    log.log(Level.FINE, e.toString(), e);
                    return null;
                }
            }
            if (conn == null) return dataInputStream;
            conn.close();
            return dataInputStream;
        }
        if (conn == null) return null;
        conn.close();
        return null;
        finally {
            JdbcUtil.close(rs);
            if (conn != null) {
                conn.close();
            }
        }
    }

    public long save(StreamSource source, int length) throws IOException {
        return this.insert(source.openInputStream(), length);
    }

    public long save(InputStream is, int length) throws IOException {
        return this.insert(is, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long insert(InputStream is, int length) {
        if (is == null) {
            throw new NullPointerException();
        }
        DataConnection conn = null;
        try {
            conn = this.getConnection();
            PreparedStatement stmt = conn.prepareInsert();
            stmt.setBinaryStream(1, is, length);
            int count = stmt.executeUpdate();
            if (count > 0) {
                this._entryCount.addAndGet(1L);
                ResultSet keys = stmt.getGeneratedKeys();
                if (keys.next()) {
                    long id;
                    long l = id = keys.getLong("id");
                    return l;
                }
                throw new IllegalStateException();
            }
            long l = 0L;
            return l;
        }
        catch (SqlIndexAlreadyExistsException e) {
            log.finer(this + " " + e.toString());
            log.log(Level.FINEST, e.toString(), e);
            long l = 1L;
            return l;
        }
        catch (SQLException e) {
            e.printStackTrace();
            log.finer(this + " " + e.toString());
            log.log(Level.FINEST, e.toString(), e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(long id) {
        if (id <= 0L) {
            throw new IllegalStateException(L.l("remove of 0 value"));
        }
        DataConnection conn = null;
        try {
            conn = this.getConnection();
            PreparedStatement stmt = conn.prepareDelete();
            stmt.setLong(1, id);
            int count = stmt.executeUpdate();
            if (count > 0) {
                this._entryCount.addAndGet(-1L);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            log.finer(this + " " + e.toString());
            log.log(Level.FINEST, e.toString(), e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateDatabase() {
        DataConnection conn = null;
        try {
            conn = this.getConnection();
            PreparedStatement pstmt = conn.prepareValidate();
            pstmt.executeUpdate();
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, e.toString(), e);
            } else {
                log.warning(this + " " + e);
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    public long getCount() {
        return this._entryCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long getCountImpl() {
        long l;
        ResultSet rs;
        DataConnection conn;
        block5: {
            conn = null;
            rs = null;
            conn = this.getConnection();
            PreparedStatement stmt = conn.prepareCount();
            rs = stmt.executeQuery();
            if (rs == null || !rs.next()) break block5;
            long value = rs.getLong(1);
            rs.close();
            long l2 = value;
            JdbcUtil.close(rs);
            if (conn == null) return l2;
            conn.close();
            return l2;
        }
        try {
            l = -1L;
        }
        catch (SQLException e) {
            try {
                log.log(Level.FINE, e.toString(), e);
            }
            catch (Throwable throwable) {
                JdbcUtil.close(rs);
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            JdbcUtil.close(rs);
            if (conn == null) return -1L;
            conn.close();
            return -1L;
        }
        JdbcUtil.close(rs);
        if (conn == null) return l;
        conn.close();
        return l;
    }

    public boolean isClosed() {
        return this._dataSource == null;
    }

    public void destroy() {
        this._dataSource = null;
        this._freeConn = null;
        Alarm alarm = this._alarm;
        this._alarm = null;
        if (alarm != null) {
            alarm.dequeue();
        }
    }

    private DataConnection getConnection() throws SQLException {
        DataConnection cConn = this._freeConn.allocate();
        if (cConn == null) {
            Connection conn = this._dataSource.getConnection();
            cConn = new DataConnection(conn);
        }
        return cConn;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._tableName + "]";
    }

    private class DataConnection {
        private Connection _conn;
        private PreparedStatement _loadStatement;
        private PreparedStatement _insertStatement;
        private PreparedStatement _selectOrphanStatement;
        private PreparedStatement _deleteStatement;
        private PreparedStatement _validateStatement;
        private PreparedStatement _countStatement;

        DataConnection(Connection conn) {
            this._conn = conn;
        }

        PreparedStatement prepareLoad() throws SQLException {
            if (this._loadStatement == null) {
                this._loadStatement = this._conn.prepareStatement(DataStore.this._loadQuery);
            }
            return this._loadStatement;
        }

        PreparedStatement prepareInsert() throws SQLException {
            if (this._insertStatement == null) {
                this._insertStatement = this._conn.prepareStatement(DataStore.this._insertQuery, 1);
            }
            return this._insertStatement;
        }

        PreparedStatement prepareSelectOrphan() throws SQLException {
            if (this._selectOrphanStatement == null) {
                this._selectOrphanStatement = this._conn.prepareStatement(DataStore.this._selectOrphanQuery);
            }
            return this._selectOrphanStatement;
        }

        PreparedStatement prepareDelete() throws SQLException {
            if (this._deleteStatement == null) {
                this._deleteStatement = this._conn.prepareStatement(DataStore.this._deleteQuery);
            }
            return this._deleteStatement;
        }

        PreparedStatement prepareValidate() throws SQLException {
            if (this._validateStatement == null) {
                this._validateStatement = this._conn.prepareStatement(DataStore.this._validateQuery);
            }
            return this._validateStatement;
        }

        PreparedStatement prepareCount() throws SQLException {
            if (this._countStatement == null) {
                this._countStatement = this._conn.prepareStatement(DataStore.this._countQuery);
            }
            return this._countStatement;
        }

        void close() {
            if (DataStore.this._freeConn == null || !DataStore.this._freeConn.freeCareful(this)) {
                this.destroy();
            }
        }

        void destroy() {
            try {
                this._conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    class DataInputStream
    extends InputStream {
        private DataConnection _conn;
        private ResultSet _rs;
        private InputStream _is;

        DataInputStream(DataConnection conn, ResultSet rs, InputStream is) {
            this._conn = conn;
            this._rs = rs;
            this._is = is;
            if (is == null) {
                throw new NullPointerException();
            }
        }

        public int read() throws IOException {
            return this._is.read();
        }

        public int read(byte[] buffer, int offset, int length) throws IOException {
            return this._is.read(buffer, offset, length);
        }

        public void close() {
            DataConnection conn = this._conn;
            this._conn = null;
            ResultSet rs = this._rs;
            this._rs = null;
            InputStream is = this._is;
            this._is = null;
            IoUtil.close(is);
            JdbcUtil.close(rs);
            if (conn != null) {
                conn.close();
            }
        }
    }

    class DeleteAlarm
    implements AlarmListener {
        DeleteAlarm() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleAlarm(Alarm alarm) {
            if (DataStore.this._dataSource != null) {
                try {
                    this.deleteOrphans();
                }
                finally {
                    DataStore.this._alarm.queue(DataStore.this._expireTimeout);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void deleteOrphans() {
            DataConnection conn = null;
            ResultSet rs = null;
            boolean isValid = false;
            try {
                conn = DataStore.this.getConnection();
                PreparedStatement pstmt = conn.prepareSelectOrphan();
                rs = pstmt.executeQuery();
                try {
                    while (rs.next()) {
                        long id = rs.getLong(1);
                        long oid = rs.getLong(2);
                        if (oid > 0L) continue;
                        if (log.isLoggable(Level.FINER)) {
                            log.finer(this + " delete orphan " + Long.toHexString(id));
                        }
                        rs.deleteRow();
                    }
                }
                finally {
                    rs.close();
                }
                isValid = true;
            }
            catch (SQLException e) {
                e.printStackTrace();
                log.log(Level.FINE, e.toString(), e);
            }
            catch (Throwable e) {
                e.printStackTrace();
                log.log(Level.FINE, e.toString(), e);
            }
            finally {
                if (isValid) {
                    conn.close();
                } else {
                    conn.destroy();
                }
            }
        }
    }
}

