/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.distcache;

import com.caucho.distcache.ExtCacheEntry;
import com.caucho.server.distcache.CacheConfig;
import com.caucho.server.distcache.DistCacheEntry;
import com.caucho.server.distcache.MnodeEntry;
import com.caucho.server.distcache.MnodeUpdate;
import com.caucho.util.CurrentTime;
import com.caucho.util.HashKey;
import com.caucho.vfs.StreamSource;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;

public final class ExtCacheEntryFacade
implements ExtCacheEntry {
    private static final Logger log = Logger.getLogger(ExtCacheEntryFacade.class.getName());
    private final DistCacheEntry _entry;
    private final MnodeEntry _mnodeEntry;

    ExtCacheEntryFacade(DistCacheEntry entry) {
        this._entry = entry;
        this._mnodeEntry = entry.getMnodeEntry();
    }

    public final Object getKey() {
        return this._entry.getKey();
    }

    public final HashKey getKeyHash() {
        return this._entry.getKeyHash();
    }

    public Object getValue() {
        return this._mnodeEntry.getValue();
    }

    public boolean isValueNull() {
        return this._mnodeEntry.isValueNull();
    }

    public final int getUserFlags() {
        return this._mnodeEntry.getUserFlags();
    }

    public StreamSource getValueStream() {
        return this._entry.getValueStream();
    }

    public long getValueHash() {
        return this._mnodeEntry.getValueHash();
    }

    public long getValueLength() {
        return this._mnodeEntry.getValueLength();
    }

    public boolean readData(OutputStream os, CacheConfig config) throws IOException {
        return this._entry.readData(os, config);
    }

    public long getAccessedExpireTimeout() {
        return this._mnodeEntry.getAccessedExpireTimeout();
    }

    public long getModifiedExpireTimeout() {
        return this._mnodeEntry.getModifiedExpireTimeout();
    }

    public boolean isExpired(long now) {
        return this._mnodeEntry.isExpired(now);
    }

    public void updateAccessTime() {
        this._entry.updateAccessTime();
    }

    public long getLeaseExpireTimeout() {
        return this._mnodeEntry.getLeaseExpireTimeout();
    }

    public int getLeaseOwner() {
        if (!this._mnodeEntry.isLeaseExpired(CurrentTime.getCurrentTime())) {
            return this._mnodeEntry.getLeaseOwner();
        }
        return -1;
    }

    public long getLastAccessedTime() {
        return this._mnodeEntry.getLastAccessedTime();
    }

    public long getLastModifiedTime() {
        return this._mnodeEntry.getLastModifiedTime();
    }

    public long getVersion() {
        return this._mnodeEntry.getVersion();
    }

    public MnodeUpdate getRemoteUpdate() {
        return this._mnodeEntry.getRemoteUpdate();
    }

    public boolean isValid() {
        return this._mnodeEntry.isValid();
    }

    public int getLoadCount() {
        return this._entry.getLoadCount();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._mnodeEntry + "]";
    }
}

