/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.e_app;

import com.caucho.env.deploy.DeployControllerAdmin;
import com.caucho.env.deploy.EnvironmentDeployController;
import com.caucho.server.e_app.EarAdmin;
import com.caucho.server.e_app.EarConfig;
import com.caucho.server.e_app.EnterpriseApplication;
import com.caucho.server.webapp.WebAppContainer;
import com.caucho.server.webapp.WebAppController;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.el.ELException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EarDeployController
extends EnvironmentDeployController<EnterpriseApplication, EarConfig> {
    private static final Logger log = Logger.getLogger(EarDeployController.class.getName());
    private WebAppContainer _container;
    private Path _earRootDir;
    private ArrayList<EarConfig> _eAppDefaults = new ArrayList();
    private String _name;
    private String _deployTagName;
    private EarAdmin _admin = new EarAdmin(this);

    EarDeployController(String id, Path rootDirectory, String name, WebAppContainer container, EarConfig config) {
        super(id, rootDirectory, config, container.getEarDeployContainer());
        this._container = container;
        if (container != null) {
            this._eAppDefaults.addAll(container.getEarDefaultList());
        }
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setId(String name) {
        this.getVariableMap().put("name", name);
    }

    public Path getEarRootDir() {
        return this._earRootDir;
    }

    public void setEarRootDir(Path rootDir) {
        this._earRootDir = rootDir;
    }

    @Override
    protected DeployControllerAdmin getDeployAdmin() {
        return this._admin;
    }

    public WebAppController findWebAppController(String name) {
        try {
            EnterpriseApplication eApp = (EnterpriseApplication)this.getDeployInstanceImpl();
            if (eApp != null) {
                return eApp.findWebAppEntry(name);
            }
            return null;
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
            return null;
        }
    }

    @Override
    protected EnterpriseApplication instantiateDeployInstance() {
        return new EnterpriseApplication(this._container, this, this.getId());
    }

    protected Path calculateRootDirectory() throws ELException {
        Path rootDir = this.getRootDirectory();
        EnterpriseApplication eApp = (EnterpriseApplication)this.getDeployInstance();
        if (rootDir == null && eApp != null) {
            rootDir = eApp.getRootDirectory();
        }
        return rootDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean destroy() {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getParentClassLoader());
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
        return super.destroy();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof EarDeployController)) {
            return false;
        }
        EarDeployController entry = (EarDeployController)o;
        return this.getId().equals(entry.getId());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getId() + "]";
    }
}

