/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.e_app;

import com.caucho.config.ConfigException;
import com.caucho.env.deploy.DeployContainer;
import com.caucho.env.deploy.ExpandDeployGenerator;
import com.caucho.env.deploy.ExpandVersion;
import com.caucho.inject.Module;
import com.caucho.server.e_app.EarConfig;
import com.caucho.server.e_app.EarDeployController;
import com.caucho.server.e_app.EarDeployGeneratorAdmin;
import com.caucho.server.webapp.WebAppContainer;
import com.caucho.vfs.Path;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class EarDeployGenerator
extends ExpandDeployGenerator<EarDeployController> {
    private final EarDeployGeneratorAdmin _admin = new EarDeployGeneratorAdmin(this);
    private String _urlPrefix = "";
    private WebAppContainer _parentContainer;
    private ArrayList<EarConfig> _earDefaultList = new ArrayList();

    public EarDeployGenerator(String id, DeployContainer<EarDeployController> deployContainer, WebAppContainer parentContainer) {
        super(id, deployContainer, parentContainer.getRootDirectory());
        try {
            this.setExpandPrefix("_ear_");
            this.setExtension(".ear");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this._parentContainer = parentContainer;
        this._earDefaultList.addAll(parentContainer.getEarDefaultList());
    }

    WebAppContainer getContainer() {
        return this._parentContainer;
    }

    public String getURLPrefix() {
        return this._urlPrefix;
    }

    public void setURLPrefix(String prefix) {
        this._urlPrefix = prefix;
    }

    public void addEarDefault(EarConfig config) {
        this._earDefaultList.add(config);
    }

    @Override
    protected void initImpl() throws ConfigException {
        super.initImpl();
    }

    @Override
    protected void startImpl() throws ConfigException {
        super.startImpl();
        this._admin.register();
    }

    @Override
    public EarDeployController createController(ExpandVersion version) {
        String key = version.getKey();
        String tag = this.getId() + "/" + key;
        Path rootDirectory = this.getExpandPath(key);
        Path archivePath = this.getArchivePath(key);
        EarDeployController controller = new EarDeployController(tag, rootDirectory, key, this._parentContainer, null);
        controller.setArchivePath(archivePath);
        controller.setRedeployMode(this.getRedeployMode());
        for (EarConfig config : this._earDefaultList) {
            controller.addConfigDefault(config);
        }
        return controller;
    }

    @Override
    protected void destroyImpl() {
        this._admin.unregister();
        super.destroyImpl();
    }
}

