/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.fastcgi;

import com.caucho.server.fastcgi.FastCgiRequest;
import com.caucho.server.fastcgi.FastCgiResponse;
import com.caucho.server.http.ResponseStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FastCgiResponseStream
extends ResponseStream {
    private static final Logger log = Logger.getLogger(FastCgiResponseStream.class.getName());
    private FastCgiRequest _request;
    private WriteStream _next;

    FastCgiResponseStream(FastCgiRequest request, FastCgiResponse response, WriteStream next) {
        super(response);
        this._request = request;
        this._next = next;
    }

    public void start() {
        super.start();
    }

    protected byte[] getNextBuffer() {
        return this._next.getBuffer();
    }

    protected int getNextBufferOffset() throws IOException {
        return this._next.getBufferOffset();
    }

    protected void setNextBufferOffsetImpl(int offset) {
        this._next.setBufferOffset(offset);
    }

    protected byte[] writeNextBufferImpl(int offset) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.dbgId() + "write-chunk(" + offset + ")");
        }
        return this._next.nextBuffer(offset);
    }

    protected void flushNextImpl() throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.dbgId() + "flush()");
        }
        this._next.flush();
    }

    protected void closeNextImpl() throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.dbgId() + "flush()");
        }
        this._next.flush();
    }

    protected void writeTailImpl(boolean isClose) throws IOException {
        this.flushBuffer();
        this._request.writeTail();
    }
}

