/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.network.listen.AbstractProtocolConnection;
import com.caucho.network.listen.SocketLink;
import com.caucho.network.listen.SocketLinkDuplexController;
import com.caucho.network.listen.SocketLinkDuplexListener;
import com.caucho.network.listen.TcpSocketLink;
import com.caucho.security.SecurityContextProvider;
import com.caucho.server.cluster.ServletService;
import com.caucho.server.dispatch.Invocation;
import com.caucho.server.dispatch.InvocationDecoder;
import com.caucho.server.dispatch.InvocationServer;
import com.caucho.server.http.AbstractHttpResponse;
import com.caucho.server.http.AsyncContextImpl;
import com.caucho.server.http.Form;
import com.caucho.server.http.HttpBufferStore;
import com.caucho.server.http.HttpServletRequestImpl;
import com.caucho.server.http.HttpServletResponseImpl;
import com.caucho.server.http.InvocationKey;
import com.caucho.server.http.ServletInputStreamImpl;
import com.caucho.server.webapp.ErrorPageManager;
import com.caucho.server.webapp.RequestDispatcherImpl;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.CaseInsensitiveIntMap;
import com.caucho.util.CharBuffer;
import com.caucho.util.CharSegment;
import com.caucho.util.CurrentTime;
import com.caucho.util.HashMapImpl;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import com.caucho.util.NullEnumeration;
import com.caucho.util.QDate;
import com.caucho.util.StringCharCursor;
import com.caucho.vfs.BufferedReaderAdapter;
import com.caucho.vfs.ClientDisconnectException;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.nio.charset.UnsupportedCharsetException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHttpRequest
extends AbstractProtocolConnection
implements SecurityContextProvider {
    private static final Logger log;
    private static final L10N L;
    protected static final CaseInsensitiveIntMap _headerCodes;
    public static final String JSP_EXCEPTION = "javax.servlet.jsp.jspException";
    public static final String SHUTDOWN = "com.caucho.shutdown";
    private static final char[] CONNECTION;
    private static final char[] COOKIE;
    private static final char[] CONTENT_LENGTH;
    private static final char[] EXPECT;
    private static final char[] HOST;
    private static final char[] X_FORWARDED_HOST;
    private static final char[] CONTINUE_100;
    private static final char[] CLOSE;
    private static final char[] KEEPALIVE;
    public static final boolean[] TOKEN;
    private static final boolean[] VALUE;
    private static final Cookie[] NULL_COOKIES;
    private static final LruCache<CharBuffer, String> _nameCache;
    private final ServletService _server;
    private final SocketLink _conn;
    private final TcpSocketLink _tcpConn;
    private final AbstractHttpResponse _response;
    private final InvocationKey _invocationKey = new InvocationKey();
    private final ReadStream _rawRead;
    private final ReadStream _readStream;
    private final ArrayList<Cookie> _cookies = new ArrayList();
    private final ArrayList<Locale> _locales = new ArrayList();
    private final ServletInputStreamImpl _is = new ServletInputStreamImpl();
    private final BufferedReaderAdapter _bufferedReader;
    private final Form _formParser = new Form();
    private final HashMapImpl<String, String[]> _form = new HashMapImpl();
    private ErrorPageManager _errorManager;
    private final QDate _calendar = new QDate();
    private final CharBuffer _cbName = new CharBuffer();
    private final CharBuffer _cbValue = new CharBuffer();
    private final CharBuffer _cb = new CharBuffer();
    private byte[] _smallUriBuffer = new byte[256];
    private char[] _smallHeaderBuffer = new char[2048];
    private CharSegment[] _smallHeaderKeys = new CharSegment[32];
    private CharSegment[] _smallHeaderValues = new CharSegment[32];
    private HttpBufferStore _largeHttpBuffer;
    private HttpServletRequestImpl _requestFacade;
    private HttpServletResponseImpl _responseFacade;
    private long _startTime;
    private long _expireTime;
    private CharSegment _hostHeader;
    private CharSegment _xForwardedHostHeader;
    private boolean _expect100Continue;
    private long _contentLength;
    private boolean _hasReadStream;
    private String _readEncoding;

    protected AbstractHttpRequest(ServletService server, SocketLink conn) {
        this._server = server;
        if (server == null) {
            throw new NullPointerException();
        }
        this._conn = conn;
        this._rawRead = conn != null ? conn.getReadStream() : null;
        this._tcpConn = conn instanceof TcpSocketLink ? (TcpSocketLink)conn : null;
        this._readStream = new ReadStream();
        this._readStream.setReuseBuffer(true);
        this._bufferedReader = new BufferedReaderAdapter(this._readStream);
        for (int i = 0; i < this._smallHeaderKeys.length; ++i) {
            this._smallHeaderKeys[i] = new CharSegment();
            this._smallHeaderValues[i] = new CharSegment();
        }
        this._response = this.createResponse();
    }

    public ServletService getServer() {
        return this._server;
    }

    protected abstract AbstractHttpResponse createResponse();

    protected AbstractHttpResponse getAbstractHttpResponse() {
        return this._response;
    }

    @Override
    public void init() {
    }

    public final SocketLink getConnection() {
        return this._conn;
    }

    public final TcpSocketLink getTcpSocketLink() {
        return this._tcpConn;
    }

    public final int getConnectionId() {
        return this._conn.getId();
    }

    public final InvocationServer getInvocationServer() {
        return this._server.getInvocationServer();
    }

    protected final CharBuffer getCharBuffer() {
        return this._cb;
    }

    @Override
    public void onStartConnection() {
    }

    protected void startRequest() throws IOException {
        this._hostHeader = null;
        this._xForwardedHostHeader = null;
        this._expect100Continue = false;
        this._cookies.clear();
        this._contentLength = -1L;
        this._hasReadStream = false;
        this._locales.clear();
        this._readEncoding = null;
        this._requestFacade = new HttpServletRequestImpl(this);
        this._responseFacade = this._requestFacade.getResponse();
        this._response.startRequest();
        this._startTime = -1L;
        this._expireTime = -1L;
    }

    protected void clearRequest() {
        this._requestFacade = null;
        this._responseFacade = null;
    }

    public boolean hasRequest() {
        return this._requestFacade != null;
    }

    protected final byte[] getSmallUriBuffer() {
        return this._smallUriBuffer;
    }

    protected final char[] getSmallHeaderBuffer() {
        return this._smallHeaderBuffer;
    }

    protected final CharSegment[] getSmallHeaderKeys() {
        return this._smallHeaderKeys;
    }

    protected final CharSegment[] getSmallHeaderValues() {
        return this._smallHeaderValues;
    }

    protected final HttpBufferStore getHttpBufferStore() {
        return this._largeHttpBuffer;
    }

    protected final HttpBufferStore allocateHttpBufferStore() {
        if (this._largeHttpBuffer != null) {
            throw new IllegalStateException();
        }
        this._largeHttpBuffer = this.getServer().allocateHttpBuffer();
        return this._largeHttpBuffer;
    }

    public WriteStream getRawWrite() {
        return this._conn.getWriteStream();
    }

    public abstract byte[] getUriBuffer();

    public abstract int getUriLength();

    public boolean isIgnoreClientDisconnect() {
        WebApp webApp = this.getWebApp();
        if (webApp != null) {
            return webApp.isIgnoreClientDisconnect();
        }
        return true;
    }

    protected WebApp getWebApp() {
        if (this._requestFacade != null) {
            return this._requestFacade.getWebApp();
        }
        return null;
    }

    public StringBuffer getRequestURL() {
        HttpServletRequestImpl request = this.getRequestFacade();
        if (request != null) {
            return request.getRequestURL();
        }
        return null;
    }

    public String getRequestURI() {
        HttpServletRequestImpl request = this.getRequestFacade();
        if (request != null) {
            return request.getRequestURI();
        }
        return null;
    }

    @Override
    public String getProtocolRequestURL() {
        HttpServletRequestImpl request = this.getRequestFacade();
        if (request != null) {
            return request.getRequestURL().toString();
        }
        return null;
    }

    protected CharSegment getHostHeader() {
        return this._hostHeader;
    }

    protected CharSegment getForwardedHostHeader() {
        return this._xForwardedHostHeader;
    }

    public boolean isConnectionClosed() {
        if (this._tcpConn != null) {
            return this._tcpConn.isClosed();
        }
        return false;
    }

    public void clientDisconnect() {
        SocketLink conn = this._conn;
        if (conn != null) {
            conn.clientDisconnect();
        }
        this.killKeepalive("client disconnect");
        HttpServletResponseImpl response = this.getResponseFacade();
        if (response != null) {
            response.killCache();
        }
    }

    public final HttpServletRequestImpl getRequestFacade() {
        return this._requestFacade;
    }

    public final HttpServletResponseImpl getResponseFacade() {
        return this._responseFacade;
    }

    public AbstractHttpResponse getResponse() {
        return this._response;
    }

    public String getServerName() {
        CharSequence rawHost;
        String host = this._conn.getVirtualHost();
        if (host == null && (rawHost = this.getHost()) != null) {
            if (rawHost instanceof CharSegment) {
                CharSegment cb = (CharSegment)rawHost;
                char[] buffer = cb.getBuffer();
                int offset = cb.getOffset();
                int length = cb.getLength();
                for (int i = length - 1; i >= 0; --i) {
                    char ch = buffer[i + offset];
                    if ('A' > ch || ch > 'Z') continue;
                    buffer[i + offset] = (char)(ch + 97 - 65);
                }
                host = new String(buffer, offset, length);
            } else {
                return ((Object)rawHost).toString().toLowerCase(Locale.ENGLISH);
            }
        }
        if (host == null) {
            InetAddress addr = this._conn.getLocalAddress();
            return addr.getHostName();
        }
        int p1 = host.lastIndexOf(47);
        if (p1 < 0) {
            p1 = 0;
        }
        int ipv6 = host.lastIndexOf(93);
        int p = host.lastIndexOf(58);
        if (p >= 0 && p1 < p && (ipv6 <= 0 || p >= ipv6)) {
            return host.substring(p1, p);
        }
        return host;
    }

    protected CharSequence getHost() {
        return null;
    }

    public int getServerPort() {
        CharSequence rawHost;
        String host = this._conn.getVirtualHost();
        if (host == null && (rawHost = this.getHost()) != null) {
            int length = rawHost.length();
            for (int i = length - 1; i >= 0; --i) {
                if (rawHost.charAt(i) != ':') continue;
                int port = 0;
                ++i;
                while (i < length) {
                    char ch = rawHost.charAt(i);
                    if ('0' <= ch && ch <= '9') {
                        port = 10 * port + ch - 48;
                    }
                    ++i;
                }
                return port;
            }
            return this.isSecure() ? 443 : 80;
        }
        if (host == null) {
            return this._conn.getLocalPort();
        }
        int p1 = host.lastIndexOf(58);
        if (p1 < 0) {
            return this.isSecure() ? 443 : 80;
        }
        int length = host.length();
        int port = 0;
        for (int i = p1 + 1; i < length; ++i) {
            char ch = host.charAt(i);
            if ('0' > ch || ch > '9') continue;
            port = 10 * port + ch - 48;
        }
        return port;
    }

    public int getLocalPort() {
        return this._conn.getLocalPort();
    }

    public String getLocalHost() {
        return this._conn.getLocalHost();
    }

    public String getRemoteAddr() {
        return this._conn.getRemoteHost();
    }

    public int printRemoteAddr(byte[] buffer, int offset) throws IOException {
        int len = this._conn.getRemoteAddress(buffer, offset, buffer.length - offset);
        return offset + len;
    }

    public String getRemoteHost() {
        return this._conn.getRemoteHost();
    }

    public int getRemotePort() {
        return this._conn.getRemotePort();
    }

    public String getScheme() {
        return this.isSecure() ? "https" : "http";
    }

    public abstract String getProtocol();

    public abstract String getMethod();

    public abstract String getHeader(String var1);

    public int getHeaderSize() {
        return -1;
    }

    public CharSegment getHeaderKey(int index) {
        throw new UnsupportedOperationException();
    }

    public CharSegment getHeaderValue(int index) {
        throw new UnsupportedOperationException();
    }

    public CharSegment getHeaderBuffer(String name) {
        String value = this.getHeader(name);
        if (value != null) {
            return new CharBuffer(value);
        }
        return null;
    }

    public abstract Enumeration<String> getHeaderNames();

    public void setHeader(String key, String value) {
    }

    protected boolean addHeaderInt(char[] keyBuf, int keyOff, int keyLen, CharSegment value) {
        if (keyLen < 4) {
            return true;
        }
        char key1 = keyBuf[keyOff];
        switch (key1) {
            case 'C': 
            case 'c': {
                if (keyLen == CONNECTION.length && this.match(keyBuf, keyOff, keyLen, CONNECTION)) {
                    if (!this.match(value.getBuffer(), value.getOffset(), value.getLength(), KEEPALIVE)) {
                        this.handleConnectionClose();
                    }
                } else if (keyLen == COOKIE.length && this.match(keyBuf, keyOff, keyLen, COOKIE)) {
                    this.fillCookie(this._cookies, value);
                } else if (keyLen == CONTENT_LENGTH.length && this.match(keyBuf, keyOff, keyLen, CONTENT_LENGTH)) {
                    this.setContentLength(value);
                }
                return true;
            }
            case 'E': 
            case 'e': {
                if (this.match(keyBuf, keyOff, keyLen, EXPECT) && this.match(value.getBuffer(), value.getOffset(), value.getLength(), CONTINUE_100)) {
                    this._expect100Continue = true;
                    return false;
                }
                return true;
            }
            case 'H': 
            case 'h': {
                if (this.match(keyBuf, keyOff, keyLen, HOST)) {
                    this._hostHeader = value;
                }
                return true;
            }
            case 'x': {
                if (this.match(keyBuf, keyOff, keyLen, X_FORWARDED_HOST)) {
                    this._xForwardedHostHeader = value;
                }
                return true;
            }
        }
        return true;
    }

    protected void setContentLength(CharSegment value) {
        char ch;
        int i;
        long contentLength = 0L;
        int length = value.length();
        for (i = 0; i < length && (ch = value.charAt(i)) >= '0' && ch <= '9'; ++i) {
            contentLength = 10L * contentLength + (long)ch - 48L;
        }
        if (i > 0) {
            this._contentLength = contentLength;
        }
    }

    protected void handleConnectionClose() {
        SocketLink conn = this._conn;
        if (conn != null) {
            conn.killKeepalive("client Connection: close");
        }
    }

    private boolean match(char[] a, int aOff, int aLength, char[] b) {
        int bLength = b.length;
        if (aLength != bLength) {
            return false;
        }
        for (int i = aLength - 1; i >= 0; --i) {
            char chA = a[aOff + i];
            char chB = b[i];
            if (chA == chB || chA + 97 - 65 == chB) continue;
            return false;
        }
        return true;
    }

    public Enumeration<String> getHeaders(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return NullEnumeration.create();
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(value);
        return Collections.enumeration(list);
    }

    public void getHeaderBuffers(String name, ArrayList<CharSegment> resultList) {
        String value = this.getHeader(name);
        if (value != null) {
            resultList.add(new CharBuffer(value));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getIntHeader(String key) {
        CharSegment value = this.getHeaderBuffer(key);
        if (value == null) {
            return -1;
        }
        int len = value.length();
        if (len == 0) {
            throw new NumberFormatException(value.toString());
        }
        int iValue = 0;
        int i = 0;
        char ch = value.charAt(i);
        int sign = 1;
        if (ch == '+') {
            if (i + 1 >= len) throw new NumberFormatException(value.toString());
            ch = value.charAt(++i);
        } else if (ch == '-') {
            sign = -1;
            if (i + 1 >= len) throw new NumberFormatException(value.toString());
            ch = value.charAt(++i);
        }
        while (i < len && (ch = value.charAt(i)) >= '0' && ch <= '9') {
            iValue = 10 * iValue + ch - 48;
            ++i;
        }
        if (i >= len) return sign * iValue;
        throw new NumberFormatException(value.toString());
    }

    public long getDateHeader(String key) {
        String value = this.getHeader(key);
        if (value == null) {
            return -1L;
        }
        long date = -1L;
        try {
            date = this._calendar.parseDate(value);
            if (date == Long.MAX_VALUE) {
                throw new IllegalArgumentException("getDateHeader(" + value + ")");
            }
            return date;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public int getContentLength() {
        return (int)this._contentLength;
    }

    public long getLongContentLength() {
        return this._contentLength;
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public CharSegment getContentTypeBuffer() {
        return this.getHeaderBuffer("Content-Type");
    }

    public String getCharacterEncoding() {
        int tail;
        if (this._readEncoding != null) {
            return this._readEncoding;
        }
        CharSegment value = this.getHeaderBuffer("Content-Type");
        if (value == null) {
            return null;
        }
        int i = value.indexOf("charset");
        if (i < 0) {
            return null;
        }
        int len = value.length();
        i += 7;
        while (i < len && Character.isWhitespace(value.charAt(i))) {
            ++i;
        }
        if (i >= len || value.charAt(i) != '=') {
            return null;
        }
        ++i;
        while (i < len && Character.isWhitespace(value.charAt(i))) {
            ++i;
        }
        if (i >= len) {
            return null;
        }
        char end = value.charAt(i);
        if (end == '\"') {
            int tail2;
            for (tail2 = ++i; tail2 < len && value.charAt(tail2) != end; ++tail2) {
            }
            this._readEncoding = Encoding.getMimeName(value.substring(i, tail2));
            return this._readEncoding;
        }
        for (tail = i; tail < len && !Character.isWhitespace(value.charAt(tail)) && value.charAt(tail) != ';'; ++tail) {
        }
        this._readEncoding = Encoding.getMimeName(value.substring(i, tail));
        return this._readEncoding;
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        if (this._hasReadStream) {
            return;
        }
        this._readEncoding = encoding;
        try {
            this._readStream.setEncoding(this._readEncoding);
        }
        catch (UnsupportedEncodingException e) {
            throw e;
        }
        catch (UnsupportedCharsetException e) {
            throw new UnsupportedEncodingException(e.getMessage());
        }
    }

    public Cookie[] getCookies() {
        return this.fillCookies();
    }

    Cookie[] fillCookies() {
        ArrayList<Cookie> cookies = this._cookies;
        int size = cookies.size();
        if (size > 0) {
            Cookie[] cookiesIn = new Cookie[size];
            for (int i = size - 1; i >= 0; --i) {
                cookiesIn[i] = cookies.get(i);
            }
            return cookiesIn;
        }
        return NULL_COOKIES;
    }

    private void fillCookie(ArrayList<Cookie> cookies, CharSegment rawCookie) {
        char[] buf = rawCookie.getBuffer();
        int j = rawCookie.getOffset();
        int end = j + rawCookie.length();
        int version = 0;
        Cookie cookie = null;
        while (j < end) {
            char ch = '\u0000';
            CharBuffer cbName = this._cbName;
            CharBuffer cbValue = this._cbValue;
            cbName.clear();
            cbValue.clear();
            while (j < end && ((ch = buf[j]) == ' ' || ch == ';' || ch == ',')) {
                ++j;
            }
            if (end <= j) break;
            boolean isSpecial = false;
            if (buf[j] == '$') {
                isSpecial = true;
                ++j;
            }
            while (j < end && (ch = buf[j]) < '\u0080' && TOKEN[ch]) {
                cbName.append(ch);
                ++j;
            }
            while (j < end && (ch = buf[j]) == ' ') {
                ++j;
            }
            if (end <= j) break;
            if (ch == ';' || ch == ',') {
                try {
                    cookie = new Cookie(cbName.toString(), "");
                    cookie.setVersion(version);
                    this._cookies.add(cookie);
                }
                catch (Exception e) {
                    log.log(Level.FINE, e.toString(), e);
                }
                continue;
            }
            if (ch != '=') {
                while (j < end && (ch = buf[j]) != ';') {
                    ++j;
                }
                continue;
            }
            ++j;
            while (j < end && (ch = buf[j]) == ' ') {
                ++j;
            }
            if (ch == '\"') {
                ++j;
                while (j < end && (ch = buf[j]) != '\"') {
                    cbValue.append(ch);
                    ++j;
                }
                ++j;
            } else {
                int head = j;
                int tail = j;
                while (j < end) {
                    ch = buf[j];
                    if (ch < '\u0080' && VALUE[ch]) {
                        cbValue.append(ch);
                        tail = j + 1;
                    } else {
                        if (ch != ' ') break;
                        cbValue.append(ch);
                    }
                    ++j;
                }
                cbValue.setLength(tail - head);
            }
            if (!isSpecial) {
                if (cbName.length() == 0) {
                    log.warning("bad cookie: " + rawCookie);
                    continue;
                }
                cookie = new Cookie(this.toName(cbName), cbValue.toString());
                cookie.setVersion(version);
                this._cookies.add(cookie);
                continue;
            }
            if (cookie == null) {
                if (!cbName.matchesIgnoreCase("Version")) continue;
                version = cbValue.charAt(0) - 48;
                continue;
            }
            if (cbName.matchesIgnoreCase("Version")) {
                cookie.setVersion(cbValue.charAt(0) - 48);
                continue;
            }
            if (cbName.matchesIgnoreCase("Domain")) {
                cookie.setDomain(cbValue.toString());
                continue;
            }
            if (!cbName.matchesIgnoreCase("Path")) continue;
            cookie.setPath(cbValue.toString());
        }
    }

    private String toName(CharBuffer cb) {
        String value = _nameCache.get(cb);
        if (value == null) {
            value = cb.toString();
            cb = new CharBuffer(value);
            _nameCache.put(cb, value);
        }
        return value;
    }

    public String findSessionIdFromConnection() {
        return null;
    }

    @Override
    public boolean isTransportSecure() {
        return this._conn.isSecure();
    }

    public ReadStream getStream() throws IOException {
        return this.getStream(true);
    }

    public ReadStream getStream(boolean isReader) throws IOException {
        if (!this._hasReadStream) {
            this._hasReadStream = true;
            this.initStream(this._readStream, this._rawRead);
            if (isReader) {
                String charEncoding = this.getCharacterEncoding();
                String javaEncoding = Encoding.getJavaName(charEncoding);
                this._readStream.setEncoding(javaEncoding);
            }
            if (this._expect100Continue) {
                this._expect100Continue = false;
                this._response.writeContinue();
            }
        }
        return this._readStream;
    }

    public final ReadStream getRawRead() {
        return this._rawRead;
    }

    public final ReadStream getReadStream() {
        return this._readStream;
    }

    public byte[] getRawReadBuffer() {
        return this._rawRead.getBuffer();
    }

    public int getAvailable() throws IOException {
        return this._readStream.getAvailable();
    }

    protected void skip() throws IOException {
        try {
            if (!this._hasReadStream) {
                if (!this.initStream(this._readStream, this._rawRead)) {
                    return;
                }
                this._hasReadStream = true;
            }
            while (this._readStream.skip(8192L) > 0L) {
            }
        }
        catch (ClientDisconnectException e) {
            log.log(Level.FINER, e.toString(), e);
        }
    }

    protected abstract boolean initStream(ReadStream var1, ReadStream var2) throws IOException;

    public ReadStream getRawInput() {
        throw new UnsupportedOperationException(L.l("raw mode is not supported in this configuration"));
    }

    public final ServletInputStream getInputStream() throws IOException {
        ReadStream stream = this.getStream(false);
        this._is.init(stream);
        return this._is;
    }

    public final BufferedReader getReader() throws IOException {
        try {
            this._bufferedReader.init(this.getStream(true));
            return this._bufferedReader;
        }
        catch (UnsupportedCharsetException e) {
            throw new UnsupportedEncodingException(e.getMessage());
        }
    }

    protected void initAttributes(HttpServletRequestImpl facade) {
    }

    public Locale getLocale() {
        this.fillLocales();
        return this._locales.get(0);
    }

    public Enumeration<Locale> getLocales() {
        this.fillLocales();
        return Collections.enumeration(this._locales);
    }

    private void fillLocales() {
        if (this._locales.size() > 0) {
            return;
        }
        Enumeration<String> headers = this.getHeaders("Accept-Language");
        if (headers == null) {
            this._locales.add(Locale.getDefault());
            return;
        }
        CharBuffer cb = this._cb;
        while (headers.hasMoreElements()) {
            String header = headers.nextElement();
            StringCharCursor cursor = new StringCharCursor(header);
            while (cursor.current() != '\uffff') {
                char ch;
                while (Character.isWhitespace(cursor.current())) {
                    cursor.next();
                }
                cb.clear();
                while ((ch = cursor.current()) >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '0') {
                    cb.append(cursor.current());
                    cursor.next();
                }
                String language = cb.toString();
                String country = "";
                if (cursor.current() == '_' || cursor.current() == '-') {
                    cb.clear();
                    cursor.next();
                    while ((ch = cursor.current()) >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9') {
                        cb.append(cursor.current());
                        cursor.next();
                    }
                    country = cb.toString();
                }
                if (language.length() > 0) {
                    Locale locale = new Locale(language, country);
                    this._locales.add(locale);
                }
                while (cursor.current() != '\uffff' && cursor.current() != ',') {
                    cursor.next();
                }
                cursor.next();
            }
        }
        if (this._locales.size() == 0) {
            this._locales.add(Locale.getDefault());
        }
    }

    public boolean isSecure() {
        return this._conn.isSecure();
    }

    @Override
    public String runAs(String string) {
        if (this._requestFacade != null) {
            return this._requestFacade.runAs(string);
        }
        return null;
    }

    @Override
    public boolean isUserInRole(String role) {
        if (this._requestFacade != null) {
            return this._requestFacade.isUserInRole(role);
        }
        return false;
    }

    @Override
    public Principal getUserPrincipal() {
        if (this._requestFacade != null) {
            return this._requestFacade.getUserPrincipal();
        }
        return null;
    }

    public final long getStartTime() {
        return this._startTime;
    }

    @Override
    public final void onAttachThread() {
    }

    @Override
    public final void onDetachThread() {
        HttpBufferStore httpBuffer = this._largeHttpBuffer;
        this._largeHttpBuffer = null;
        if (httpBuffer != null) {
            this.getServer().freeHttpBuffer(httpBuffer);
        }
    }

    protected Invocation getInvocation(CharSequence host, byte[] uri, int uriLength) throws IOException {
        this._invocationKey.init(this.isSecure(), host, this.getServerPort(), uri, uriLength);
        InvocationServer server = this._server.getInvocationServer();
        Invocation invocation = server.getInvocation(this._invocationKey);
        if (invocation != null) {
            return invocation.getRequestInvocation(this._requestFacade);
        }
        invocation = server.createInvocation();
        invocation.setSecure(this.isSecure());
        if (host != null) {
            String hostName = ((Object)host).toString().toLowerCase(Locale.ENGLISH);
            invocation.setHost(hostName);
            invocation.setPort(this.getServerPort());
            int p = hostName.lastIndexOf(58);
            int q = hostName.lastIndexOf(93);
            if (p > 0 && q < p) {
                invocation.setHostName(hostName.substring(0, p));
            } else {
                invocation.setHostName(hostName);
            }
        }
        return this.buildInvocation(invocation, uri, uriLength);
    }

    protected Invocation buildInvocation(Invocation invocation, byte[] uri, int uriLength) throws IOException {
        InvocationServer server = this._server.getInvocationServer();
        InvocationDecoder decoder = server.getInvocationDecoder();
        decoder.splitQueryAndUnescape(invocation, uri, uriLength);
        if (this._server.isModified()) {
            this._server.logModified(log);
            this._requestFacade.setInvocation(invocation);
            invocation.setWebApp(this._server.getErrorWebApp());
            HttpServletResponseImpl res = this._responseFacade;
            res.sendError(503);
            this._server.restart();
            return null;
        }
        invocation = server.buildInvocation(this._invocationKey.clone(), invocation);
        return invocation.getRequestInvocation(this._requestFacade);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleResume() throws IOException {
        try {
            this.startInvocation();
            HttpServletRequestImpl request = this.getRequestFacade();
            if (request == null) {
                boolean bl = false;
                return bl;
            }
            AsyncContextImpl asyncContext = request.getAsyncContext();
            ServletContext webApp = asyncContext.getDispatchContext();
            String url = asyncContext.getDispatchPath();
            if (this._tcpConn != null && this._tcpConn.isAsyncComplete()) {
                boolean bl = false;
                return bl;
            }
            if (url != null) {
                RequestDispatcherImpl disp;
                if (webApp == null) {
                    webApp = this.getWebApp();
                }
                if ((disp = (RequestDispatcherImpl)webApp.getRequestDispatcher(url)) != null) {
                    disp.dispatchResume(this.getRequestFacade(), this.getResponseFacade());
                    boolean bl = this.isSuspend();
                    return bl;
                }
            }
            Invocation invocation = this.getRequestFacade().getInvocation();
            invocation.service(this.getRequestFacade(), this.getResponseFacade());
        }
        catch (ClientDisconnectException e) {
            this._responseFacade.killCache();
            throw e;
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
            if (this._responseFacade != null) {
                this._responseFacade.killCache();
            }
            this.killKeepalive("resume exception: " + e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.finishInvocation();
            if (!this.isSuspend()) {
                this.finishRequest();
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.dbgId() + (this.isKeepalive() ? "keepalive" : "no-keepalive"));
        }
        return this.isSuspend();
    }

    WebApp getAsyncDispatchWebApp() {
        throw new UnsupportedOperationException();
    }

    String getAsyncDispatchUrl() {
        throw new UnsupportedOperationException();
    }

    public SocketLinkDuplexController startDuplex(SocketLinkDuplexListener handler) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    protected void sendRequestError(Throwable e) throws IOException {
        WebApp webApp;
        this.killKeepalive("request error: " + e);
        try {
            ErrorPageManager errorManager = this.getErrorManager();
            if (errorManager != null) {
                this.getErrorManager().sendServletError(e, this._requestFacade, this._responseFacade);
            } else {
                this._responseFacade.sendError(503);
            }
        }
        catch (ClientDisconnectException e1) {
            throw e1;
        }
        catch (Throwable e1) {
            log.log(Level.FINE, e1.toString(), e1);
        }
        if (this._server instanceof ServletService && (webApp = this._server.getDefaultWebApp()) != null && this.getRequestFacade() != null) {
            webApp.accessLog(this.getRequestFacade(), this.getResponseFacade());
        }
    }

    protected ErrorPageManager getErrorManager() {
        if (this._errorManager == null) {
            this._errorManager = this._server.getErrorPageManager();
        }
        return this._errorManager;
    }

    public void killKeepalive(String reason) {
        SocketLink conn = this._conn;
        if (conn != null) {
            conn.killKeepalive(reason);
        }
    }

    protected boolean isKeepalive() {
        SocketLink conn = this._conn;
        return conn != null && conn.isKeepaliveAllocated();
    }

    public boolean isCometActive() {
        TcpSocketLink conn = this._tcpConn;
        return conn != null && conn.isCometActive();
    }

    public boolean isSuspend() {
        return this._tcpConn != null && (this._tcpConn.isCometActive() || this._tcpConn.isDuplex());
    }

    public boolean isDuplex() {
        return this._tcpConn != null && this._tcpConn.isDuplex();
    }

    protected HashMapImpl<String, String[]> getForm() {
        this._form.clear();
        return this._form;
    }

    protected Form getFormParser() {
        return this._formParser;
    }

    protected void restartServer() {
    }

    protected void startInvocation() throws IOException {
        this._startTime = CurrentTime.getExactTime();
        TcpSocketLink tcpConn = this._tcpConn;
        if (tcpConn != null) {
            long requestTimeout = tcpConn.getPort().getRequestTimeout();
            this._expireTime = requestTimeout > 0L ? this._startTime + requestTimeout : 0x3FFFFFFFFFFFFFFFL;
        }
        this._response.startInvocation();
    }

    public void finishInvocation() {
        try {
            this._response.finishInvocation();
        }
        catch (IOException e) {
            log.finer(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishRequest() throws IOException {
        try {
            HttpServletRequestImpl requestFacade = this._requestFacade;
            this._requestFacade = null;
            this._responseFacade = null;
            if (requestFacade != null) {
                requestFacade.finishRequest();
            }
            this._response.finishRequest();
            this.cleanup();
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        finally {
            this._requestFacade = null;
            this._responseFacade = null;
        }
    }

    @Override
    public void onCloseConnection() {
        try {
            this.finishRequest();
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        HttpBufferStore httpBuffer = this._largeHttpBuffer;
        this._largeHttpBuffer = null;
        if (httpBuffer != null) {
            this.getServer().freeHttpBuffer(httpBuffer);
        }
    }

    public void cleanup() {
        HttpServletRequestImpl requestFacade = this.getRequestFacade();
        if (requestFacade != null) {
            requestFacade.cleanup();
        }
        if (this._form != null) {
            this._form.clear();
        }
        this._cookies.clear();
    }

    public void shutdown() {
    }

    protected String dbgId() {
        return "Tcp[" + this._conn.getId() + "] ";
    }

    static {
        int i;
        log = Logger.getLogger(AbstractHttpRequest.class.getName());
        L = new L10N(AbstractHttpRequest.class);
        CONNECTION = "connection".toCharArray();
        COOKIE = "cookie".toCharArray();
        CONTENT_LENGTH = "content-length".toCharArray();
        EXPECT = "expect".toCharArray();
        HOST = "host".toCharArray();
        X_FORWARDED_HOST = "x-forwarded-host".toCharArray();
        CONTINUE_100 = "100-continue".toCharArray();
        CLOSE = "close".toCharArray();
        KEEPALIVE = "keep-alive".toCharArray();
        NULL_COOKIES = new Cookie[0];
        _nameCache = new LruCache(1024);
        _headerCodes = new CaseInsensitiveIntMap();
        TOKEN = new boolean[256];
        VALUE = new boolean[256];
        for (i = 0; i < 256; ++i) {
            AbstractHttpRequest.TOKEN[i] = true;
        }
        for (i = 0; i < 32; ++i) {
            AbstractHttpRequest.TOKEN[i] = false;
        }
        for (i = 127; i < 256; ++i) {
            AbstractHttpRequest.TOKEN[i] = false;
        }
        AbstractHttpRequest.TOKEN[44] = false;
        AbstractHttpRequest.TOKEN[59] = false;
        AbstractHttpRequest.TOKEN[92] = false;
        AbstractHttpRequest.TOKEN[34] = false;
        AbstractHttpRequest.TOKEN[61] = false;
        AbstractHttpRequest.TOKEN[32] = false;
        System.arraycopy(TOKEN, 0, VALUE, 0, TOKEN.length);
        AbstractHttpRequest.VALUE[61] = true;
    }
}

