/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.env.thread.ThreadPool;
import com.caucho.network.listen.AsyncController;
import com.caucho.network.listen.SocketLink;
import com.caucho.network.listen.SocketLinkCometListener;
import com.caucho.server.http.AbstractHttpRequest;
import com.caucho.server.http.AsyncListenerNode;
import com.caucho.server.http.ConnectionCometController;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncContextImpl
implements AsyncContext,
SocketLinkCometListener {
    private static final L10N L = new L10N(ConnectionCometController.class);
    private static final Logger log = Logger.getLogger(ConnectionCometController.class.getName());
    private SocketLink _tcpConnection;
    private AsyncController _cometController;
    private ServletRequest _request;
    private ServletResponse _response;
    private boolean _isOriginal;
    private ArrayList<AsyncListenerNode> _listeners;
    private AtomicBoolean _isComplete = new AtomicBoolean();
    private String _dispatchDefault;
    private WebApp _dispatchWebApp;
    private String _dispatchPath;

    public AsyncContextImpl(AbstractHttpRequest httpConn) {
        this._tcpConnection = httpConn.getConnection();
        this._cometController = this._tcpConnection.toComet(this);
    }

    public void restart() {
        this._cometController = this._tcpConnection.toComet(this);
    }

    public void init(ServletRequest request, ServletResponse response, boolean isOriginal) {
        this._request = request;
        this._response = response;
        if (!(request instanceof HttpServletRequest)) {
            throw new IllegalStateException(L.l("startAsync requires a HttpServletRequest"));
        }
        this._dispatchWebApp = (WebApp)request.getServletContext();
        HttpServletRequest req = (HttpServletRequest)request;
        String servletPath = req.getServletPath();
        String pathInfo = req.getPathInfo();
        this._dispatchDefault = pathInfo == null ? servletPath : (servletPath == null ? pathInfo : servletPath + pathInfo);
        this._isOriginal = isOriginal;
        this.onStart(req, response);
    }

    @Override
    public ServletRequest getRequest() {
        return this._request;
    }

    @Override
    public ServletResponse getResponse() {
        return this._response;
    }

    @Override
    public boolean hasOriginalRequestAndResponse() {
        return this._isOriginal;
    }

    @Override
    public void setTimeout(long idleTimeout) {
        this._cometController.setMaxIdleTime(idleTimeout);
    }

    @Override
    public long getTimeout() {
        return this._cometController.getMaxIdleTime();
    }

    private boolean isActive() {
        return this._cometController != null;
    }

    public boolean isAsyncStarted() {
        AsyncController controller = this._cometController;
        return controller != null && controller.isAsyncStarted();
    }

    public boolean isAsyncComplete() {
        AsyncController controller = this._cometController;
        return controller != null && controller.isCometComplete();
    }

    ServletContext getDispatchContext() {
        return this._dispatchWebApp;
    }

    String getDispatchPath() {
        return this._dispatchPath;
    }

    @Override
    public void addListener(AsyncListener listener) {
        this.addListener(listener, this._request, this._response);
    }

    @Override
    public void addListener(AsyncListener listener, ServletRequest request, ServletResponse response) {
        if (this._listeners == null) {
            this._listeners = new ArrayList();
        }
        this._listeners.add(new AsyncListenerNode(listener, request, response, null));
    }

    @Override
    public <T extends AsyncListener> T createListener(Class<T> cl) throws ServletException {
        return (T)((AsyncListener)this._request.getServletContext().createListener(cl));
    }

    @Override
    public void dispatch() {
        AsyncController cometController = this._cometController;
        if (cometController == null) {
            throw new IllegalStateException(L.l("dispatch is not valid when no AsyncContext is available"));
        }
        if (this._dispatchPath == null) {
            this._dispatchPath = this._dispatchDefault;
        }
        cometController.wake();
    }

    @Override
    public void dispatch(String path) {
        this._dispatchPath = path;
        this.dispatch();
    }

    @Override
    public void dispatch(ServletContext context, String path) {
        this._dispatchWebApp = (WebApp)context;
        this._dispatchPath = path;
        this.dispatch();
    }

    @Override
    public void start(Runnable task) {
        if (!this.isActive()) {
            throw new IllegalStateException(L.l("AsyncContext.start() is not allowed because the AsyncContext has been completed."));
        }
        ThreadPool.getCurrent().schedule(task);
    }

    @Override
    public void complete() {
        AsyncController cometController = this._cometController;
        boolean isSuspend = this._tcpConnection.isCometSuspend();
        if (cometController != null) {
            cometController.complete();
        }
        if (!isSuspend) {
            this.onComplete();
        }
    }

    public void onStart(ServletRequest request, ServletResponse response) {
        if (this._listeners == null) {
            return;
        }
        AsyncEvent event = new AsyncEvent(this, request, response);
        for (AsyncListenerNode node : this._listeners) {
            try {
                node.onStart(event);
            }
            catch (IOException e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
    }

    @Override
    public boolean onTimeout() {
        if (this._listeners == null) {
            return true;
        }
        AsyncEvent event = new AsyncEvent(this, this._request, this._response);
        for (AsyncListenerNode node : this._listeners) {
            try {
                node.onTimeout(event);
            }
            catch (IOException e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        return this._dispatchPath == null;
    }

    public void onError() {
        if (this._listeners == null) {
            return;
        }
        AsyncEvent event = new AsyncEvent(this, this._request, this._response);
        for (AsyncListenerNode node : this._listeners) {
            try {
                node.onError(event);
            }
            catch (IOException e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
    }

    @Override
    public void onComplete() {
        if (this._isComplete.getAndSet(true)) {
            return;
        }
        if (this._listeners == null) {
            return;
        }
        AsyncEvent event = new AsyncEvent(this, this._request, this._response);
        for (AsyncListenerNode node : this._listeners) {
            try {
                node.onComplete(event);
            }
            catch (IOException e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._cometController + "]";
    }
}

