/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import java.io.IOException;

class ChunkedInputStream
extends StreamImpl {
    private ReadStream _next;
    private int _available;

    ChunkedInputStream() {
    }

    void init(ReadStream next) {
        this._next = next;
        this._available = 0;
    }

    public boolean canRead() {
        return true;
    }

    public int getAvailable() {
        return this._available;
    }

    public int read(byte[] buf, int offset, int len) throws IOException {
        if (this._available > 0) {
            if (this._available < len) {
                len = this._available;
            }
            if ((len = this._next.read(buf, offset, len)) > 0) {
                this._available -= len;
            }
        } else if (this._available == 0) {
            this._available = this.readChunkLength();
            if (this._available > 0) {
                if (this._available < len) {
                    len = this._available;
                }
                if ((len = this._next.read(buf, offset, len)) > 0) {
                    this._available -= len;
                }
            } else {
                this._available = -1;
                len = -1;
            }
        } else {
            len = -1;
        }
        return len;
    }

    private int readChunkLength() throws IOException {
        int length = 0;
        ReadStream is = this._next;
        int ch = is.read();
        while (ch == 32 || ch == 9 || ch == 13 || ch == 10) {
            ch = is.read();
        }
        while (ch > 0 && ch != 13 && ch != 10) {
            if (48 <= ch && ch <= 57) {
                length = 16 * length + ch - 48;
            } else if (97 <= ch && ch <= 102) {
                length = 16 * length + ch - 97 + 10;
            } else if (65 <= ch && ch <= 70) {
                length = 16 * length + ch - 65 + 10;
            } else if (ch != 32 && ch != 9) {
                StringBuilder sb = new StringBuilder();
                sb.append((char)ch);
                int ch1 = is.read();
                while (ch1 >= 0 && ch1 != 13 && ch1 != 10) {
                    sb.append((char)ch1);
                    ch1 = is.read();
                }
                throw new IOException("HTTP/1.1 protocol error: bad chunk at '" + sb + "'" + " 0x" + Integer.toHexString(ch) + " length=" + length);
            }
            ch = is.read();
        }
        if (ch == 13) {
            ch = is.read();
        }
        return length;
    }
}

