/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.env.thread.ThreadPool;
import com.caucho.network.listen.AsyncController;
import com.caucho.network.listen.SocketLink;
import com.caucho.network.listen.SocketLinkCometListener;
import com.caucho.server.http.AsyncListenerNode;
import com.caucho.servlet.comet.CometController;
import com.caucho.util.L10N;
import java.util.HashMap;
import javax.servlet.AsyncListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionCometController
implements CometController,
SocketLinkCometListener {
    private static final L10N L = new L10N(ConnectionCometController.class);
    private final AsyncController _cometController;
    private HashMap<String, Object> _map;
    private ServletRequest _request;
    private ServletResponse _response;
    private AsyncListenerNode _listenerNode;
    private boolean _isTimeout;
    private String _forwardPath;
    private long _maxIdleTime;

    public ConnectionCometController(SocketLink conn, boolean isTop, ServletRequest request, ServletResponse response) {
        this._cometController = conn.toComet(this);
        this._request = request;
        this._response = response;
    }

    @Override
    public void setMaxIdleTime(long idleTime) {
        if (idleTime < 0L || 0x3FFFFFFFFFFFFFFFL < idleTime) {
            this._maxIdleTime = 0x3FFFFFFFFFFFFFFFL;
        }
    }

    @Override
    public long getMaxIdleTime() {
        return this._maxIdleTime;
    }

    public final boolean isComplete() {
        return this._cometController.isCometComplete();
    }

    public final void complete() {
        this._cometController.complete();
    }

    @Override
    public boolean onTimeout() {
        return true;
    }

    @Override
    public void onComplete() {
    }

    public final void startResume() {
    }

    @Override
    public final boolean wake() {
        this._cometController.wake();
        return false;
    }

    public boolean isDuplex() {
        return false;
    }

    public final void timeout() {
        this.wake();
    }

    public final boolean isTimeout() {
        return this._isTimeout;
    }

    public final boolean isActive() {
        return false;
    }

    public boolean isComet() {
        return false;
    }

    public void setAsyncListenerNode(AsyncListenerNode node) {
        this._listenerNode = node;
    }

    public void addAsyncListener(AsyncListener listener, ServletRequest request, ServletResponse response) {
        this._listenerNode = new AsyncListenerNode(listener, request, response, this._listenerNode);
    }

    public void addListener(AsyncListener listener) {
        this.addListener(listener, this._request, this._response);
    }

    public void addListener(AsyncListener listener, ServletRequest request, ServletResponse response) {
        this._listenerNode = new AsyncListenerNode(listener, request, response, this._listenerNode);
    }

    public <T extends AsyncListener> T createListener(Class<T> cl) throws ServletException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void setTimeout(long timeout) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public long getTimeout() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getAttribute(String name) {
        if (this._map != null) {
            HashMap<String, Object> hashMap = this._map;
            synchronized (hashMap) {
                return this._map.get(name);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttribute(String name, Object value) {
        Object object;
        if (this._map == null) {
            object = this;
            synchronized (object) {
                if (this._map == null) {
                    this._map = new HashMap(8);
                }
            }
        }
        object = this._map;
        synchronized (object) {
            this._map.put(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAttribute(String name) {
        if (this._map != null) {
            HashMap<String, Object> hashMap = this._map;
            synchronized (hashMap) {
                this._map.remove(name);
            }
        }
    }

    @Override
    public final boolean isClosed() {
        return this._cometController.isCometComplete();
    }

    public ServletRequest getRequest() {
        return this._request;
    }

    public ServletResponse getResponse() {
        return this._response;
    }

    public boolean hasOriginalRequestAndResponse() {
        return true;
    }

    public String getForwardPath() {
        return this._forwardPath;
    }

    public void dispatch() {
        this._cometController.wake();
    }

    public void dispatch(String path) {
        this._forwardPath = path;
        this.dispatch();
    }

    public void dispatch(ServletContext context, String path) {
        this._forwardPath = path;
        this.dispatch();
    }

    public void start(Runnable task) {
        if (!this.isActive()) {
            throw new IllegalStateException(L.l("AsyncContext.start() is not allowed because the AsyncContext has been completed."));
        }
        ThreadPool.getCurrent().schedule(task);
    }

    @Override
    public void close() {
        this.complete();
    }

    public void closeImpl() {
        this._cometController.complete();
        this._request = null;
        this._response = null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._cometController + "]";
    }
}

