/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.repository;

import com.caucho.config.Config;
import com.caucho.config.Service;
import com.caucho.config.Unbound;
import com.caucho.loader.JarMap;
import com.caucho.loader.maven.MavenProject;
import com.caucho.loader.module.Artifact;
import com.caucho.loader.module.ArtifactDependency;
import com.caucho.loader.module.ArtifactRepository;
import com.caucho.loader.module.ArtifactResolver;
import com.caucho.util.L10N;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Unbound
public class ProjectJarRepository
implements ArtifactResolver {
    private static final L10N L = new L10N(ProjectJarRepository.class);
    private static final Logger log = Logger.getLogger(ProjectJarRepository.class.getName());
    private Path _path;
    private ArrayList<Entry> _entryList = new ArrayList();

    public void setPath(Path path) {
        this._path = path;
    }

    @PostConstruct
    public void init() {
        this.update();
        ArtifactRepository repository = ArtifactRepository.create();
        repository.addResolver(this);
    }

    @Override
    public void resolve(ArrayList<Artifact> artifactList, ArtifactDependency dependency) {
        for (Entry entry : this._entryList) {
            Artifact artifact = entry.getArtifact();
            if (artifact == null || !artifact.isMatch(dependency)) continue;
            artifactList.add(artifact);
        }
    }

    protected void update() {
        ArrayList<Path> jarList = this.getJarList();
        for (Path jarPath : jarList) {
            if (!jarPath.canRead()) {
                log.warning(L.l("{0}: '{1}' is an unreadable repository jar", (Object)this, (Object)jarPath));
                continue;
            }
            Entry entry = this.readJar(jarPath);
            this._entryList.add(entry);
        }
    }

    private Entry readJar(Path jarPath) {
        JarMap jarMap = new JarMap();
        jarMap.scan(jarPath);
        Iterator<String> keyIter = jarMap.keys();
        while (keyIter.hasNext()) {
            Artifact artifact;
            String lowerKey;
            String key = keyIter.next();
            if (!key.endsWith("/pom.xml") || !(lowerKey = key.toLowerCase(Locale.ENGLISH)).startsWith("meta-inf/maven/") || (artifact = this.readPom(jarPath, key)) == null) continue;
            return new Entry(jarPath, artifact, jarMap);
        }
        return new Entry(jarPath, null, null);
    }

    private Artifact readPom(Path jarPath, String key) {
        JarPath jar = JarPath.create(jarPath);
        try {
            MavenProject project = new MavenProject();
            new Config().configure((Object)project, jar.lookup(key));
            Artifact artifact = project.toArtifact(jarPath);
            return artifact;
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }

    protected ArrayList<Path> getJarList() {
        ArrayList<Path> jarList = new ArrayList<Path>();
        try {
            for (String name : this._path.list()) {
                if (!name.endsWith(".jar")) continue;
                Path jar = this._path.lookup(name);
                jarList.add(jar);
            }
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
        return jarList;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._path + "]";
    }

    static class Entry {
        private Path _path;
        private Artifact _artifact;

        Entry(Path path, Artifact artifact, JarMap jarMap) {
            this._path = path;
            this._artifact = artifact;
            new SoftReference<JarMap>(jarMap);
        }

        Artifact getArtifact() {
            return this._artifact;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._path + "," + this._artifact + "]";
        }
    }
}

