/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.rewrite;

import com.caucho.server.rewrite.AbstractCondition;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HeaderCondition
extends AbstractCondition {
    private final String _header;
    private Pattern _regexp;
    private boolean _caseInsensitive = false;
    private boolean _sendVary = true;

    HeaderCondition(String header) {
        this._header = header;
    }

    public String getTagName() {
        return "header";
    }

    public void setRegexp(Pattern pattern) {
        this._regexp = pattern;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this._caseInsensitive = caseInsensitive;
    }

    public void setSendVary(boolean sendVary) {
        this._sendVary = sendVary;
    }

    @PostConstruct
    public void init() {
        if (this._regexp != null && this._caseInsensitive) {
            this._regexp = Pattern.compile(this._regexp.pattern(), 2);
        }
    }

    public boolean isMatch(HttpServletRequest request, HttpServletResponse response) {
        String value;
        if (this._sendVary) {
            this.addHeaderValue(response, "Vary", this._header);
        }
        if ((value = request.getHeader(this._header)) == null) {
            return false;
        }
        return this._regexp == null || this._regexp.matcher(value).find();
    }
}

