/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.rewrite;

import com.caucho.config.ConfigException;
import com.caucho.server.dispatch.MovedFilterChain;
import com.caucho.server.rewrite.AbstractRuleWithConditions;
import com.caucho.server.rewrite.FilterChainMapper;
import com.caucho.server.rewrite.RewriteDispatch;
import java.util.regex.Matcher;
import javax.servlet.FilterChain;

public class MovedRule
extends AbstractRuleWithConditions {
    private String _tagName;
    private int _code;
    private String _target;

    public MovedRule(RewriteDispatch rewriteDispatch, int statusCode) {
        super(rewriteDispatch);
        this._code = statusCode;
        this._tagName = "moved(" + statusCode + ")";
    }

    public String getTagName() {
        return this._tagName;
    }

    public void setTarget(String target) {
        this._target = target;
    }

    public String rewrite(String uri, Matcher matcher) {
        return matcher == null ? this._target : matcher.replaceAll(this._target);
    }

    public FilterChain dispatch(String uri, String queryString, FilterChain accept, FilterChainMapper next) {
        return new MovedFilterChain(this._code, uri);
    }

    public void init() throws ConfigException {
        super.init();
        this.required(this._target, "target");
    }
}

