/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.security;

import com.caucho.server.security.AbstractConstraint;
import com.caucho.server.security.AuthorizationResult;
import com.caucho.server.security.TransportConstraint;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ContainerConstraint
extends AbstractConstraint {
    private boolean _needsAuthentication;
    private ArrayList<AbstractConstraint> _constraints = new ArrayList();

    public void init() {
        ArrayList<AbstractConstraint> constraints = new ArrayList<AbstractConstraint>(this._constraints.size());
        for (AbstractConstraint constraint : this._constraints) {
            if (!(constraint instanceof TransportConstraint)) continue;
            constraints.add(constraint);
        }
        for (AbstractConstraint constraint : this._constraints) {
            if (constraint instanceof TransportConstraint) continue;
            constraints.add(constraint);
        }
        this._constraints = constraints;
    }

    public void addConstraint(AbstractConstraint constraint) {
        for (AbstractConstraint subConstraint : constraint.toArray()) {
            this._constraints.add(subConstraint);
            if (!subConstraint.needsAuthentication()) continue;
            this._needsAuthentication = true;
        }
    }

    public boolean needsAuthentication() {
        return this._needsAuthentication;
    }

    public AuthorizationResult isAuthorized(HttpServletRequest request, HttpServletResponse response, ServletContext application) throws ServletException, IOException {
        AuthorizationResult result = AuthorizationResult.NONE;
        for (int i = 0; i < this._constraints.size(); ++i) {
            AbstractConstraint constraint = this._constraints.get(i);
            result = constraint.isAuthorized(request, response, application);
            if (result.isFallthrough()) continue;
            return result;
        }
        return result;
    }

    protected AbstractConstraint[] toArray() {
        return this._constraints.toArray(new AbstractConstraint[this._constraints.size()]);
    }
}

