/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.session;

import com.caucho.cloud.network.ClusterServer;
import com.caucho.management.server.AbstractManagedObject;
import com.caucho.management.server.PersistentStoreMXBean;
import com.caucho.management.server.SessionManagerMXBean;
import com.caucho.management.server.WebAppMXBean;
import com.caucho.server.cluster.ServletService;
import com.caucho.server.session.SessionManager;
import com.caucho.server.webapp.WebApp;

public class SessionManagerAdmin
extends AbstractManagedObject
implements SessionManagerMXBean {
    private final SessionManager _manager;

    public SessionManagerAdmin(SessionManager manager) {
        this._manager = manager;
        this.registerSelf();
    }

    public String getName() {
        return null;
    }

    public WebAppMXBean getWebApp() {
        return this._manager.getWebApp().getAdmin();
    }

    public boolean isAlwaysSaveSession() {
        return this._manager.getAlwaysSaveSession();
    }

    public boolean isCookieAppendServerIndex() {
        return this._manager.isCookieAppendServerIndex();
    }

    public String getCookieDomain() {
        return this._manager.getCookieDomain();
    }

    public boolean isCookieHttpOnly() {
        return this._manager.isCookieHttpOnly();
    }

    public long getCookieLength() {
        return this._manager.getCookieLength();
    }

    public long getCookieMaxAge() {
        return this._manager.getCookieMaxAge();
    }

    public String getCookieName() {
        return this._manager.getCookieName();
    }

    public String getCookiePort() {
        return this._manager.getCookiePort();
    }

    public boolean isCookieSecure() {
        return this._manager.isCookieSecure();
    }

    public int getCookieVersion() {
        return this._manager.getCookieVersion();
    }

    public boolean isEnableCookies() {
        return this._manager.enableSessionCookies();
    }

    public boolean isEnableURLRewriting() {
        return this._manager.enableSessionUrls();
    }

    public boolean isIgnoreSerializationErrors() {
        return this._manager.getIgnoreSerializationErrors();
    }

    public boolean isInvalidateAfterListener() {
        return this._manager.isInvalidateAfterListener();
    }

    public boolean isReuseSessionId() {
        return this._manager.getReuseSessionId() != 0;
    }

    public String getSaveMode() {
        return this._manager.getSaveMode();
    }

    public int getSessionMax() {
        return this._manager.getSessionMax();
    }

    public long getSessionTimeout() {
        return this._manager.getSessionTimeout();
    }

    public PersistentStoreMXBean getPersistentStore() {
        return null;
    }

    public int getActiveSessionCount() {
        return this._manager.getActiveSessionCount();
    }

    public long getSessionActiveCount() {
        return this._manager.getSessionActiveCount();
    }

    public long getSessionCreateCountTotal() {
        return this._manager.getSessionCreateCount();
    }

    public long getSessionInvalidateCountTotal() {
        return this._manager.getSessionInvalidateCount();
    }

    public long getSessionTimeoutCountTotal() {
        return this._manager.getSessionTimeoutCount();
    }

    public String getSessionStoreType() {
        return "unknown";
    }

    public String sessionSerializationDebug(String id) {
        return this._manager.getSessionSerializationDebug(id);
    }

    public String sessionAsJsonString(String id) {
        return this._manager.getSessionAsJsonString(id);
    }

    public String[] sessionIdList() {
        return this._manager.sessionIdList();
    }

    public String sessionsAsJsonString() {
        return this._manager.getSessionsAsJsonString();
    }

    public long getEstimatedMemorySize() {
        return this._manager.getEstimatedMemorySize();
    }

    public int stickySessionServer(String sessionId, int count) {
        int hash = SessionManager.getServerCode(sessionId, count);
        WebApp webApp = this._manager.getWebApp();
        ServletService servlet = webApp.getServer();
        ClusterServer server = servlet.getSelfServer();
        return hash % server.getCloudPod().getServerLength();
    }

    public void unregister() {
        this.unregisterSelf();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getObjectName() + "]";
    }
}

