/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.snmp.types;

import com.caucho.server.snmp.types.SnmpValue;

public class IntegerValue
extends SnmpValue {
    public static final IntegerValue ZERO = new IntegerValue(0);
    int _value;

    public IntegerValue(int value) {
        this._value = value;
    }

    public long getLong() {
        return this._value;
    }

    public int getType() {
        return 2;
    }

    public void toAsn1(StringBuilder sb) {
        int len = this.length();
        this.header(sb, len);
        assert (len < 5);
        int value = this._value;
        for (int i = 0; i < len; ++i) {
            value = this._value >> (len - i - 1) * 8;
            sb.append((char)(value & 0xFF));
        }
    }

    private int length() {
        int length = 1;
        int value = this._value;
        if (value != 0) {
            while ((value /= 256) != 0) {
                ++length;
            }
        }
        return length;
    }

    public boolean equals(Object obj) {
        return obj instanceof IntegerValue && this._value == ((IntegerValue)obj)._value;
    }

    public String toString() {
        return String.valueOf(this._value);
    }
}

