/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.snmp.types;

import com.caucho.server.snmp.types.SnmpValue;

public abstract class UnsignedIntegerValue
extends SnmpValue {
    protected long _value;

    public UnsignedIntegerValue(long value) {
        this._value = value;
    }

    public long getLong() {
        return this._value;
    }

    public void toAsn1(StringBuilder sb) {
        int len = this.length();
        this.header(sb, len);
        long value = this._value;
        for (int i = 0; i < len; ++i) {
            value = this._value >> (len - i - 1) * 8;
            sb.append((char)(value & 0xFFL));
        }
    }

    private int length() {
        if (this._value <= 255L) {
            return 1;
        }
        if (this._value <= 65535L) {
            return 2;
        }
        if (this._value <= 0xFFFFFFL) {
            return 3;
        }
        return 4;
    }

    public String toString() {
        return String.valueOf(this._value);
    }
}

