/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.util;

import com.caucho.VersionFactory;
import com.caucho.java.WorkDir;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.server.util.JniCauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.Crc64;
import com.caucho.util.CurrentTime;
import com.caucho.util.ThreadDump;
import com.caucho.vfs.CaseInsensitive;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CauchoSystem {
    static EnvironmentLocal<String> _serverIdLocal = new EnvironmentLocal("caucho.server-id");
    public static int EXIT_BIND = 2;
    public static int EXIT_OOM = 3;
    public static int EXIT_DEADLOCK = 4;
    public static int EXIT_OTHER = 5;
    static char _separatorChar = File.separatorChar;
    static char _pathSeparatorChar = File.pathSeparatorChar;
    static String _localHost;
    static String _userDir;
    static String _userName;
    static Path _resinHome;
    static Path _rootDirectory;
    static boolean _isTesting;
    static boolean _isTestWindows;
    static boolean _hasJni;
    static boolean _isResin;
    static String _resinVersion;
    static String _resinFullVersion;
    private static String[] PROPERTIES_64;
    private static int _isUnix;
    private static String _newline;
    private static long _version;
    private static JniCauchoSystem _jniCauchoSystem;
    private static boolean _isDetailedStatistics;
    private static String _classPath;
    private static ArrayList<String> _classPathList;

    private CauchoSystem() {
    }

    public static boolean isTesting() {
        return _isTesting;
    }

    public static void setIsTesting(boolean testing) {
        _isTesting = testing;
    }

    public static void setResinHome(Path path) {
        _resinHome = path;
    }

    public static Path getResinHome() {
        int pathSep;
        if (_resinHome != null) {
            return _resinHome;
        }
        String path = System.getProperty("resin.home");
        if (path != null) {
            _resinHome = Vfs.lookupNative(path);
            return _resinHome;
        }
        String classpath = System.getProperty("java.class.path");
        int head = 0;
        char sep = CauchoSystem.getFileSeparatorChar();
        int n = pathSep = sep == '/' ? 58 : 59;
        while (path == null) {
            int p = classpath.indexOf(pathSep, head);
            String subpath = p < 0 ? classpath.substring(head) : classpath.substring(head, p);
            if (subpath.endsWith(sep + "lib" + sep + "resin.jar") || subpath.equals("lib" + sep + "resin.jar")) {
                path = subpath.substring(0, subpath.length() - ("lib" + sep + "resin.jar").length());
            } else if (subpath.endsWith(sep + "classes") || subpath.equals("classes")) {
                Path resinPath = Vfs.lookupNative(subpath);
                if ((resinPath = resinPath.lookup("com/caucho/util/CauchoSystem.class")).exists()) {
                    path = subpath.substring(0, subpath.length() - "classes".length());
                }
            }
            if (p < 0) break;
            head = p + 1;
        }
        if (path != null) {
            _resinHome = Vfs.lookupNative(path);
        }
        if (_resinHome != null && _resinHome.isDirectory()) {
            return _resinHome;
        }
        return Vfs.lookup();
    }

    public static String getVersion() {
        if (_resinVersion == null) {
            _resinVersion = VersionFactory.getVersion();
        }
        return _resinVersion;
    }

    public static String getFullVersion() {
        if (_resinFullVersion == null) {
            _resinFullVersion = VersionFactory.getFullVersion();
        }
        return _resinFullVersion;
    }

    public static long getVersionId() {
        if (_version == 0L) {
            _version = Crc64.generate(CauchoSystem.getFullVersion());
        }
        return _version;
    }

    public static String getResinConfig() {
        return CauchoSystem.getResinHome() + "/conf/resin.conf";
    }

    public static Path getWorkPath() {
        Path workPath = WorkDir.getLocalWorkDir();
        if (workPath != null) {
            return workPath;
        }
        Path path = WorkDir.getTmpWorkDir();
        try {
            path.mkdirs();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return path;
    }

    public static String getServerId() {
        return _serverIdLocal.get();
    }

    public static String getUserDir() {
        if (_userDir == null) {
            _userDir = System.getProperty("user.dir");
        }
        return _userDir;
    }

    public static char getFileSeparatorChar() {
        return _separatorChar;
    }

    public static char getPathSeparatorChar() {
        return _pathSeparatorChar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getNewlineString() {
        if (_newline == null) {
            Thread thread = Thread.currentThread();
            ClassLoader oldLoader = thread.getContextClassLoader();
            try {
                thread.setContextClassLoader(ClassLoader.getSystemClassLoader());
                _newline = System.getProperty("line.separator");
                if (_newline == null) {
                    _newline = CauchoSystem.isWindows() ? "\r\n" : "\n";
                }
                Object var3_2 = null;
                thread.setContextClassLoader(oldLoader);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                thread.setContextClassLoader(oldLoader);
                throw throwable;
            }
        }
        return _newline;
    }

    public static boolean isWindows() {
        return _separatorChar == '\\' || _isTestWindows;
    }

    public static boolean isTest() {
        return CurrentTime.isTest();
    }

    public static boolean isCaseInsensitive() {
        return CaseInsensitive.isCaseInsensitive();
    }

    public static boolean isUnix() {
        if (_isUnix >= 0) {
            return _isUnix == 1;
        }
        _isUnix = 0;
        if (_separatorChar == '/' && Vfs.lookup("/bin/sh").canRead()) {
            _isUnix = 1;
        }
        return _isUnix == 1;
    }

    public static void setWindowsTest(boolean isWindows) {
        _isTesting = true;
        _isTestWindows = isWindows;
        Path.setTestWindows(isWindows);
    }

    public static String getLocalHost() {
        if (_localHost != null) {
            return _localHost;
        }
        try {
            InetAddress addr = InetAddress.getLocalHost();
            _localHost = addr.getHostName();
        }
        catch (Exception e) {
            _localHost = "127.0.0.1";
        }
        return _localHost;
    }

    public static boolean isJdk15() {
        try {
            return Class.forName("java.lang.annotation.Annotation") != null;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static String getUserName() {
        if (_userName == null) {
            _userName = System.getProperty("user.name");
        }
        return _userName;
    }

    public static void setDetailedStatistics(boolean isVerboseStatistics) {
        _isDetailedStatistics = isVerboseStatistics;
    }

    public static boolean isDetailedStatistics() {
        return _isDetailedStatistics;
    }

    public static Class<?> loadClass(String name) throws ClassNotFoundException {
        return CauchoSystem.loadClass(name, false, null);
    }

    public static Class<?> loadClass(String name, boolean init, ClassLoader loader) throws ClassNotFoundException {
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        if (loader == null || loader.equals(CauchoSystem.class.getClassLoader())) {
            return Class.forName(name);
        }
        return Class.forName(name, init, loader);
    }

    public static String getClassPath() {
        if (_classPath != null) {
            return _classPath;
        }
        String cp = System.getProperty("java.class.path");
        String boot = System.getProperty("sun.boot.class.path");
        if (boot != null && !boot.equals("")) {
            cp = cp + File.pathSeparatorChar + boot;
        }
        Pattern pattern = Pattern.compile("" + File.pathSeparatorChar);
        String[] path = pattern.split(cp);
        CharBuffer cb = new CharBuffer();
        for (int i = 0; i < path.length; ++i) {
            Path subpath = Vfs.lookup(path[i]);
            if (!subpath.canRead() && !subpath.isDirectory()) continue;
            if (cb.length() > 0) {
                cb.append(File.pathSeparatorChar);
            }
            cb.append(path[i]);
        }
        _classPath = cb.toString();
        return _classPath;
    }

    public static ArrayList<String> getClassPathList() {
        if (_classPathList != null) {
            return _classPathList;
        }
        ArrayList<String> list = new ArrayList<String>();
        String classPath = CauchoSystem.getClassPath();
        String[] classPathArray = classPath.split("[" + CauchoSystem.getPathSeparatorChar() + "]");
        for (int i = 0; i < classPathArray.length; ++i) {
            if (list.contains(classPathArray[i])) continue;
            list.add(classPathArray[i]);
        }
        _classPathList = list;
        return _classPathList;
    }

    public static double getLoadAvg() {
        if (_jniCauchoSystem == null) {
            _jniCauchoSystem = JniCauchoSystem.create();
        }
        return _jniCauchoSystem.getLoadAvg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exitOom(Class<?> cl, Throwable e) {
        try {
            System.err.println(cl + " Resin restarting due to OutOfMemoryError " + e);
            ThreadDump.create().dumpThreads();
            Object var3_2 = null;
            Runtime.getRuntime().halt(EXIT_OOM);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Runtime.getRuntime().halt(EXIT_OOM);
            throw throwable;
        }
    }

    public static boolean is64Bit() {
        for (String prop : PROPERTIES_64) {
            String value = System.getProperty(prop);
            if (value == null || value.indexOf("64") < 0) continue;
            return true;
        }
        return false;
    }

    static {
        PROPERTIES_64 = new String[]{"sun.arch.data.model", "com.ibm.vm.bitmodel", "os.arch"};
        _isUnix = -1;
    }
}

