/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.util;

import com.caucho.config.inject.SingletonBindingHandle;
import com.caucho.env.thread.ThreadPool;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentListener;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduledThreadPool
implements ScheduledExecutorService,
EnvironmentListener,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(ScheduledThreadPool.class.getName());
    private static L10N L = new L10N(ScheduledThreadPool.class);
    private static EnvironmentLocal<ScheduledThreadPool> _local = new EnvironmentLocal();
    private ThreadPool _threadPool;
    private boolean _isShutdown;
    private boolean _isTerminated;
    private ClassLoader _loader;
    private final Set<Future> _futureSet = new HashSet<Future>();

    private ScheduledThreadPool() {
        this._loader = Thread.currentThread().getContextClassLoader();
        this._threadPool = ThreadPool.getThreadPool();
        if (this._threadPool == null) {
            throw new NullPointerException();
        }
        Environment.addEnvironmentListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScheduledThreadPool getLocal() {
        EnvironmentLocal<ScheduledThreadPool> environmentLocal = _local;
        synchronized (environmentLocal) {
            ScheduledThreadPool pool = _local.getLevel();
            if (pool == null) {
                pool = new ScheduledThreadPool();
                _local.set(pool);
            }
            return pool;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable command) {
        if (this._isShutdown) {
            throw new IllegalStateException("ThreadPool has closed");
        }
        TaskFuture<Object> future = new TaskFuture<Object>(this._loader, command, null);
        Set<Future> set = this._futureSet;
        synchronized (set) {
            this._futureSet.add(future);
            this._threadPool.scheduleExecutorTask(future);
        }
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    public List invokeAll(Collection tasks) {
        throw new UnsupportedOperationException();
    }

    public List invokeAll(Collection tasks, long timeout, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    public Object invokeAny(Collection tasks) {
        throw new UnsupportedOperationException();
    }

    public Object invokeAny(Collection tasks, long timeout, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isShutdown() {
        return this._isShutdown;
    }

    @Override
    public boolean isTerminated() {
        return this._isTerminated;
    }

    @Override
    public void shutdown() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Runnable> shutdownNow() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Future<T> submit(Callable<T> task) {
        if (this._isShutdown) {
            throw new IllegalStateException("ThreadPool has closed");
        }
        TaskFuture<T> future = new TaskFuture<T>(this._loader, task);
        Set<Future> set = this._futureSet;
        synchronized (set) {
            this._futureSet.add(future);
            this._threadPool.scheduleExecutorTask(future);
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<?> submit(Runnable command) {
        if (this._isShutdown) {
            throw new IllegalStateException(L.l("Can't submit after ThreadPool has closed"));
        }
        TaskFuture<Object> future = new TaskFuture<Object>(this._loader, command, null);
        Set<Future> set = this._futureSet;
        synchronized (set) {
            this._futureSet.add(future);
            this._threadPool.scheduleExecutorTask(future);
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        if (this._isShutdown) {
            throw new IllegalStateException(L.l("Can't submit after ThreadPool has closed"));
        }
        TaskFuture<T> future = new TaskFuture<T>(this._loader, task, result);
        Set<Future> set = this._futureSet;
        synchronized (set) {
            this._futureSet.add(future);
            this._threadPool.scheduleExecutorTask(future);
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        if (this._isShutdown) {
            throw new IllegalStateException(L.l("Can't submit after ThreadPool has closed"));
        }
        long initialExpires = CurrentTime.getCurrentTime() + unit.toMillis(delay);
        AlarmFuture<V> future = new AlarmFuture<V>(this._loader, callable, initialExpires, 0L, 0L);
        Set<Future> set = this._futureSet;
        synchronized (set) {
            this._futureSet.add(future);
        }
        future.queue();
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        if (this._isShutdown) {
            throw new IllegalStateException(L.l("Can't submit after ThreadPool has closed"));
        }
        long initialExpires = CurrentTime.getCurrentTime() + unit.toMillis(delay);
        AlarmFuture future = new AlarmFuture(this._loader, command, initialExpires, 0L, 0L);
        Set<Future> set = this._futureSet;
        synchronized (set) {
            this._futureSet.add(future);
        }
        future.queue();
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        if (this._isShutdown) {
            throw new IllegalStateException(L.l("Can't submit after ThreadPool has closed"));
        }
        long initialExpires = CurrentTime.getExactTime() + unit.toMillis(initialDelay);
        AlarmFuture future = new AlarmFuture(this._loader, command, initialExpires, unit.toMillis(period), 0L);
        Set<Future> set = this._futureSet;
        synchronized (set) {
            this._futureSet.add(future);
        }
        future.queue();
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        if (this._isShutdown) {
            throw new IllegalStateException(L.l("Can't submit after ThreadPool has closed"));
        }
        long initialExpires = CurrentTime.getCurrentTime() + unit.toMillis(initialDelay);
        AlarmFuture future = new AlarmFuture(this._loader, command, initialExpires, 0L, unit.toMillis(delay));
        Set<Future> set = this._futureSet;
        synchronized (set) {
            this._futureSet.add(future);
        }
        future.queue();
        return future;
    }

    public Timer getTimer() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop() {
        this._isShutdown = true;
        this._loader = null;
        this._threadPool = null;
        while (true) {
            Future future = null;
            Set<Future> set = this._futureSet;
            synchronized (set) {
                Iterator<Future> iter = this._futureSet.iterator();
                if (!iter.hasNext()) {
                    break;
                }
                future = iter.next();
                this._futureSet.remove(future);
            }
            if (future == null) continue;
            future.cancel(true);
        }
        this._futureSet.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFuture(Future future) {
        boolean isFuture;
        Set<Future> set = this._futureSet;
        synchronized (set) {
            isFuture = this._futureSet.remove(future);
        }
        if (isFuture) {
            future.cancel(true);
        }
    }

    @Override
    public void environmentConfigure(EnvironmentClassLoader loader) {
    }

    @Override
    public void environmentBind(EnvironmentClassLoader loader) {
    }

    @Override
    public void environmentStart(EnvironmentClassLoader loader) {
    }

    @Override
    public void environmentStop(EnvironmentClassLoader loader) {
        this.stop();
    }

    public Object writeReplace() {
        return new SingletonBindingHandle(ScheduledExecutorService.class, new Annotation[0]);
    }

    public String toString() {
        if (this._loader instanceof EnvironmentClassLoader) {
            return this.getClass().getSimpleName() + "[" + ((EnvironmentClassLoader)this._loader).getId() + "]";
        }
        return this.getClass().getSimpleName() + "[" + this._loader + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AlarmFuture<T>
    implements ScheduledFuture<T>,
    AlarmListener {
        private final String _name;
        private final ClassLoader _loader;
        private final Callable<T> _callable;
        private final Runnable _runnable;
        private final Alarm _alarm;
        private final long _initialExpires;
        private final long _period;
        private final long _delay;
        private long _nextTime;
        private Thread _thread;
        private boolean _isCancelled;
        private boolean _isDone;
        private int _alarmCount;
        private Exception _exception;
        private T _value;

        AlarmFuture(ClassLoader loader, Callable<T> callable, long initialExpires, long period, long delay) {
            this._name = "Scheduled[" + callable + "]";
            this._loader = loader;
            this._callable = callable;
            this._runnable = null;
            this._initialExpires = initialExpires;
            this._period = period;
            this._delay = delay;
            this._nextTime = initialExpires;
            this._alarm = new Alarm(this._name, (AlarmListener)this, loader);
        }

        AlarmFuture(ClassLoader loader, Runnable runnable, long initialExpires, long period, long delay) {
            this._name = "Scheduled[" + runnable + "]";
            this._loader = loader;
            this._callable = null;
            this._runnable = runnable;
            this._initialExpires = initialExpires;
            this._period = period;
            this._delay = delay;
            this._alarm = new Alarm(this._name, (AlarmListener)this, loader);
        }

        void queue() {
            if (!ScheduledThreadPool.this._isShutdown) {
                this._alarm.queueAt(this._initialExpires);
            }
        }

        @Override
        public boolean isCancelled() {
            return this._isCancelled;
        }

        @Override
        public boolean isDone() {
            return this._isDone;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            long delay = this._nextTime - CurrentTime.getCurrentTime();
            return TimeUnit.MILLISECONDS.convert(delay, unit);
        }

        @Override
        public int compareTo(Delayed b) {
            long delta = this.getDelay(TimeUnit.MILLISECONDS) - b.getDelay(TimeUnit.MILLISECONDS);
            if (delta < 0L) {
                return -1;
            }
            if (delta > 0L) {
                return 1;
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(boolean mayInterrupt) {
            AlarmFuture alarmFuture = this;
            synchronized (alarmFuture) {
                if (this._isCancelled || this._isDone) {
                    return false;
                }
                this._isCancelled = true;
                this._alarm.dequeue();
                this.notifyAll();
            }
            ScheduledThreadPool.this.removeFuture(this);
            Thread thread = this._thread;
            if (mayInterrupt && thread != null) {
                thread.interrupt();
            }
            return true;
        }

        void close() {
            this._isDone = true;
            this._alarm.dequeue();
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            try {
                return this.get(0x3FFFFFFFFFFFFFFFL, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                throw new IllegalStateException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            long expire = CurrentTime.getCurrentTimeActual() + unit.toMillis(timeout);
            int count = this._alarmCount;
            while (!(this._isDone || this._isCancelled || count != this._alarmCount || CurrentTime.getCurrentTimeActual() >= expire || Thread.currentThread().isInterrupted())) {
                AlarmFuture alarmFuture = this;
                synchronized (alarmFuture) {
                    long delta = expire - CurrentTime.getCurrentTimeActual();
                    if (delta > 0L) {
                        this.wait(delta);
                    }
                }
            }
            if (this._exception != null) {
                throw new ExecutionException(this._exception);
            }
            if (this._isDone || count != this._alarmCount) {
                return this._value;
            }
            if (this._isCancelled) {
                throw new CancellationException();
            }
            throw new TimeoutException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void handleAlarm(Alarm alarm) {
            AlarmFuture alarmFuture;
            if (this._isCancelled) return;
            if (this._isDone) return;
            if (ScheduledThreadPool.this._isShutdown) {
                return;
            }
            this._thread = Thread.currentThread();
            ClassLoader oldLoader = this._thread.getContextClassLoader();
            String oldName = this._thread.getName();
            try {
                try {
                    this._thread.setContextClassLoader(this._loader);
                    this._thread.setName(this._name);
                    if (this._callable != null) {
                        this._value = this._callable.call();
                    }
                    this._runnable.run();
                }
                catch (Exception e) {
                    log.log(Level.FINE, e.toString(), e);
                    this._exception = e;
                    this._isCancelled = true;
                    Object var6_5 = null;
                    this._thread.setContextClassLoader(oldLoader);
                    this._thread.setName(oldName);
                    this._thread = null;
                    AlarmFuture alarmFuture3 = this;
                    synchronized (alarmFuture3) {
                        ++this._alarmCount;
                        if (this._isCancelled || this._isDone || ScheduledThreadPool.this._isShutdown) {
                            ScheduledThreadPool.this.removeFuture(this);
                        } else if (this._delay > 0L) {
                            this._nextTime = CurrentTime.getCurrentTime() + this._delay;
                            if (!(ScheduledThreadPool.this._isShutdown || this._isDone || this._isCancelled)) {
                                this._alarm.queue(this._delay);
                            }
                        } else if (this._period > 0L) {
                            long next;
                            long now = CurrentTime.getCurrentTime();
                            do {
                                if ((next = this._initialExpires + (long)this._alarmCount * this._period) >= now) continue;
                                ++this._alarmCount;
                            } while (next < now);
                            this._alarm.queueAt(next);
                        } else {
                            this._isDone = true;
                            ScheduledThreadPool.this.removeFuture(this);
                        }
                        this.notifyAll();
                        return;
                    }
                }
                Object var6_4 = null;
                this._thread.setContextClassLoader(oldLoader);
                this._thread.setName(oldName);
                this._thread = null;
                alarmFuture = this;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this._thread.setContextClassLoader(oldLoader);
                this._thread.setName(oldName);
                this._thread = null;
                AlarmFuture alarmFuture2 = this;
                synchronized (alarmFuture2) {
                    ++this._alarmCount;
                    if (this._isCancelled || this._isDone || ScheduledThreadPool.this._isShutdown) {
                        ScheduledThreadPool.this.removeFuture(this);
                    } else if (this._delay > 0L) {
                        this._nextTime = CurrentTime.getCurrentTime() + this._delay;
                        if (!(ScheduledThreadPool.this._isShutdown || this._isDone || this._isCancelled)) {
                            this._alarm.queue(this._delay);
                        }
                    } else if (this._period > 0L) {
                        long next;
                        long now = CurrentTime.getCurrentTime();
                        do {
                            if ((next = this._initialExpires + (long)this._alarmCount * this._period) >= now) continue;
                            ++this._alarmCount;
                        } while (next < now);
                        this._alarm.queueAt(next);
                    } else {
                        this._isDone = true;
                        ScheduledThreadPool.this.removeFuture(this);
                    }
                    this.notifyAll();
                    throw throwable;
                }
            }
            synchronized (alarmFuture) {
                ++this._alarmCount;
                if (this._isCancelled || this._isDone || ScheduledThreadPool.this._isShutdown) {
                    ScheduledThreadPool.this.removeFuture(this);
                } else if (this._delay > 0L) {
                    this._nextTime = CurrentTime.getCurrentTime() + this._delay;
                    if (!(ScheduledThreadPool.this._isShutdown || this._isDone || this._isCancelled)) {
                        this._alarm.queue(this._delay);
                    }
                } else if (this._period > 0L) {
                    long next;
                    long now = CurrentTime.getCurrentTime();
                    do {
                        if ((next = this._initialExpires + (long)this._alarmCount * this._period) >= now) continue;
                        ++this._alarmCount;
                    } while (next < now);
                    this._alarm.queueAt(next);
                } else {
                    this._isDone = true;
                    ScheduledThreadPool.this.removeFuture(this);
                }
                this.notifyAll();
                return;
            }
        }

        public String toString() {
            Object task;
            Object object = task = this._callable != null ? this._callable : this._runnable;
            if (this._isDone) {
                return "AlarmFuture[" + task + ",done]";
            }
            if (this._thread != null) {
                if (CurrentTime.isTest()) {
                    return "AlarmFuture[" + task + ",active]";
                }
                return "AlarmFuture[" + task + "," + this._thread + "]";
            }
            if (this._isCancelled) {
                return "AlarmFuture[" + task + ",cancelled]";
            }
            return "AlarmFuture[" + task + ",pending]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TaskFuture<T>
    implements Future<T>,
    Runnable {
        private final ClassLoader _loader;
        private final Callable<T> _callable;
        private final Runnable _runnable;
        private Thread _thread;
        private boolean _isCancelled;
        private boolean _isDone;
        private Exception _exception;
        private T _value;

        TaskFuture(ClassLoader loader, Callable<T> callable) {
            if (callable == null) {
                throw new NullPointerException();
            }
            this._loader = loader;
            this._callable = callable;
            this._runnable = null;
        }

        TaskFuture(ClassLoader loader, Runnable runnable, T result) {
            if (runnable == null) {
                throw new NullPointerException();
            }
            this._loader = loader;
            this._callable = null;
            this._runnable = runnable;
            this._value = result;
        }

        @Override
        public boolean isCancelled() {
            return this._isCancelled;
        }

        @Override
        public boolean isDone() {
            return this._isDone;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(boolean mayInterrupt) {
            TaskFuture taskFuture = this;
            synchronized (taskFuture) {
                if (this._isCancelled || this._isDone) {
                    return false;
                }
                this._isCancelled = true;
                ScheduledThreadPool.this.removeFuture(this);
                this.notifyAll();
            }
            Thread thread = this._thread;
            if (mayInterrupt && thread != null) {
                thread.interrupt();
            }
            return true;
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            try {
                return this.get(0x3FFFFFFFFFFFFFFFL, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                throw new IllegalStateException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            long expire = CurrentTime.getCurrentTime() + unit.toMillis(timeout);
            TaskFuture taskFuture = this;
            synchronized (taskFuture) {
                while (!(this._isDone || this._isCancelled || CurrentTime.getCurrentTime() >= expire || Thread.currentThread().isInterrupted())) {
                    if (!CurrentTime.isTest()) {
                        long delta = expire - CurrentTime.getCurrentTime();
                        if (delta <= 0L) continue;
                        this.wait(expire - CurrentTime.getCurrentTime());
                        continue;
                    }
                    this.wait(1000L);
                    break;
                }
            }
            if (this._exception != null) {
                throw new ExecutionException(this._exception);
            }
            if (this._isDone) {
                return this._value;
            }
            if (this._isCancelled) {
                throw new CancellationException();
            }
            throw new TimeoutException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            ClassLoader oldLoader;
            Thread thread;
            block20: {
                this._thread = thread = Thread.currentThread();
                oldLoader = thread.getContextClassLoader();
                try {
                    block19: {
                        try {
                            block23: {
                                block22: {
                                    if (this._isCancelled || this._isDone) break block22;
                                    if (!ScheduledThreadPool.this._isShutdown) break block23;
                                }
                                Object var5_3 = null;
                                break block19;
                            }
                            thread.setContextClassLoader(this._loader);
                            if (this._callable != null) {
                                this._value = this._callable.call();
                                break block20;
                            }
                            if (this._runnable != null) {
                                this._runnable.run();
                            }
                            break block20;
                        }
                        catch (RuntimeException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            this._exception = e;
                            Object var5_5 = null;
                            thread.setContextClassLoader(oldLoader);
                            this._thread = null;
                            this._isDone = true;
                            ThreadPool threadPool = ScheduledThreadPool.this._threadPool;
                            if (threadPool != null) {
                                threadPool.completeExecutorTask();
                            }
                            ScheduledThreadPool.this.removeFuture(this);
                            TaskFuture taskFuture = this;
                            synchronized (taskFuture) {
                                this.notifyAll();
                                return;
                            }
                        }
                    }
                    thread.setContextClassLoader(oldLoader);
                    this._thread = null;
                    this._isDone = true;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    thread.setContextClassLoader(oldLoader);
                    this._thread = null;
                    this._isDone = true;
                    ThreadPool threadPool = ScheduledThreadPool.this._threadPool;
                    if (threadPool != null) {
                        threadPool.completeExecutorTask();
                    }
                    ScheduledThreadPool.this.removeFuture(this);
                    TaskFuture taskFuture = this;
                    synchronized (taskFuture) {
                        this.notifyAll();
                        throw throwable;
                    }
                }
                ThreadPool threadPool = ScheduledThreadPool.this._threadPool;
                if (threadPool != null) {
                    threadPool.completeExecutorTask();
                }
                ScheduledThreadPool.this.removeFuture(this);
                TaskFuture taskFuture = this;
                synchronized (taskFuture) {
                    this.notifyAll();
                    return;
                }
            }
            Object var5_4 = null;
            thread.setContextClassLoader(oldLoader);
            this._thread = null;
            this._isDone = true;
            ThreadPool threadPool = ScheduledThreadPool.this._threadPool;
            if (threadPool != null) {
                threadPool.completeExecutorTask();
            }
            ScheduledThreadPool.this.removeFuture(this);
            TaskFuture taskFuture = this;
            synchronized (taskFuture) {
                this.notifyAll();
                return;
            }
        }

        public String toString() {
            Object task;
            Object object = task = this._callable != null ? this._callable : this._runnable;
            if (this._isDone) {
                return "TaskFuture[" + task + ",done]";
            }
            if (this._thread != null) {
                if (CurrentTime.isTest()) {
                    return "TaskFuture[" + task + ",active]";
                }
                return "TaskFuture[" + task + "," + this._thread + "]";
            }
            if (this._isCancelled) {
                return "TaskFuture[" + task + ",cancelled]";
            }
            return "TaskFuture[" + task + ",pending]";
        }
    }
}

